package common.api;

import common.ReturnObject_Err;
import common.YosException;
import common.parameter.parameter;

import java.util.Calendar;

public class YOSOPENAPI extends YOSAPI {

    @Override
    protected Object request_validate(YosRequest request) throws YosException {
        if (getApi().accesstoken()) {
            if (parameter.tokenendtimemillis.getOrDefault(request.getAccesstoken(), 0L) < Calendar.getInstance().getTimeInMillis()) {
                parameter.tokenendtimemillis.remove(request.getAccesstoken());
                parameter.tokenlist.remove(request.getAccesstoken());
                parameter.tokenUserlist.remove(request.getAccesstoken());
                parameter.tokenSessionidlist.remove(request.getAccesstoken());
                return new ReturnObject_Err().setErrCode(-1).setErrMsg("登陆状态已过期，请重新登陆！");
            }
            if (!request.getUserRow().getBoolean("isthirddeveloper")) {
                return new ReturnObject_Err().setErrCode(-1).setErrMsg("无效的开发者账号！");
            }
        }
        return super.request_validate(request);
    }
}
