package common.annotation;

import restcontroller.R;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * API注解，方法中带有此注解时，表示此方法为接口方法，可通过指定的方式进行访问
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface API {
    /*
     * 方法标题
     */
    String title();

    /*
     * 方法说明
     */
    String notes() default "";

    /*
     * 该方法是否需要身份验证，true表示需要身份验证，false表示不需要即为开放方法
     */
    boolean accesstoken() default true;

    /*
     * 接口执行间隔时长，同一角色访问接口时的最短间隔时长,单位毫秒,1000表示1秒。默认为0表示不控制。-1表示使用默认间隔时长.
     * 注：设置了CACHEING注解时该参数设置无效
     */
    long intervaltime() default 0;

    Class apiversion() default R.class;

    /*
    是否过期（弃用），默认为false
     */
    boolean deprecated() default false;
}
