package common;

import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import utility.tools.MessageMonitoringStation;

import java.util.Calendar;

/**
 * 定时任务类父类，所有定时任务类都必须继承该类
 */
public abstract class ServiceController extends BaseClass implements Runnable {
    public long service_runcount = 0;
    public String classname = getClass().getSimpleName();
    public long serviceid = 0;
    public String type = "";

    @Override
    public void run() {
        long starttime = Calendar.getInstance().getTimeInMillis();
        try {
            if (checkService()) {
                service_runcount++;
                String errmessage = "";
                logger.info("自动任务：" + classname + "第" + service_runcount + "次运行");
                SQLFactory.createUpdateSQL(dbConnect, "sys_services").setUniqueid(serviceid).setDateValue("lastruntime").update();
                int successed = 1;
                try {
                    serviceRun();
                } catch (Exception e) {
                    successed = 0;
                    errmessage = e.getMessage() + "\n" + e.getStackTrace()[0].toString();
                    MessageMonitoringStation.send("\n自动任务执行异常！\n" + "任务名称：" + classname + "\n" + "异常原因：" + e.getMessage() + "\n" + "异常位置：\n" + e.getStackTrace()[0].toString() + "\n\n" + "相关人员请及时处理！");
                    logger.error(e);
                } finally {
                    try {
                        UpdateSQL sysServiceUpdate = SQLFactory.createUpdateSQL(dbConnect, "sys_services").setUniqueid(serviceid);
                        sysServiceUpdate.setValue("successed", successed);
                        sysServiceUpdate.setValue("timelong", Calendar.getInstance().getTimeInMillis() - starttime);
                        sysServiceUpdate.setValue("errmessage", errmessage);
                        sysServiceUpdate.setValue("isrestarting", 0);
                        if (type.equalsIgnoreCase("month")) {//每月执行,需要重新加载服务，因为每个月的天数不同
                            Thread.sleep(2000L);
                            InitService.startService(new DBConnect().runSqlQuery("select * from sys_services where classname='" + classname + "'").get(0));
                        } else {
                            sysServiceUpdate.setValue("nextruntime", InitService.getNextRunTime(classname));
                        }
                        sysServiceUpdate.update();
                    } catch (YosException e) {
                        logger.error(e);
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e);
            MessageMonitoringStation.send("\n自动任务执行异常！\n" + "任务名称：" + classname + "\n" + "异常原因：" + e.getMessage() + "\n" + "异常位置：\n" + e.getStackTrace()[0].toString() + "\n\n" + "相关人员请及时处理！");
        } finally {
            InitService.restartErrService();
        }
    }

    public abstract void serviceRun() throws Exception;

    /**
     * 自动任务默认参数设置，仅在系统启动时加载
     *
     * @return
     * @throws Exception
     */
    public ServiceParam paramSet() {
        return null;
    }


    private boolean checkService() throws YosException {
        Rows sys_servicesRows = dbConnect.runSqlQuery("select * from sys_services where classname='" + classname + "'");
        if (sys_servicesRows.isEmpty()) {
            return false;
        }
        Row sys_servicesRow = sys_servicesRows.get(0);
        if (!sys_servicesRow.getBoolean("isused")) {
            return false;
        }
        if (sys_servicesRow.getString("type").equals("once") && service_runcount > 1) {
            return false;
        }
        serviceid = sys_servicesRow.getLong("serviceid");
        type = sys_servicesRow.getString("type");
        return true;
    }


    /**
     * 自动任务默认参数设置
     */
    public class ServiceParam {
        String remarks = "";
        RunType type;
        int count = 1;
        String time;
        boolean isused = false;

        /**
         * 自动任务参数
         *
         * @param remarks 任务描述
         * @param count   时间间隔数
         * @param type    时间单位
         */
        public ServiceParam(String remarks, int count, RunType type) {
            this.remarks = remarks;
            this.count = count;
            this.type = type;
            this.setTime("");
        }

        /**
         * 自动任务参数
         *
         * @param remarks 任务描述
         * @param count   时间间隔数
         * @param type    时间单位
         * @param time    执行时间点
         */
        public ServiceParam(String remarks, int count, RunType type, String time) {
            this.remarks = remarks;
            this.count = count;
            this.type = type;
            this.setTime(time);
        }

        public ServiceParam autoUsed(boolean used) {
            this.isused = used;
            return this;
        }

        private void setTime(String time) {
            if (type.equals(RunType.hour)) {
                this.time = time.isEmpty() ? "00:00" : time;
            } else if (type.equals(RunType.day)) {
                this.time = time.isEmpty() ? "00:00:00" : time;
            } else {
                this.time = "";
            }
        }
    }

    public enum RunType {
        once, second, minute, hour, day, week, month
    }
}
