/**
 *
 */
package common;

import common.data.*;
import common.data.db.DBConnect;
import common.parameter.License;
import org.reflections.Reflections;
import utility.tools.MessageMonitoringStation;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/**
 * @author Administrator
 */
public class InitService extends BaseClass implements Runnable, YosLogger {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;

    @Override
    public void run() {
        try {
            if (isfirstrun) {
                initialize();
                service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);//创建多线程自动任务，线程数为cpu核心数
                service.scheduleWithFixedDelay(new Runnable() {
                    @Override
                    public void run() {
                        InitService.restartErrService();
                    }
                }, 60, 60, TimeUnit.SECONDS);

                logger.info("启动自动任务");
                isfirstrun = false;
                Rows rows = dbConnect.runSqlQuery("select classname,isused,remarks,lastruntime,type,count,time from sys_services");
                for (Row row : rows) {
                    startService(row);
                }
            }
        } catch (YosException e) {
            logger.error(e);
        }
    }

    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap = new HashMap<>();

    public static void startService(Row row) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            String type = row.getString("type");//second,minute,hour,day,month,year
            int count = row.getInteger("count") <= 0 ? 1 : row.getInteger("count");
            boolean isused = row.getBoolean("isused");//是否启用
            if (scheduledFutureMap.containsKey(classname)) {
                logger.info("服务卸载：" + classname + ";" + remarks);
                scheduledFutureMap.get(classname).cancel(false);//待当前任务执行完毕后，再进行取消
                scheduledFutureMap.remove(classname);
            }
            Class<?> clz = Class.forName("service." + classname);
            Constructor<?> cla = clz.getDeclaredConstructor();
            ServiceController controller = (ServiceController) cla.newInstance();
            logger.info("服务加载：" + classname + "," + type + "," + (isused ? "启用" : "停用") + ";" + remarks);

            Calendar calendar = Calendar.getInstance();
            ScheduledFuture<?> scheduledFuture = null;
            long initialDelay = 0;
            switch (type) {
                case "once": {
                    initialDelay = 10;
                    scheduledFuture = service.scheduleWithFixedDelay(controller, initialDelay, 5 * 60L, TimeUnit.SECONDS);
                    break;
                }
                case "second": {
                    initialDelay = 10;
                    scheduledFuture = service.scheduleWithFixedDelay(controller, initialDelay, count, TimeUnit.SECONDS);
                    break;
                }
                case "minute": {
                    initialDelay = 60 - calendar.get(Calendar.SECOND);
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, count * 60L, TimeUnit.SECONDS);
                    break;
                }
                case "hour": {
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00";
                    }
                    String[] times = time.split(":");
                    int schedulesecond = Integer.parseInt(times[0]) * 60 + Integer.parseInt(times[1]);
                    int syssecond = calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                    initialDelay = schedulesecond - syssecond;
                    initialDelay = initialDelay < 0 ? (initialDelay + 60 * 60) : initialDelay;
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, count * 60L * 60L, TimeUnit.SECONDS);
                    break;
                }
                case "day": {
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00:00";
                    }
                    String[] times = time.split(":");
                    int schedulesecond = Integer.parseInt(times[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
                    int syssecond = calendar.get(Calendar.HOUR_OF_DAY) * 60 * 60 + calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                    initialDelay = schedulesecond - syssecond;
                    initialDelay = initialDelay < 0 ? (initialDelay + 60 * 60 * 24) : initialDelay;
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, count * 60L * 60L * 24L, TimeUnit.SECONDS);
                    break;
                }
                case "week": {
                    int day_of_week = row.getInteger("day_of_week");
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00:00";
                    }
                    String[] times = time.split(":");
                    int schedulesecond = day_of_week * 60 * 60 * 24 + Integer.parseInt(times[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
                    int syssecond = (calendar.get(Calendar.DAY_OF_WEEK) - 1) * 60 * 60 * 24 + calendar.get(Calendar.HOUR_OF_DAY) * 60 * 60 + calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                    initialDelay = schedulesecond - syssecond;
                    initialDelay = initialDelay < 0 ? (initialDelay + 60 * 60 * 24 * 7) : initialDelay;
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, count * 60L * 60L * 24L * 7L, TimeUnit.SECONDS);
                    break;
                }
                case "month": {
                    int day_of_month = row.getInteger("day_of_month");
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00:00";
                    }
                    String[] times = time.split(":");
                    int schedulesecond = day_of_month * 60 * 60 * 24 + Integer.parseInt(times[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
                    int syssecond = calendar.get(Calendar.DAY_OF_MONTH) * 60 * 60 * 24 + calendar.get(Calendar.HOUR_OF_DAY) * 60 * 60 + calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                    initialDelay = schedulesecond - syssecond;
                    if (initialDelay < 0) {//当前月执行时间已过,计算到下次执行的时间间隔
                        Calendar nexttime = Calendar.getInstance();
                        nexttime.add(Calendar.MONTH, count);
                        nexttime.set(Calendar.DAY_OF_MONTH, day_of_month);
                        nexttime.set(Calendar.HOUR_OF_DAY, Integer.parseInt(times[0]));
                        nexttime.set(Calendar.MINUTE, Integer.parseInt(times[1]));
                        nexttime.set(Calendar.SECOND, Integer.parseInt(times[2]));
                        initialDelay = (nexttime.getTimeInMillis() - System.currentTimeMillis()) / 1000;
                    }
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, count * 60L * 60L * 24L * 31L, TimeUnit.SECONDS);
                    break;
                }
            }

            if (scheduledFuture != null) {
                scheduledFutureMap.put(classname, scheduledFuture);
                if (!type.equalsIgnoreCase("once")) {
                    if (isused) {
                        calendar.add(Calendar.SECOND, (int) initialDelay);
                        new DBConnect().runSqlUpdate("update sys_services set nextruntime='" + getDateTime_Str(calendar.getTime()) + "' where classname='" + classname + "'");
                    } else {
                        new DBConnect().runSqlUpdate("update sys_services set nextruntime=null where classname='" + classname + "'");
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e);
        }
    }

    private void initialize() {
        try {
            ArrayList<String> servlist = SQLFactory.createQuerySQL(dbConnect, "sys_services").query().toArrayList("classname");

            ArrayList<String> sqlist = new ArrayList<>();
            Reflections reflections = new Reflections("service");
            Set<Class<? extends ServiceController>> subTypes = reflections.getSubTypesOf(ServiceController.class);
            for (Class<? extends ServiceController> clazz : subTypes) {
                String classname = clazz.getSimpleName();
                servlist.remove(classname);
                if (SQLFactory.createQuerySQL(dbConnect, "sys_services").setWhere("classname", classname).query().isEmpty()) {

                    Object obj = clazz.newInstance();
                    ServiceController.ServiceParam paramSet = (ServiceController.ServiceParam) obj.getClass().getMethod("paramSet").invoke(obj);

                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", classname);
                    insertSQL.setValue("isused", paramSet == null ? false : paramSet.isused);
                    insertSQL.setValue("remarks", paramSet == null ? "" : paramSet.remarks);
                    insertSQL.setValue("type", paramSet == null ? "minute" : paramSet.type);
                    insertSQL.setValue("count", paramSet == null ? 1 : paramSet.count);
                    insertSQL.setValue("time", paramSet == null ? "" : paramSet.time);
                    sqlist.add(insertSQL.getSQL());
                }
            }
            sqlist.add(SQLFactory.createDeleteSQL(dbConnect, "sys_services").setWhere("classname", servlist).getSQL());
            new DBConnect().runSqlUpdate(sqlist);
        } catch (Exception e) {
            logger.error(e);
        } finally {
            try {
                //如果是测试服务器，则系统启动时默认关闭所有自动任务
                if (License.get().getLicenseType().equals("Development Certificate")) {
                    dbConnect.runSqlUpdate("update sys_services set isused=0 where classname!='MySqlDataBackUp'");
                }
                dbConnect.runSqlUpdate("update sys_services set nextruntime=null,isrestarting=0");
            } catch (Exception e) {
                logger.error(e);
            }

        }
    }

    /**
     * 获取下一次执行时间
     *
     * @param classname
     * @return
     */
    public static Date getNextRunTime(String classname) {
        try {
            if (InitService.scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> scheduledFuture = InitService.scheduledFutureMap.get(classname);

                Field periodField = scheduledFuture.getClass().getDeclaredField("period");
                periodField.setAccessible(true);
                long period = Math.abs((long) periodField.get(scheduledFuture));

                Field timeField = scheduledFuture.getClass().getDeclaredField("time");
                timeField.setAccessible(true);
                long nextRunTime = (long) timeField.get(scheduledFuture);

                long delayMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nextRunTime + period);
                return new Date(System.currentTimeMillis() + delayMillis);
            }
        } catch (Exception e) {
            logger.error(e);
        }
        return null;
    }

    private static boolean isrestartrunning = false;

    /**
     * 检查有无长时间停止运行的自动任务，如有则尝试启动
     */
    public static void restartErrService() {
        if (!isrestartrunning) {
            isrestartrunning = true;
            new Thread(() -> {
                try {
                    QuerySQL serviceQuery = SQLFactory.createQuerySQL(new DBConnect(), "sys_services");
                    serviceQuery.setWhere("isused", true).setWhere("isrestarting", false).setWhere("type!='once'");
                    serviceQuery.setWhere("lastruntime>'" + getDateTime_Str(ManagementFactory.getRuntimeMXBean().getStartTime()) + "'");
                    serviceQuery.setWhere("DATE_ADD(nextruntime,INTERVAL 5 MINUTE)<now()");
                    Rows rows = serviceQuery.query();
                    for (Row row : rows) {
                        try {
                            long serviceid = row.getLong("serviceid");
                            new DBConnect().runSqlUpdate("update sys_services set isrestarting=1,restartcount=ifnull(restartcount,0)+1 where serviceid='" + serviceid + "'");
                            InitService.startService(row);
                            logger.info("监测到自动任务：" + row.getString("classname") + "在预计执行时间未成功执行，可能停止运行，已重载");
                            MessageMonitoringStation.send("监测到自动任务：" + row.getString("classname") + "在预计执行时间未成功执行，可能停止运行，已重载");
                        } catch (Exception e) {
                            logger.error(e);
                        }
                    }
                    Thread.sleep(1000 * 60);
                } catch (Exception e) {
                    logger.error(e);
                } finally {
                    isrestartrunning = false;
                }
            }).start();
        }
    }
}
