/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.parameter.Parameter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class EasyExcelFactory
extends BaseClass {
    private String filename;
    public static String filetype = "xlsx";
    String filepath = "";
    private InputStream inputStream;

    public EasyExcelFactory(String filename) throws YosException {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : p + "/";
        this.filepath = p + this.filename + "." + filetype;
    }

    public EasyExcelFactory(InputStream inputStream) throws YosException {
        this.filename = String.valueOf(Calendar.getInstance().getTimeInMillis());
        this.inputStream = inputStream;
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : p + "/";
        this.filepath = p + this.filename + "." + filetype;
    }

    public EasyExcelFactory(String filename, InputStream inputStream) throws YosException {
        this.filename = filename;
        this.inputStream = inputStream;
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : p + "/";
        this.filepath = p + this.filename + "." + filetype;
    }

    public EasyExcelFactory(String filename, File file) throws IOException {
        this.filename = filename;
        this.inputStream = new FileInputStream(file);
        this.filepath = file.getPath();
    }

    public void write(String sheetname, Rows datarows) throws YosException {
        this.write(sheetname, datarows, new HashMap<String, String>());
    }

    public void write(String sheetname, Rows datarows, HashMap<String, String> titlemap) throws YosException {
        File parentfile = new File(this.filepath).getParentFile();
        if (!parentfile.exists()) {
            parentfile.mkdirs();
        }
        ArrayList titlelist = new ArrayList();
        for (String fieldname : datarows.getFieldList()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(titlemap.getOrDefault(fieldname, fieldname));
            titlelist.add(list);
        }
        ArrayList<ArrayList<Object>> datalist = datarows.toListList();
        try (ExcelWriter excelWriter = EasyExcel.write((String)this.filepath).build();){
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetname).registerWriteHandler((WriteHandler)this.getStyle())).head(titlelist)).build();
            ArrayList<ArrayList<Object>> datalist_cache = new ArrayList<ArrayList<Object>>();
            int count = 1;
            for (ArrayList<Object> objects : datalist) {
                if (count <= 5000) {
                    datalist_cache.add(objects);
                }
                if (count == 5000) {
                    count = 0;
                    excelWriter.write(datalist_cache, writeSheet);
                    datalist_cache.clear();
                }
                ++count;
            }
            if (!datalist_cache.isEmpty()) {
                excelWriter.write(datalist_cache, writeSheet);
                datalist_cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String sheetname, JSONArray exportFieldsArray, JSONArray dataArrays) throws YosException {
        File parentfile = new File(this.filepath).getParentFile();
        if (!parentfile.exists()) {
            parentfile.mkdirs();
        }
        ArrayList titlelist = new ArrayList();
        ArrayList<String> fieldlist = new ArrayList<String>();
        for (int i = 0; i < exportFieldsArray.size(); ++i) {
            JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);
            ArrayList<String> list = new ArrayList<String>();
            list.add(exportFieldObjet.getStringValue("fieldlabel"));
            titlelist.add(list);
            fieldlist.add(exportFieldObjet.getStringValue("fieldname"));
        }
        try (ExcelWriter excelWriter = EasyExcel.write((String)this.filepath).build();){
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetname).registerWriteHandler((WriteHandler)this.getStyle())).head(titlelist)).build();
            ArrayList datalist_cache = new ArrayList();
            int count = 1;
            for (Object o : dataArrays) {
                JSONObject dataObject = (JSONObject)o;
                ArrayList<Object> datarow = new ArrayList<Object>();
                for (String fieldname : fieldlist) {
                    if (dataObject.get(fieldname) instanceof JSON) {
                        dataObject.put(fieldname, (Object)dataObject.getString(fieldname));
                    }
                    datarow.add(dataObject.getOrDefault(fieldname, ""));
                }
                datalist_cache.add(datarow);
                if (count == 5000) {
                    count = 0;
                    excelWriter.write(datalist_cache, writeSheet);
                    datalist_cache.clear();
                }
                ++count;
            }
            if (!datalist_cache.isEmpty()) {
                excelWriter.write(datalist_cache, writeSheet);
                datalist_cache.clear();
            }
        }
        finally {
            dataArrays.clear();
        }
    }

    public Rows read(ArrayList<String> fieldlist, int rowindex) {
        return this.read(0, fieldlist, new HashMap<String, BaseClass.FieldType>(), rowindex);
    }

    public Rows read(int sheetindex, ArrayList<String> fieldlist, int rowindex) {
        return this.read(sheetindex, fieldlist, new HashMap<String, BaseClass.FieldType>(), rowindex);
    }

    public Rows read(ArrayList<String> fieldlist, HashMap<String, BaseClass.FieldType> celltypemap, int rowindex) {
        return this.read(0, fieldlist, celltypemap, rowindex);
    }

    public Rows read(int sheetindex, final ArrayList<String> fieldlist, final HashMap<String, BaseClass.FieldType> celltypemap, int rowindex) {
        final Rows rows = new Rows();
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)this.inputStream, (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

            public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
                Row row = new Row();
                for (int index : data.keySet()) {
                    String fieldname = (String)fieldlist.get(index);
                    Object value = data.get(index);
                    if (celltypemap.containsKey(fieldname) && value != null) {
                        switch ((BaseClass.FieldType)((Object)celltypemap.get(fieldname))) {
                            case Smallint: 
                            case Int: 
                            case BigInt: {
                                value = Long.parseLong((String)value);
                                break;
                            }
                            case Decimal: {
                                value = Double.parseDouble((String)value);
                                break;
                            }
                            case JSON: {
                                value = JSON.parse((String)value);
                            }
                        }
                    }
                    row.put(fieldname, value);
                }
                rows.add(row);
            }

            public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                try {
                    EasyExcelFactory.this.inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).sheet(Integer.valueOf(sheetindex)).headRowNumber(Integer.valueOf(rowindex))).doRead();
        return rows;
    }

    private HorizontalCellStyleStrategy getStyle() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex()));
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)14));
        headWriteFont.setBold(Boolean.valueOf(true));
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public String getFilename() {
        return this.filename + "." + filetype;
    }

    public String getFilepath() throws YosException {
        return Parameter.get("system_excelexport_path") + this.filename + "." + filetype;
    }

    public File getFile() throws YosException {
        return new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
    }

    public void deletefile() throws YosException {
        File file = new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
        file.delete();
    }
}

