/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.apidoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.SQLiteMemory;
import java.util.Calendar;
import java.util.HashMap;
import restcontroller.R;
import utility.tools.Encryption;

public class apidoc
extends Controller {
    public apidoc(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u5e94\u7528api-\u5e94\u7528\u5173\u8054\u6570\u636e\u8868\u67e5\u8be2", apiversion=R.ID10003601.v1.class)
    public String queryAppTableList() throws YosException {
        long systemappid = this.content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "\u5e94\u7528\u5173\u8054\u6570\u636e\u8868\u67e5\u8be2");
        sqlFactory.addParameter("systemappid", systemappid);
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u5e94\u7528api-\u5e94\u7528\u5173\u8054\u6570\u636e\u8868\u6dfb\u52a0", apiversion=R.ID10003701.v1.class)
    public String addAppTable() throws YosException {
        long systemappid = this.content.getLong("systemappid");
        String table_name = this.content.getString("table_name");
        SQLFactory sqlFactory = new SQLFactory(this, "\u6570\u636e\u8868\u5173\u8054\u5e94\u7528\u6dfb\u52a0");
        sqlFactory.addParameter("sys_objectappsid", this.createTableID("sys_objectapps"));
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("table_name", table_name);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5e94\u7528api-\u5e94\u7528\u5173\u8054\u6570\u636e\u8868\u5220\u9664", apiversion=R.ID10003801.v1.class)
    public String deleteAppTable() throws YosException {
        String sys_objectappsid = this.content.getString("sys_objectappsid");
        this.dbConnect.runSqlUpdate("delete from sys_objectapps where sys_objectappsid=" + sys_objectappsid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5e94\u7528api-\u5e94\u7528\u5173\u8054\u63a5\u53e3\u67e5\u8be2", apiversion=R.ID10003901.v1.class)
    public String queryAppApiList() throws YosException {
        long systemappid = this.content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "\u5e94\u7528\u5173\u8054API\u67e5\u8be2");
        sqlFactory.addParameter("systemappid", systemappid);
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
        HashMap<String, String> codermap = this.getOptionType("coder");
        for (Row row : rows) {
            long apiid = row.getLong("apiid");
            int apiversion = row.getInteger("apiversion");
            row.put("conditionfields", row.getJSONArray("conditionfields"));
            Rows apidocrows = this.dbConnect.runSqlQuery("select requestjson,requestnotes,responsejson,responsenotes from sys_apidoc where apiid='" + apiid + "' and apiversion='" + apiversion + "'");
            if (apidocrows.isEmpty()) {
                JSONObject requestjsonObject = new JSONObject();
                requestjsonObject.put("accesstoken", (Object)Encryption.Encode_MD5(String.valueOf(Calendar.getInstance().getTimeInMillis())));
                requestjsonObject.put("id", (Object)apiid);
                requestjsonObject.put("content", (Object)new JSONObject());
                row.put("requestjson", requestjsonObject);
                row.put("responsejson", new JSONObject());
                row.put("requestnotes", "");
                row.put("responsenotes", "");
            } else {
                row.put("requestjson", apidocrows.get(0).getJSONObject("requestjson"));
                row.put("responsejson", apidocrows.get(0).getJSONObject("responsejson"));
                row.put("requestnotes", apidocrows.get(0).getString("requestnotes"));
                row.put("responsenotes", apidocrows.get(0).getString("responsenotes"));
            }
            if (apiid > 0L) {
                String apiid_str = String.valueOf(apiid);
                row.put("coder", codermap.getOrDefault(apiid_str.substring(apiid_str.length() - 2), ""));
            } else {
                row.put("coder", "");
            }
            try {
                YOSAPI yosapi = YOSAPI.getApi(apiid, apiversion);
                API api = yosapi.getApi();
                String classtitle = "";
                Class clazz = yosapi.getClazz();
                if (clazz.isAnnotationPresent(API.class)) {
                    classtitle = clazz.getAnnotation(API.class).title();
                }
                row.put("classname", clazz.getName().replace("restcontroller.", ""));
                row.put("method", yosapi.getMethod().getName());
                row.put("classtitle", classtitle);
                row.put("title", api.title());
                row.put("notes", api.notes());
                row.put("deprecated", api.deprecated() ? 1 : 0);
                row.put("intervaltime", api.intervaltime());
                row.put("intervaltime_active", yosapi.getApiIntervaltime());
                row.put("accesstoken", api.accesstoken());
                row.put("cacheinglife", yosapi.getCacheing() == null ? "" : Integer.valueOf(yosapi.getCacheing().life()));
                JSONObject requestmsg = new JSONObject();
                Rows requestRows = SQLiteMemory.runSqlQuery("select count() as requesttimes,sum(t1.iscacheing) as readcachetimes,max(runtime)as maxruntime,round(avg(runtime)) avgruntime,max(t1.createdate) as lastrequesttime,runtime as lastruntime from apirequestlog t1 where t1.classname='" + clazz.getName().replace("restcontroller.", "") + "' and t1.method like'" + yosapi.getMethod().getName() + "' order by t1.createdate desc limit 1");
                requestmsg.put("requesttimes", (Object)requestRows.get(0).getLong("requesttimes"));
                requestmsg.put("readcachetimes", (Object)requestRows.get(0).getLong("readcachetimes"));
                requestmsg.put("requesttimelong_last", (Object)requestRows.get(0).getLong("lastruntime"));
                requestmsg.put("requesttimelong_avg", (Object)requestRows.get(0).getBigDecimal("avgruntime").longValue());
                requestmsg.put("lastrequesttime", (Object)requestRows.get(0).getString("lastrequesttime"));
                row.put("requestmsg", requestmsg);
            }
            catch (YosException e) {
                e.printStackTrace();
                row.put("classtitle", "");
                row.put("classname", "");
                row.put("method", "");
                row.put("title", "");
                row.put("notes", "");
                row.put("intervaltime", "");
                row.put("intervaltime_active", "");
                row.put("accesstoken", "");
                row.put("cacheinglife", "");
                JSONObject requestmsg = new JSONObject();
                requestmsg.put("requesttimes", (Object)0);
                requestmsg.put("readcachetimes", (Object)0);
                requestmsg.put("requesttimelong_last", (Object)0);
                requestmsg.put("requesttimelong_avg", (Object)0);
                requestmsg.put("lastrequesttime", (Object)"");
                row.put("requestmsg", requestmsg);
            }
        }
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u5e94\u7528api-\u5e94\u7528\u5173\u8054Api\u6dfb\u52a0", apiversion=R.ID10004001.v1.class)
    public String addAppApi() throws YosException {
        long systemappid = this.content.getLong("systemappid");
        long apiid = this.content.getLong("apiid");
        int apiversion = this.content.getIntValue("apiversion") > 0 ? this.content.getIntValue("apiversion") : 1;
        SQLFactory sqlFactory = new SQLFactory(this, "Api\u5173\u8054\u5e94\u7528\u6dfb\u52a0");
        sqlFactory.addParameter("sys_apiappsid", this.createTableID("sys_apiapps"));
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("apiid", apiid);
        sqlFactory.addParameter("apiversion", apiversion);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5e94\u7528api-\u5e94\u7528\u5173\u8054Api\u5220\u9664", apiversion=R.ID10004101.v1.class)
    public String deleteAppApi() throws YosException {
        long sys_apiappsid = this.content.getLong("sys_apiappsid");
        this.dbConnect.runSqlUpdate("delete from sys_apiapps where sys_apiappsid=" + sys_apiappsid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5e94\u7528api-Api\u6587\u6863\u66f4\u65b0", apiversion=R.ID10004201.v1.class)
    public String updateApiDoc() throws YosException {
        JSONObject responsejson;
        long apiid = this.content.getLongValue("apiid");
        int apiversion = this.content.getIntValue("apiversion");
        JSONObject requestjson = null;
        try {
            requestjson = JSONObject.parseObject((String)this.content.getString("requestjson", true), (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            return this.getErrReturnObject().setErrMsg("\u8bf7\u6c42\u5185\u5bb9\u4e0d\u662f\u6709\u6548\u7684JSONObject\u683c\u5f0f").toString();
        }
        try {
            responsejson = JSONObject.parseObject((String)this.content.getString("responsejson"), (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            return this.getErrReturnObject().setErrMsg("\u54cd\u5e94\u5185\u5bb9\u4e0d\u662f\u6709\u6548\u7684JSONObject\u683c\u5f0f").toString();
        }
        String requestnotes = this.content.getString("requestnotes");
        String responsenotes = this.content.getString("responsenotes");
        if (this.dbConnect.runSqlQuery("select * from sys_apidoc where apiid='" + apiid + "' and apiversion='" + apiversion + "'").isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "Api\u6587\u6863\u65b0\u589e");
            sqlFactory.addParameter("sys_apidocid", this.createTableID("sys_apidoc"));
            sqlFactory.addParameter("apiid", apiid);
            sqlFactory.addParameter("apiversion", apiversion);
            sqlFactory.addParameter("requestjson", requestjson.toJSONString());
            sqlFactory.addParameter("requestnotes", requestnotes);
            sqlFactory.addParameter("responsejson", responsejson.toJSONString());
            sqlFactory.addParameter("responsenotes", responsenotes);
            sqlFactory.addParameter("changeuserid", this.userid);
            this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            this.dbConnect.runSqlUpdate("update sys_apidoc set changedate=now(),changeuserid='" + this.userid + "', requestjson='" + requestjson.toJSONString() + "',requestnotes='" + requestnotes + "', responsejson='" + responsejson.toJSONString() + "',responsenotes='" + responsenotes + "' where apiid='" + apiid + "' and apiversion='" + apiversion + "'");
        }
        return this.getSucReturnObject().toString();
    }
}

