package restcontroller.sysmanage.develop.resources;

import beans.attachment.Attachment;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;

public class resources extends Controller {
    public resources(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统资源列表查询", apiversion = R.ID10024101.v1.class)
    public String queryResourcesList() throws YosException {
        /*
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("resourcename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_resources");
        querySQL.setPage(pageSize, pageNumber);
        querySQL.setWhere(where.toString());
        querySQL.setOrderBy("resourcename,siteid");
        Rows rows = querySQL.query();
        RowsMap attmap = Attachment.get(this, "sys_resources", rows.toArrayList("sys_resourcesid", new ArrayList<>()));
        for (Row row : rows) {
            if (row.getString("type").equals("附件") && attmap.get(row.getString("sys_resourcesid")).isNotEmpty()) {
                Row attrow = attmap.get(row.getString("sys_resourcesid")).getLastRow();
                row.put("url", attrow.getString("url"));
                row.put("attachmentid", attrow.getLong("attachmentid"));
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }


    @API(title = "系统资源删除", apiversion = R.ID10024201.v1.class)
    public String deleteResource() throws YosException {
        long sys_resourcesid = content.getLong("sys_resourcesid");
        dbConnect.runSqlUpdate("delete from sys_resources where sys_resourcesid=" + sys_resourcesid);
        Attachment.delete(this, "sys_resources", sys_resourcesid);
        return getSucReturnObject().toString();
    }

    @API(title = "系统资源新增修改", apiversion = R.ID10024301.v1.class)
    public String insertormodifyResource() throws YosException {
        long sys_resourcesid = content.getLong("sys_resourcesid");
        String siteid = content.getStringValue("siteid");
        String type = content.getString("type");
        String resourcename = content.getString("resourcename");
        String remarks = content.getString("remarks");
        String contentType = content.getString("contentType");
        String url = content.getString("url");
        if (resourcename.equals("") || !String.valueOf(resourcename.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("资源名称必须以小写英文字母开头").toString();
        }
        if (!resourcename.replace("_", "").matches("^[a-z0-9]*")) {
            return getErrReturnObject().setErrMsg("资源名称必须为小写英文字母或英文数字组合").toString();
        }
        if (type.equals("固定网址") && url.equals("")) {
            return getErrReturnObject().setErrMsg("资源类型为固定网址，url不可为空").toString();
        }

        if (sys_resourcesid <= 0 || dbConnect.runSqlQuery("select *from sys_resources where sys_resourcesid=" + sys_resourcesid).isEmpty()) {
            if (dbConnect.runSqlQuery("select *from sys_resources where resourcename='" + resourcename + "' and ifnull(siteid,'')='" + siteid + "'").isNotEmpty()) {
                return getErrReturnObject().setErrMsg("相同站点下不可存在相同名称的资源").toString();
            }
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_resources");
            insertSQL.setValue("siteid", siteid);
            insertSQL.setValue("type", type);
            insertSQL.setValue("resourcename", resourcename);
            insertSQL.setValue("remarks", remarks);
            insertSQL.setValue("url", url);
            insertSQL.setValue("contentType", contentType);
            insertSQL.insert();
        } else {
            if (dbConnect.runSqlQuery("select *from sys_resources where resourcename='" + resourcename + "' and ifnull(siteid,'')='" + siteid + "' and sys_resourcesid!=" + sys_resourcesid).isNotEmpty()) {
                return getErrReturnObject().setErrMsg("相同站点下不可存在相同名称的资源").toString();
            }
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_resources");
            updateSQL.setValue("type", type);
            updateSQL.setValue("remarks", remarks);
            if (type.equals("固定网址")) {
                updateSQL.setValue("url", url);
            } else {
                updateSQL.setValue("url", "");
            }
            updateSQL.setWhere("sys_resourcesid", sys_resourcesid);
            updateSQL.update();
        }

        return getSucReturnObject().toString();
    }

    @API(title = "系统资源查询", apiversion = R.ID10024401.v1.class, accesstoken = false)
    @CACHEING
    public String querySysResource() throws YosException {
        String resourcename = content.getString("resourcename");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_resources", "url", "siteid,type", "sys_resourcesid", "contentType");
        querySQL.setWhere("resourcename", resourcename);
        querySQL.setWhere("resourcename='" + resourcename + "' and( ifnull(siteid,'')='" + siteid + "' or ifnull(siteid,'')='')");
        RowsMap rowsMap = querySQL.query().toRowsMap("siteid");

        Row resourcesRow = null;
        if (rowsMap.containsKey(siteid)) {
            resourcesRow = rowsMap.get(siteid).get(0);
        } else if (rowsMap.containsKey("")) {
            resourcesRow = rowsMap.get("").get(0);
        }
        String url = "";
        if (resourcesRow != null && resourcesRow.getString("type").equals("固定网址")) {
            url = resourcesRow.getString("url");
        }
        if (resourcesRow != null && resourcesRow.getString("type").equals("附件")) {
            Rows attmap = Attachment.get(this, "sys_resources", resourcesRow.getLong("sys_resourcesid"));
            url = attmap.getLastRow().getString("url");
        }
        return getSucReturnObject().setData(url).toString();
    }
}
