package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_site_parameter implements YosObject {
    @Override
    public String table_comment() {
        return "站点参数设置";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_site_parameterid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new SmallIntCol("sys_payswitch", "系统付费开关", 0));
        arrayList.add(new IntCol("sys_payincidence", "付费影响范围（付费类型）1，按账号，2按主体", 1));
        arrayList.add(new IntCol("sys_trialperiod", "系统试用时间（月份）", 0));
        arrayList.add(new VarcharCol("sys_payinstructions", "付费说明", 500));
        arrayList.add(new IntCol("sys_payremind", "到期提醒天数，0不提醒", 0));
        arrayList.add(new IntCol("password_validityperiod", "密码有效期，到期后将提醒用户进行密码修改，0表示不控制", 0));
        arrayList.add(new VarcharCol("accountprefix", "账号前缀", 50));
        arrayList.add(new SmallIntCol("logistics_packingmsg", "物流单是否必填装箱单数据", 1));
        arrayList.add(new SmallIntCol("password_needcapital", "密码是否需要大写英文字母", 0));
        arrayList.add(new SmallIntCol("password_needlowercase", "密码是否需要小写英文字母", 0));
        arrayList.add(new SmallIntCol("loginmode_account", "是否开启账号登陆", 1));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
