package common.data;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class CSVFactory extends BaseClass {
    private String filename;
    public static String filetype = "csv";
    String filepath = "";

    public CSVFactory(String filename) throws YosException {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : (p + "/");
        filepath = p + this.filename + "." + filetype;
    }

    public void write(Rows datarows) throws YosException {
        write(datarows, new HashMap<>());
    }

    public void write(Rows datarows, HashMap<String, String> titlemap) throws YosException {
        try (PrintWriter out = new PrintWriter(new FileWriter(filepath))) {

            ArrayList<String> fieldlist = datarows.getFieldList();
            ArrayList<String> titlelist = new ArrayList<>();
            for (String fieldname : fieldlist) {
                String title = titlemap.getOrDefault(fieldname, fieldname);
                title = title.contains(",") ? ("\"" + title + "\"") : title;
                titlelist.add(title);
            }
            // 写入头部
            String headersLine = String.join(",", titlelist);
            out.println(headersLine);

            // 写入数据
            for (Row row : datarows) {
                List<String> datarow = new ArrayList<>();
                for (String fieldname : fieldlist) {
                    String data = row.getString(fieldname);
                    data = data.contains(",") ? ("\"" + data + "\"") : data;
                    datarow.add(data);
                }
                out.println(String.join(",", datarow));
            }
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(JSONArray exportFieldsArray, JSONArray dataArrays) throws YosException {
        try (PrintWriter out = new PrintWriter(new FileWriter(filepath))) {
            ArrayList<String> titlelist = new ArrayList<>();
            ArrayList<String> fieldlist = new ArrayList<>();
            for (int i = 0; i < exportFieldsArray.size(); i++) {
                JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);

                String title = exportFieldObjet.getStringValue("fieldlabel");
                title = title.contains(",") ? ("\"" + title + "\"") : title;
                titlelist.add(title);
                fieldlist.add(exportFieldObjet.getStringValue("fieldname"));
            }
            // 写入头部
            String headersLine = String.join(",", titlelist);
            out.println(headersLine);

            // 写入数据
            for (Object o : dataArrays) {
                JSONObject dataObject = (JSONObject) o;

                List<String> datarow = new ArrayList<>();
                for (String fieldname : fieldlist) {
                    String data = (dataObject).getOrDefault(fieldname, "").toString();
                    data = data.contains(",") ? ("\"" + data + "\"") : data;
                    datarow.add(data);
                }
                out.println(String.join(",", datarow));
            }
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilename() {
        return this.filename + "." + filetype;
    }

    public String getFilepath() {
        return filepath;
    }

    public File getFile() throws YosException {
        return new File(filepath);
    }

    public void deletefile() {
        File file = new File(filepath);
        file.delete();
    }
}
