package common;

import common.data.Rows;
import utility.tools.MessageMonitoringStation;

import java.util.ArrayList;
import java.util.Calendar;

/**
 * 定时任务类父类，所有定时任务类都必须继承该类
 */
public abstract class ServiceController extends BaseClass implements Runnable {

    public static ArrayList<String> serviceed = new ArrayList<>();

    @Override
    public void run() {
        String classname = getClass().getSimpleName();
        try {
            if (checkService(classname)) {
                logger.info("自动任务执行：" + classname);
                dbConnect.runSqlUpdate("update sys_services set lastruntime=now() where classname='" + classname + "'");
                int successed = 1;
                long starttime = Calendar.getInstance().getTimeInMillis();
                try {
                    serviceRun();
                } catch (Exception e) {
                    e.printStackTrace();
                    successed = 0;
                } finally {
                    try {
                        if (successed == 1) {
                            serviceed.add(classname);
                        }
                        long timelong = Calendar.getInstance().getTimeInMillis() - starttime;
                        dbConnect.runSqlUpdate("update sys_services set successed=" + successed + ",timelong=" + timelong + " where classname='" + classname + "'");
                    } catch (YosException e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (YosException e) {
            e.printStackTrace();
            String errmsg = "\n自动任务执行异常！\n" +
                    "任务名称：" + classname + "\n" +
                    "异常原因：" + e.getMessage() + "\n" +
                    "异常位置：\n" + e.getStackTrace()[0].toString() + "\n\n" +
                    "相关人员请及时处理！";
            MessageMonitoringStation.send(errmsg);
        }
    }

    public abstract void serviceRun() throws YosException;

    private boolean checkService(String classname) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select isused,type from sys_services where classname='" + classname + "'");
        if (rows.isEmpty() || !rows.get(0).getBoolean("isused")) {
            return false;
        } else if (rows.get(0).getString("type").equalsIgnoreCase("once") && serviceed.contains(classname)) {
            return false;
        }
        return true;
    }
}
