package swing.controls;

import swing.YUIParameter;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ComponentListener;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.lang.reflect.Constructor;

/**
 * 窗体
 */
public abstract class YFrame extends JFrame implements Yui {
    /**
     * 构造函数
     *
     * @throws HeadlessException
     */
    public YFrame() throws HeadlessException {
        super();
        initialize();
    }

    /**
     * 构造函数
     *
     * @param gc
     */
    public YFrame(GraphicsConfiguration gc) {
        super(gc);
        initialize();
    }

    /**
     * 构造函数
     *
     * @param title 窗口标题
     * @throws HeadlessException
     */
    public YFrame(String title) throws HeadlessException {
        super(title);
        initialize();
    }

    public YFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        initialize();
    }

    /**
     * 初始化
     */
    private void initialize() {
        getContentPane().setLayout(new BorderLayout());
        /**
         * 窗口logo
         */
        setIcon("logo.ico");
        /**
         * 关闭按钮
         */
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        /**
         * 窗口默认位置
         */
        setBounds((YUIParameter.screen_width - YUIParameter.screen_width_half) / 2, (YUIParameter.screen_height - YUIParameter.screen_height_half) / 2 - 100, YUIParameter.screen_width_half, YUIParameter.screen_height_half);

        /**
         * 用户初始化
         */
        this.init();
        /**
         * 创建界面
         */
        view();
        /**
         * 创建数据
         */
        data();
        /**
         * 设置参数、动作等
         */
        control();
    }

    /**
     * 设置窗口图标
     *
     * @param iconname
     */
    public void setIcon(String iconname) {
        try {
            String path = getClass().getResource("/").toURI().getPath() + "com/sui/media/images/" + iconname;
            this.setIconImage(new ImageIcon(path).getImage());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置窗口背景图
     *
     * @param imagename
     */
    public void setBackground(String imagename) {
        try {
            String path = getClass().getResource("/").toURI().getPath() + "com/sui/media/images/" + imagename;
            ImageIcon backgroundImage = new ImageIcon(path);

            JLabel label = new JLabel(backgroundImage);
            label.setBounds(0, 0, this.getWidth(), this.getHeight());
            // 把背景图片添加到分层窗格的最底层作为背景
            this.getLayeredPane().add(label, new Integer(Integer.MIN_VALUE));
            ((JPanel) getContentPane()).setOpaque(false);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 是否禁用缩放
     *
     * @param resizable
     */
    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
    }

    /**
     * 设置监听
     *
     * @param listener
     */
    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            addWindowFocusListener((WindowFocusListener) obj);
            addWindowStateListener((WindowStateListener) obj);
            addComponentListener((ComponentListener) obj);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置窗口格式
     */
    public void setBoundsType(BoundsType boundsType) {
        switch (boundsType) {
            case full:
                setBounds(0, 0, YUIParameter.screen_width, YUIParameter.screen_height);
                break;
            case half:
                setBounds((YUIParameter.screen_width - YUIParameter.screen_width_half) / 2, (YUIParameter.screen_height - YUIParameter.screen_height_half) / 2 - 100, YUIParameter.screen_width_half, YUIParameter.screen_height_half);
                break;
            case small:
                setBounds((YUIParameter.screen_width - YUIParameter.screen_width_half / 3 * 2) / 2, (YUIParameter.screen_height - YUIParameter.screen_height_half / 3 * 2) / 2 - 100, YUIParameter.screen_width_half / 3 * 2, YUIParameter.screen_height_half / 3 * 2);
        }
    }

    public enum BoundsType {
        full, half, small
    }
}
