package swing.controls;

import swing.YUIParameter;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;

/**
 * 功能按钮
 */
public class YButton extends JButton {

    /**
     * 构造函数
     *
     * @param title 按钮标题
     */
    public YButton(String title) {
        super(title);
        init();
    }

    /**
     * 构造函数
     *
     * @param title  按钮标题
     * @param width  宽度
     * @param height 高度
     */
    public YButton(String title, int width, int height) {
        this(title);
        setPreferredSize(new Dimension(width, height));
    }

    /**
     * 按钮大小枚举
     */
    public enum ButtonSize {
        normal, small
    }

    /**
     * 构造函数
     *
     * @param title      按钮标题
     * @param buttonSize 按钮大小
     */
    public YButton(String title, ButtonSize buttonSize) {
        this(title);
        switch (buttonSize) {
            case small:
                setPreferredSize(new Dimension(50, 23));
                break;
            case normal:
                setPreferredSize(new Dimension(60, 30));
                break;
        }
    }

    /**
     * 初始化
     */
    private void init() {
        setBackground(Color.white);
        if (YUIParameter.isdebug) {
            setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    /**
     * 设置监听
     *
     * @param listener
     */
    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            addActionListener((ActionListener) obj);
            addFocusListener((FocusListener) obj);
            addMouseListener((MouseListener) obj);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
