package restcontroller.system.datasequence;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import restcontroller.R;

import java.util.ArrayList;

public class datasequence extends Controller {
    public datasequence(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "公共方法，表格数据排序更新", apiversion = R.ID20221201134901.v1.class)
    public String updateSequence() throws YosException {
        String ownertable = content.getString("ownertable");
        boolean cleandatapool = true;
        if (content.containsKey("cleandatapool")) {
            cleandatapool = content.getBooleanValue("cleandatapool");
        }
        ArrayList<String> list = new ArrayList<>();
        JSONArray sortArray = content.getJSONArray("sequencesorts");
        if (ownertable.equals("sys_objectcols")) {
            for (Object o : sortArray) {
                JSONObject object = (JSONObject) o;
                String column_name = object.getStringValue("column_name");
                int sequence = object.getIntValue("sequence");
                list.add("update " + ownertable + " set sequence = " + sequence + " where table_name='" + ownertable + "' and " + column_name + "=" + column_name);
            }
        } else {
            String uniquecolumnname = getuniquecolumnname(ownertable);
            for (Object o : sortArray) {
                JSONObject object = (JSONObject) o;
                long ownerid = object.getLongValue("ownerid");
                int sequence = object.getIntValue("sequence");
                list.add("update " + ownertable + " set sequence = " + sequence + " where " + uniquecolumnname + "=" + ownerid);
            }
        }
        dbConnect.runSqlUpdate(list);
        if (cleandatapool) {
            cleanAllDataPool();
        }
        return getSucReturnObject().toString();
    }
}
