package beans.attachment;

import beans.datacontrllog.DataContrlLog;
import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.*;
import utility.huawei.obs.BucketFile;

import java.util.ArrayList;
import java.util.HashMap;

public class Attachment {

    /**
     * 获取指定表id的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, String ownertable, Long ownerid) throws YosException {
        return get(controller, ownertable, ownerid, null);
    }

    /**
     * 获取指定表多个id的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerids
     * @return
     * @throws YosException
     */
    public static RowsMap get(Controller controller, String ownertable, ArrayList<Long> ownerids) throws YosException {
        return get(controller, ownertable, ownerids, null);
    }

    /**
     * 获取指定表id 且指定类型的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(ownerid);
        return get(controller, ownertable, id, usetype).getOrDefault(String.valueOf(ownerid), new Rows());
    }


    /**
     * 获取指定表多个id且指定类型的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerids
     * @param usetype
     * @return
     * @throws YosException
     */
    public static RowsMap get(Controller controller, String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "linksid", "siteid", "ownerid", "ownertable", "usetype", "createdate", "attachmentid","sequence");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_attachment", "sys_attachment", "siteid=:siteid and attachmentid=:attachmentid", "document", "postfix", "serialnumber", "url", "contentlength", "isfolder", "parentid", "folderpath");
        querySQL.setWhere("ownertable", ownertable);
        querySQL.setWhere("ownerid", ownerids);
        if (usetype != null) {
            querySQL.setWhere("usetype", usetype);
        }
        querySQL.setOrderBy("linksid desc");
        Rows rows = querySQL.query();

        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSub(controller, rows.toArrayList("attachmentid", new ArrayList<>()));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("ownerid");
    }

    /**
     * 获取指定的id的附件
     *
     * @param controller
     * @param attachmentid
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, Long attachmentid) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(attachmentid);
        return get(controller, id);
    }

    /**
     * 获取指定的多个id的附件
     *
     * @param controller
     * @param attachmentids
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, ArrayList<Long> attachmentids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "linksid", "siteid", "ownerid", "ownertable", "usetype", "createdate", "attachmentid","sequence");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_attachment", "sys_attachment", "siteid=:siteid and attachmentid=:attachmentid", "document", "postfix", "serialnumber", "url", "contentlength", "isfolder", "parentid", "folderpath");
        querySQL.setWhere("attachmentid", attachmentids);
        querySQL.setOrderBy("linksid desc");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSub(controller, attachmentids);
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows;
    }

    /**
     * 获取指定附件id的下级附件
     *
     * @param controller
     * @param attachmentid
     * @return
     * @throws YosException
     */
    public static Rows getSub(Controller controller, Long attachmentid) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(attachmentid);
        return getSub(controller, id).getOrDefault(String.valueOf(attachmentid), new Rows());
    }

    /**
     * 获取指定多个附件id的下级附件
     *
     * @param controller
     * @param attachmentids
     * @return
     * @throws YosException
     */
    public static RowsMap getSub(Controller controller, ArrayList<Long> attachmentids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment", "attachmentid", "serialnumber", "url", "type", "contentlength", "parentid", "isfolder", "postfix", "document", "folderpath");
        querySQL.setWhere("parentid", attachmentids);
        querySQL.setOrderBy("attachmentid");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSub(controller, rows.toArrayList("attachmentid", new ArrayList<>()));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("parentid");
    }

    public static void main(String[] args) throws YosException {
        System.err.println(Attachment.get(new Controller(new JSONObject()), 38197L).toJsonArray());
    }

    /**
     * 获取指定表及id的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @return
     * @throws YosException
     */
    public static long getCount(Controller controller, String ownertable, Long ownerid) throws YosException {
        return getCount(controller, ownertable, ownerid, null);
    }

    /**
     * 获取指定表及id且指定类型的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @return
     * @throws YosException
     */
    public static long getCount(Controller controller, String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(ownerid);
        return getCount(controller, ownertable, id, usetype).getOrDefault(ownerid, 0L);
    }

    /**
     * 获取指定表多个id的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @return
     * @throws YosException
     */
    public static HashMap<Long, Long> getCount(Controller controller, String ownertable, ArrayList<Long> ownerid) throws YosException {
        return getCount(controller, ownertable, ownerid, null);
    }

    /**
     * 获取指定表多个id且指定类型的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @return
     * @throws YosException
     */
    public static HashMap<Long, Long> getCount(Controller controller, String ownertable, ArrayList<Long> ownerid, String usetype) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "ownerid");
        querySQL.addQueryFields(" attachmentcount", "count(0)");
        querySQL.setWhere("ownertable", ownertable);
        querySQL.setWhere("ownerid", ownerid);
        if (usetype != null) {
            querySQL.setWhere("usetype", usetype);
        }
        querySQL.addGroupBy("ownerid");
        Rows rows = querySQL.query();
        HashMap<Long, Long> map = new HashMap<>();
        for (Row row : rows) {
            map.put(row.getLong("ownerid"), row.getLong("attachmentcount"));
        }
        return map;
    }

    /**
     * 获取指定多个附件id的下级附件
     *
     * @param controller
     * @param attachmentid
     * @return
     * @throws YosException
     */
    public static Row getParent(Controller controller, long attachmentid) throws YosException {
        Rows rows = get(controller, attachmentid);
        if (rows.isNotEmpty()) {
            Rows parentRows = get(controller, rows.get(0).getLong("parentid"));
            if (parentRows.isNotEmpty()) {
                return parentRows.get(0);
            }
        }
        return new Row();
    }

    /**
     * 刷新附件文件路径
     */
    public static synchronized void RefreshFolderPath(Controller controller, long attachmentid) throws YosException {
        String folderpath = "0/";
        Row parentRow = getParent(controller, attachmentid);
        if (!parentRow.isEmpty()) {
            folderpath = parentRow.getString("folderpath") + parentRow.getLong("attachmentid") + "/";
        }
        controller.dbConnect.runSqlUpdate("update sys_attachment set folderpath='" + folderpath + "' where attachmentid=" + attachmentid);

        SQLFactory sqlFactory = new SQLFactory(new Attachment(), "附件文件路径创建");
        sqlFactory.addParameter("attachmentid", attachmentid);
        controller.dbConnect.runSqlUpdate(sqlFactory.getSQL());
    }

    /**
     * 附件删除
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @throws YosException
     */
    public static void delete(Controller controller, String ownertable, long ownerid) throws YosException {
        Rows rows = get(controller, ownertable, ownerid);
        for (Row row : rows) {
            delete(controller, row.getLong("attachmentid"));
        }
    }


    /**
     * 附件删除
     *
     * @param controller
     * @param attachmentid
     * @throws YosException
     */
    public static void delete(Controller controller, long attachmentid) throws YosException {
        if (controller.dbConnect.runSqlQuery("select *from sys_site_parameter where appfolderid='" + attachmentid + "' or salematerialfolderid='" + attachmentid + "'").isNotEmpty()) {
            throw new YosException(false, "系统文件夹不可删除");
        }
        String siteid = get(controller, attachmentid).get(0).getString("siteid");
        Rows rows = getSub(controller, attachmentid);
        ArrayList<String> sqlist = new ArrayList<>();
        for (Row row : rows) {
            String objectname = row.getString("serialnumber");
            String type = row.getString("type");
            switch (Parameter.get("system_attachment_type")) {
                case "huaweiobs": {
                    try {
                        BucketFile bucketFile = new BucketFile(siteid);
                        if ("hls".equals(type)) {
                            bucketFile.deleteFolder(objectname);
                        } else {
                            bucketFile.deleteFile(objectname);
                        }
                        bucketFile.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "localhost": {
                    break;
                }
                case "alioos": {
                    break;
                }
            }
            sqlist.add("delete from sys_attachment where (attachmentid='" + row.getString("attachmentid") + "' or parentid='" + row.getString("attachmentid") + "')");
            sqlist.add("delete from sys_attachment_links where attachmentid='" + row.getString("attachmentid") + "'");
            /*
             *插入操作记录
             */
            Rows attrows = controller.dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.attachmentid=" + row.getString("attachmentid"));
            for (Row attrow : attrows) {
                sqlist.add(DataContrlLog.createLog(controller, attrow.getString("ownertable"), attrow.getLong("ownerid"), "删除附件", "删除附件" + attrow.getString("document")).getSQL());
            }
        }
        controller.dbConnect.runSqlUpdate(sqlist);
    }
}
