package service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.YosException;
import common.data.*;
import common.data.db.DBConnect;

import java.util.ArrayList;

public class DataArchiving extends ServiceController {

    @Override
    public void serviceRun() throws YosException {
        databaseinit();

        archiveData();
        archiveSiteData();
    }

    private void archiveData() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select table_name,condition,foreign_table from sys_dataarchiving where issite=1 and isopen=1");
        for (Row row : rows) {
            ArrayList<String> sqllist = new ArrayList<>();

            String table_name = row.getString("table_name");
            String condition = row.getString("condition");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");

            String database = dbConnect.getDBName() + "_archive";
            Rows dataRows = dbConnect.runSqlQuery("select * from " + table_name + " where (" + condition + ") limit 1000");
            for (Row dataRow : dataRows) {
                String uniquecolumnname = getuniquecolumnname(table_name);
                long dataid = dataRow.getLong(uniquecolumnname);

                String insertsql = dataRow.getInsertSQL(table_name).getSQL().replace(" " + table_name + " ", " " + database + "." + table_name + " ");
                String deletesql = SQLFactory.createDeleteSQL(dbConnect, table_name).setUniqueid(dataid).getSQL();

                sqllist.add(insertsql);
                sqllist.add(deletesql);

                for (int i = 0; i < foreign_tables.size(); i++) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    String foreign_table_name = foreign_table.getString("table_name");
                    String foreign_condition = foreign_table.getString("condition");
                    Rows foreign_dataRows = dbConnect.runSqlQuery("select " + foreign_table_name + ".* from " + foreign_table_name + " inner join " + table_name + " on " + foreign_condition + " where " + table_name + "." + uniquecolumnname + "=" + dataid);
                    for (Row foreign_dataRow : foreign_dataRows) {
                        String foreign_uniquecolumnname = getuniquecolumnname(foreign_table_name);
                        long foreign_dataid = dataRow.getLong(foreign_uniquecolumnname);


                        String foreign_insertsql = foreign_dataRow.getInsertSQL(foreign_table_name).getSQL().replace(" " + foreign_table_name + " ", " " + database + "." + foreign_table_name + " ");
                        String foreign_deletesql = SQLFactory.createDeleteSQL(dbConnect, foreign_table_name).setUniqueid(foreign_dataid).getSQL();

                        sqllist.add(foreign_insertsql);
                        sqllist.add(foreign_deletesql);
                    }
                }
            }

            if (!sqllist.isEmpty()) {
                dbConnect.runSqlUpdate(sqllist);
            }
        }
    }

    private void archiveSiteData() throws YosException {
        ArrayList<String> siteids = dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = dbConnect.runSqlQuery("select table_name,condition,foreign_table from sys_dataarchiving where issite=1 and isopen=1");
        for (Row row : rows) {
            ArrayList<String> sqllist = new ArrayList<>();

            String table_name = row.getString("table_name");
            String condition = row.getString("condition");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");

            for (String siteid : siteids) {
                String database = dbConnect.getDBName() + "_archive" + "_" + siteid;
                Rows dataRows = dbConnect.runSqlQuery("select * from " + table_name + " where siteid='" + siteid + "' and (" + condition + ") limit 1000");
                for (Row dataRow : dataRows) {
                    String uniquecolumnname = getuniquecolumnname(table_name);
                    long dataid = dataRow.getLong(uniquecolumnname);

                    String insertsql = dataRow.getInsertSQL(table_name).getSQL().replace(" " + table_name + " ", " " + database + "." + table_name + " ");
                    String deletesql = SQLFactory.createDeleteSQL(dbConnect, table_name).setUniqueid(dataid).getSQL();

                    sqllist.add(insertsql);
                    sqllist.add(deletesql);

                    for (int i = 0; i < foreign_tables.size(); i++) {
                        JSONObject foreign_table = foreign_tables.getJSONObject(i);
                        String foreign_table_name = foreign_table.getString("table_name");
                        String foreign_condition = foreign_table.getString("condition");
                        Rows foreign_dataRows = dbConnect.runSqlQuery("select " + foreign_table_name + ".* from " + foreign_table_name + " inner join " + table_name + " on " + foreign_condition + " where " + table_name + "." + uniquecolumnname + "=" + dataid);
                        for (Row foreign_dataRow : foreign_dataRows) {
                            String foreign_uniquecolumnname = getuniquecolumnname(foreign_table_name);
                            long foreign_dataid = dataRow.getLong(foreign_uniquecolumnname);


                            String foreign_insertsql = foreign_dataRow.getInsertSQL(foreign_table_name).getSQL().replace(" " + foreign_table_name + " ", " " + database + "." + foreign_table_name + " ");
                            String foreign_deletesql = SQLFactory.createDeleteSQL(dbConnect, foreign_table_name).setUniqueid(foreign_dataid).getSQL();

                            sqllist.add(foreign_insertsql);
                            sqllist.add(foreign_deletesql);
                        }
                    }
                }
            }
            if (!sqllist.isEmpty()) {
                dbConnect.runSqlUpdate(sqllist);
            }
        }
    }

    private void databaseinit() throws YosException {
        ArrayList<String> siteids = dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = dbConnect.runSqlQuery("select issite,table_name,foreign_table from sys_dataarchiving where isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");

            ArrayList<String> databaseList = new ArrayList<>();

            if (row.getBoolean("issite")) {
                for (String siteid : siteids) {
                    databaseList.add(dbConnect.getDBName() + "_archive" + "_" + siteid);
                }
            } else {
                databaseList.add(dbConnect.getDBName() + "_archive");
            }

            for (String database : databaseList) {
                createDataBase(database, table_name);
                for (int i = 0; i < foreign_tables.size(); i++) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    createDataBase(database, foreign_table.getString("table_name"));
                }
            }
        }
    }

    private void createDataBase(String database, String table_name) throws YosException {
        if (dbConnect.runSqlQuery("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'yosss'").isEmpty()) {
            //如果不存在归档数据库，则自动创建该数据库，并自动添加至系统数据源中
            dbConnect.runSqlUpdate("CREATE DATABASE `" + database + "` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_datasource");
            insertSQL.setValue("datakey", database);
            insertSQL.setValue("dbname", database);
            insertSQL.setValue("isdataarchive", 1);
            insertSQL.setValue("driver", "");
            insertSQL.setValue("username", "");
            insertSQL.setValue("password", "");
            insertSQL.setValue("url", "");
            insertSQL.insert();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        if (dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" + database + "' AND table_name = '" + table_name + "'").isEmpty()) {
            //如果表不存在，则创建表
            sqllist.add(dbConnect.runSqlQuery("SHOW CREATE table " + table_name).get(0).getString("Create Table"));
        } else {
            //如果表存在，则更新表
            Rows tablecolrows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "'");
            for (Row tablecolrow : tablecolrows) {
                String column_name = tablecolrow.getString("column_name");//字段名称
                String column_type = tablecolrow.getString("column_type");//字段类型
                int numeric_precision = tablecolrow.getInteger("numeric_precision");//长度
                int numeric_scale = tablecolrow.getInteger("numeric_scale");//小数位数
                String type = getColumn_type(column_type, numeric_precision, numeric_scale);

                //判断字段是否已存在
                Rows cr = dbConnect.runSqlQuery("SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + database + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'");
                if (cr.isEmpty()) {
                    sqllist.add("alter table " + table_name + " add " + column_name + " " + type + " " + "null" + ";");
                } else if (!cr.get(0).getString("COLUMN_TYPE").equalsIgnoreCase(type)) {
                    sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + " " + "null" + ";");
                }
            }
        }
        if (!sqllist.isEmpty()) {
            new DBConnect(database).runSqlUpdate(sqllist);
        }
    }

    private String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        } else if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        } else if (column_type.equals("integer")) {
            return "int";
        } else {
            return column_type;
        }
    }
}
