package restcontroller.system;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.parameter.properties;
import restcontroller.R;

@API(title = "系统全局参数获取")
public class parameter extends Controller {
    public parameter(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "登陆方式配置获取", accesstoken = false, apiversion = R.ID10022401.v1.class)
    @CACHEING(life = 3600)
    public String getLoginMode() {
        boolean account = properties.getYosProperties().getProperty("system.loginmode.account").equalsIgnoreCase("true");
        boolean phonenumber = properties.getYosProperties().getProperty("system.loginmode.phonenumber").equalsIgnoreCase("true");
        boolean wechat = properties.getYosProperties().getProperty("system.loginmode.wechat").equalsIgnoreCase("true");

        JSONObject loginmodeObject = new JSONObject();
        loginmodeObject.put("account", account);
        loginmodeObject.put("phonenumber", phonenumber);
        loginmodeObject.put("wechat", wechat);
        return getSucReturnObject().setData(loginmodeObject).toJSONString();
    }
}
