package restcontroller.system.attachment;

import beans.attachment.Attachment;
import beans.datacontrllog.DataContrlLog;
import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.*;
import restcontroller.R;
import utility.huawei.obs.BucketFile;

import java.util.ArrayList;

import common.YosException;

@API(title = "媒体中心管理")
public class MediaCenter extends Controller {

    public MediaCenter(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "媒体列表查询", apiversion = R.ID10020901.v1.class)
    public String queryAttachment() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                if (whereObject.getLongValue("parentid") > 0) {
                    Rows parentRows = Attachment.get(this, whereObject.getLongValue("parentid"));
                    if (parentRows.isNotEmpty()) {
                        where.append(" and(");
                        where.append(" t1.folderpath like'").append(parentRows.get(0).getString("folderpath")).append("%' ");
                        where.append(")");
                    }
                }
                where.append(" and(");
                where.append(" t1.document like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            } else {
                if (whereObject.containsKey("parentid") && !"".equals(whereObject.getString("parentid"))) {
                    where.append(" and(");
                    where.append(" ifnull(t1.parentid,0) ='").append(whereObject.getString("parentid")).append("'");
                    where.append(")");
                }
            }
            if (whereObject.containsKey("attachmentid") && !"".equals(whereObject.getString("attachmentid"))) {
                where.append(" and(");
                where.append(" t1.attachmentid ='").append(whereObject.getString("attachmentid")).append("'");
                where.append(")");
            }
            if (whereObject.containsKey("isonlyfolder") && "1".equals(whereObject.getString("isonlyfolder"))) {
                where.append(" and(");
                where.append(" t1.isfolder ='1'");
                where.append(")");
            }
            if (whereObject.containsKey("isonlycollect") && "1".equals(whereObject.getString("isonlycollect"))) {
                where.append(" and(");
                if (whereObject.containsKey("collecttype") && !"".equals(whereObject.getString("collecttype"))) {
                    where.append(" exists(select*from sys_attachment_collect where siteid=t1.siteid and attachmentid=t1.attachmentid and type='" + whereObject.getString("collecttype") + "' and userid='" + userid + "')");
                } else {
                    where.append(" exists(select*from sys_attachment_collect where siteid=t1.siteid and attachmentid=t1.attachmentid and userid='" + userid + "')");
                }
                where.append(")");
            }
            if (whereObject.containsKey("postfixs") && !whereObject.getJSONArray("postfixs").isEmpty()) {
                JSONArray postfixsarray = whereObject.getJSONArray("postfixs");
                StringBuffer postfix_in = new StringBuffer();
                for (Object o : postfixsarray) {
                    String postfix = ((String) o).replace(".", "");
                    if (postfix_in.toString().equals("")) {
                        postfix_in.append("'" + postfix + "'");
                    } else {
                        postfix_in.append(",'" + postfix + "'");
                    }
                }
                where.append(" and (postfix in (" + postfix_in + ") or isfolder=1 )");
            }
        }

        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_attachment").setTableAlias("t1");
        querySQL.setWhere("siteid", siteid);
        querySQL.setWhere(where.toString());
        querySQL.setPage(pageSize, pageNumber);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "创建媒体文件夹", apiversion = R.ID10021001.v1.class)
    public String createFolder() throws YosException {
        String foldername = content.getString("foldername");
        long parentid = content.getLongValue("parentid");//父级文件夹id
        /**
         * 本地信息插入
         */
        long attachmentid = createTableID("sys_attachment");
        SQLFactory sqlFactory = new SQLFactory(this, "媒体文件夹插入");
        sqlFactory.addParameter("attachmentid", attachmentid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("createby", username);
        sqlFactory.addParameter("document", foldername);
        sqlFactory.addParameter("parentid", parentid > 0 ? String.valueOf(parentid) : "null");
        dbConnect.runSqlUpdate(sqlFactory);
        Attachment.RefreshFolderPath(this, attachmentid);
        return getSucReturnObject().setData(getAttachmentUrl(attachmentid).get(0)).toString();
    }

    @API(title = "批量修改媒体基本信息", apiversion = R.ID10021101.v1.class)
    public String changeAttachment() throws YosException {
        JSONArray files = content.getJSONArray("files");
        ArrayList<String> sqllist = new ArrayList<String>();
        ArrayList<Long> attachmentidlist = new ArrayList<>();
        for (Object o : files) {
            JSONObject file = (JSONObject) o;
            long attachmentid = file.getLong("attachmentid");
            String document = file.getString("document");
            String parentid = file.getString("parentid");

            SQLFactory sql = new SQLFactory(this, "媒体信息调整");
            sql.addParameter("siteid", siteid);
            sql.addParameter("attachmentid", attachmentid);
            sql.addParameter("document", document);
            sql.addParameter("parentid", parentid);
            sqllist.add(sql.getSQL());
            attachmentidlist.add(attachmentid);

            /*
             *插入操作记录
             */
            Rows rows = dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + siteid + "' and t1.attachmentid=" + attachmentid);
            for (Row row : rows) {
                InsertSQL logsql = DataContrlLog.createLog(this, row.getString("ownertable"), row.getLong("ownerid"), "编辑附件", "附件【" + row.getString("document") + "】 名称调整为 【" + document + "】");
                sqllist.add(logsql.getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqllist);
        for (Object o : files) {
            JSONObject file = (JSONObject) o;
            long attachmentid = file.getLong("attachmentid");
            Attachment.RefreshFolderPath(this, attachmentid);
        }
        return getSucReturnObject().setData(getAttachmentUrl(attachmentidlist)).toString();
    }

    @API(title = "媒体删除", apiversion = R.ID10021201.v1.class)
    public String deleteAttachment() throws YosException {
        long attachmentid = content.getLongValue("attachmentid");
        if (dbConnect.runSqlQuery("select *from sys_site_parameter where appfolderid='" + attachmentid + "' or salematerialfolderid='" + attachmentid + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统文件夹不可删除").toString();
        }
        SQLFactory sqlFactory = new SQLFactory(this, "子媒体ID查询");
        sqlFactory.addParameter("attachmentid", attachmentid);
        sqlFactory.addParameter("siteid", siteid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        ArrayList<String> sqlist = new ArrayList<>();
        for (Row row : rows) {
            String objectname = row.getString("serialnumber");
            String type = row.getString("type");
            switch (Parameter.get("system_attachment_type")) {
                case "huaweiobs": {
                    try {
                        BucketFile bucketFile = new BucketFile(siteid);
                        if ("hls".equals(type)) {
                            bucketFile.deleteFolder(objectname);
                        } else {
                            bucketFile.deleteFile(objectname);
                        }
                        bucketFile.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "localhost": {
                    break;
                }
                case "alioos": {
                    break;
                }
            }
            SQLFactory delete = new SQLFactory(this, "媒体删除");
            delete.addParameter("siteid", siteid);
            delete.addParameter("attachmentid", row.getString("attachmentid"));
            sqlist.add(delete.getSQL());

            SQLFactory delete2 = new SQLFactory(this, "媒体数据关联信息删除");
            delete2.addParameter("siteid", siteid);
            delete2.addParameter("attachmentid", row.getString("attachmentid"));
            sqlist.add(delete2.getSQL());
            /*
             *插入操作记录
             */
            Rows attrows = dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + siteid + "' and t1.attachmentid=" + row.getString("attachmentid"));
            for (Row attrow : attrows) {
                sqlist.add(DataContrlLog.createLog(this, attrow.getString("ownertable"), attrow.getLong("ownerid"), "删除附件", "删除附件" + attrow.getString("document")).getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqlist);
        return getSucReturnObject().toString();
    }

    @API(title = "批量媒体删除", apiversion = R.ID10021301.v1.class)
    public String deleteAttachments() throws YosException {
        JSONArray attachmentids = content.getJSONArray("attachmentids");
        ArrayList<String> sqlist = new ArrayList<>();
        for (Object object : attachmentids) {
            long attachmentid = Long.parseLong(String.valueOf(object));
            if (dbConnect.runSqlQuery("select *from sys_site_parameter where appfolderid='" + attachmentid + "' or salematerialfolderid='" + attachmentid + "'").isNotEmpty()) {
                continue;
            }
            SQLFactory sqlFactory = new SQLFactory(this, "子媒体ID查询");
            sqlFactory.addParameter("attachmentid", attachmentid);
            sqlFactory.addParameter("siteid", siteid);
            Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());

            for (Row row : rows) {
                String objectname = row.getString("serialnumber");
                String type = row.getString("type");

                switch (Parameter.get("system_attachment_type")) {
                    case "huaweiobs": {
                        try {
                            BucketFile bucketFile = new BucketFile(siteid);
                            if ("hls".equals(type)) {
                                bucketFile.deleteFolder(objectname);
                            } else {
                                bucketFile.deleteFile(objectname);
                            }
                            bucketFile.close();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "localhost": {
                        break;
                    }
                    case "alioos": {
                        break;
                    }
                }
                SQLFactory delete = new SQLFactory(this, "媒体删除");
                delete.addParameter("siteid", siteid);
                delete.addParameter("attachmentid", row.getString("attachmentid"));
                sqlist.add(delete.getSQL());

                SQLFactory delete2 = new SQLFactory(this, "媒体数据关联信息删除");
                delete2.addParameter("siteid", siteid);
                delete2.addParameter("attachmentid", row.getString("attachmentid"));
                sqlist.add(delete2.getSQL());

                /*
                 *插入操作记录
                 */
                Rows attrows = dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + siteid + "' and t1.attachmentid=" + row.getString("attachmentid"));
                for (Row attrow : attrows) {
                    sqlist.add(DataContrlLog.createLog(this, attrow.getString("ownertable"), attrow.getLong("ownerid"), "删除附件", "删除附件" + attrow.getString("document")).getSQL());
                }
            }
        }
        dbConnect.runSqlUpdate(sqlist);
        return getSucReturnObject().toString();
    }


    @API(title = "媒体资源收藏", apiversion = R.ID10021401.v1.class)
    public String collectAttachment() throws YosException {
        String collecttype = content.getString("collecttype");//收藏类型（营销物料、商学院）
        long attachmentid = content.getLongValue("attachmentid");
        SQLFactory sqlFactory = new SQLFactory(this, "媒体数据收藏");
        sqlFactory.addParameter("sys_attachment_collectid", createTableID("sys_attachment_collect"));
        sqlFactory.addParameter("attachmentid", attachmentid);
        sqlFactory.addParameter("linksid", "null");
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("type", collecttype);
        dbConnect.runSqlUpdate(sqlFactory);
        return getSucReturnObject().toString();
    }

    @API(title = "媒体资源取消收藏", apiversion = R.ID10021501.v1.class)
    public String uncollectAttachment() throws YosException {
        long attachmentid = content.getLongValue("attachmentid");
        dbConnect.runSqlUpdate("delete from sys_attachment_collect where attachmentid=" + attachmentid);
        return getSucReturnObject().toString();
    }

    @API(title = "媒体数据绑定情况查询", apiversion = R.ID10021601.v1.class)
    @CACHEING
    public String queryAttachment_LinkData() throws YosException {
        long attachmentid = content.getLongValue("attachmentid");
        Rows linkrows = dbConnect.runSqlQuery("select t1.linksid,t1.ownertable,t1.ownerid,t1.usetype,t1.createdate,t1.createby from sys_attachment_links t1 inner join sys_object t2 on t1.ownertable=t2.table_name where t1.siteid='" + siteid + "' and t1.attachmentid='" + attachmentid + "'");
        RowsMap linkrowsMap = linkrows.toRowsMap("ownertable");

        RowsMap linkdatashowRowsMap = dbConnect.runSqlQuery("select * from sys_attachment_linkdatashow").toRowsMap("ownertable");
        for (String ownertable : linkrowsMap.keySet()) {
            String appname = "";
            StringBuilder datafield = null;
            Rows linkdatashowRows = linkdatashowRowsMap.get(ownertable);
            if (linkdatashowRows.isNotEmpty()) {
                appname = linkdatashowRows.get(0).getString("appname");
                JSONArray datafields = linkdatashowRows.get(0).getJSONArray("datafields");
                for (Object o : datafields) {
                    if (datafield == null) {
                        datafield = new StringBuilder("concat(" + o);
                    } else {
                        datafield.append(",';',").append(o);
                    }
                }
                if (datafield != null) {
                    datafield.append(")");
                }
            } else {
                datafield = new StringBuilder("''");
                appname = getTableName(ownertable);
            }
            String uniquecolumnname = getuniquecolumnname(ownertable);
            Rows table_linkrows = linkrowsMap.get(ownertable);
            ArrayList<String> owneridlist = table_linkrows.toArrayList("ownerid");
            SQLFactory sqlFactory = new SQLFactory("sql:select " + uniquecolumnname + "," + datafield + " as datafield from " + ownertable + " where " + uniquecolumnname + " in $" + uniquecolumnname + "$");
            sqlFactory.addParameter_in(uniquecolumnname, owneridlist);
            RowsMap rowsmap = dbConnect.runSqlQuery(sqlFactory.getSQL()).toRowsMap(uniquecolumnname);
            for (Row table_linkrow : table_linkrows) {
                JSONObject dataobject = new JSONObject();
                dataobject.put("appname", appname);
                if (rowsmap.get(table_linkrow.getString("ownerid")).isEmpty()) {
                    dataobject.put("appdata", "");
                } else {
                    dataobject.put("appdata", rowsmap.get(table_linkrow.getString("ownerid")).get(0).getString("datafield"));
                }
                table_linkrow.put("data", dataobject);
            }
        }
        return getSucReturnObject().setData(linkrows).toString();
    }
}
