package restcontroller.sysmanage.develop.dataarchiving;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

public class dataarchiving extends Controller {
    public dataarchiving(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据备份方案列表", apiversion = R.ID10030201.v1.class)
    public String queryList() throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_dataarchiving");
        querySQL.setPage(pageSize, pageNumber);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "数据备份方案新增修改", apiversion = R.ID10030401.v1.class)
    public String insertorupdate() throws YosException {
        long dataarchivingid = content.getLong("dataarchivingid");
        boolean issite = content.getBooleanValue("issite");
        String table_name = content.getString("table_name");

        if (issite && !getTableColumnNames(table_name).contains("siteid")) {
            return getErrReturnObject().setErrMsg("表" + table_name + "不支持站点管理").toString();
        }

        boolean isopen = content.getBooleanValue("isopen");
        String condition = content.getString("condition");
        JSONArray foreign_table = content.getJSONArray("foreign_table");
        if (dataarchivingid <= 0 || SQLFactory.createQuerySQL(this, "sys_dataarchiving").setUniqueid(dataarchivingid).query().isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_dataarchiving");
            insertSQL.setValue("issite", issite);
            insertSQL.setValue("table_name", table_name);
            insertSQL.setValue("isopen", isopen);
            insertSQL.setValue("condition", condition);
            insertSQL.setValue("foreign_table", foreign_table);
            insertSQL.insert();
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_dataarchiving").setUniqueid(dataarchivingid);
            updateSQL.setValue("issite", issite);
            updateSQL.setValue("table_name", table_name);
            updateSQL.setValue("isopen", isopen);
            updateSQL.setValue("condition", condition);
            updateSQL.setValue("foreign_table", foreign_table);
            updateSQL.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "数据备份检测", apiversion = R.ID10030301.v1.class)
    public String detection() throws YosException {
        long dataarchivingid = content.getLong("dataarchivingid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_dataarchiving");
        querySQL.setWhere("dataarchivingid", dataarchivingid);
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            String table_name = rows.get(0).getString("table_name");
            String condition = rows.get(0).getString("condition");
            JSONArray foreign_tables = rows.get(0).getJSONArray("foreign_table");

            long count = dbConnect.runSqlQuery("select count(0) as count from " + table_name + " where " + condition).get(0).getLong("count");

            for (int i = 0; i < foreign_tables.size(); i++) {
                JSONObject foreign_table = foreign_tables.getJSONObject(i);
                String sub_table_name = foreign_table.getString("table_name");
                String sub_condition = foreign_table.getString("condition");
                long subcount = dbConnect.runSqlQuery("select count(0) as count from " + sub_table_name + " where " + sub_condition).get(0).getLong("count");
                foreign_table.put("datacount", subcount);
            }
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_dataarchiving");
            updateSQL.setValue("datacount", count);
            updateSQL.setDateValue("detection_time");
            updateSQL.setValue("foreign_tables", foreign_tables);
            updateSQL.setUniqueid(dataarchivingid);
            updateSQL.update();
        }
        return getSucReturnObject().toString();
    }


}
