package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_dataarchiving implements YosObject {
    @Override
    public String table_comment() {
        return "数据备份控制表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("dataarchivingid");
    }

    @Override
    public void DataInit() throws YosException {

    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new SmallIntCol("issite", "是否站点区分", 1));
        list.add(new VarcharCol("table_name", "主表名称", 30));
        list.add(new DateTimeCol("detection_time", "数据检测时间"));
        list.add(new BigIntCol("datacount", "检测匹配行数"));
        list.add(new SmallIntCol("isopen", "是否开启转移备份", 0));
        list.add(new LongTextCol("condition", "备份条件", "备份条件", false, true, "", 10));
        list.add(new JsonCol("foreign_table", "关联表", "[ {\"table_name\": \"\",\"condition\": \"\",\"datacount\":0}]"));
        return list;
    }
}
