/**
 *
 */
package common;

import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.License;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/**
 * @author Administrator
 */
public class InitService implements Runnable, YosLogger {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;

    @Override
    public void run() {
        if (isfirstrun) {
            /**
             * 创建多线程自动任务，线程数为cpu核心数
             */
            service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
            logger.info("启动自动任务");
            isfirstrun = false;
            DBConnect dbConnect = new DBConnect();
            try {
                if (SQLFactory.createQuerySQL(dbConnect, "sys_services").setWhere("classname", "SystemHeartBeat").query().isEmpty()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "SystemHeartBeat");
                    insertSQL.setValue("remarks", "系统心跳上传");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 5);
                    insertSQL.insert();
                }
                if (SQLFactory.createQuerySQL(dbConnect, "sys_services").setWhere("classname", "DataValidate").query().isEmpty()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "DataValidate");
                    insertSQL.setValue("remarks", "数据异常监控");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 30);
                    insertSQL.insert();
                }
                if (SQLFactory.createQuerySQL(dbConnect, "sys_services").setWhere("classname", "AttachmentClean").query().isEmpty()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "AttachmentClean");
                    insertSQL.setValue("remarks", "附件信息清理");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "hour");
                    insertSQL.setValue("count", 12);
                    insertSQL.insert();
                }
                if (SQLFactory.createQuerySQL(dbConnect, "sys_services").setWhere("classname", "CacheMonitoring").query().isEmpty()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "CacheMonitoring");
                    insertSQL.setValue("remarks", "运行内存监控");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 1);
                    insertSQL.insert();
                }
                if (License.get().getLicenseType().equals("Development Certificate")) {
                    //如果是测试服务器，则系统启动时默认关闭所有自动任务
                    dbConnect.runSqlUpdate("update sys_services set isused=0 where classname!='MySqlDataBackUp'");
                }
                Rows rows = dbConnect.runSqlQuery("select classname,isused,remarks,lastruntime,type,count,time from sys_services");
                for (Row row : rows) {
                    addService(row);
                }
            } catch (YosException e) {
                e.printStackTrace();
            }
        }
    }

    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap = new HashMap<>();

    public static void addService(Row row) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            String type = row.getString("type");//second,minute,hour,day,month,year
            int count = row.getInteger("count") <= 0 ? 1 : row.getInteger("count");

            String isused = row.getString("isused");//是否启用
            if (scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> oldscheduledFuture = scheduledFutureMap.get(classname);
                oldscheduledFuture.cancel(false);
                logger.info("服务卸载：" + classname + ";" + remarks);
                scheduledFutureMap.remove(classname);
            }
            Object obj = null;
            Constructor<?> cla = null;
            try {
                Class<?> clz = Class.forName("service." + classname);
                cla = clz.getDeclaredConstructor();
            } catch (Exception e) {
                logger.error("找不到服务类：" + classname + "," + type + "," + isused + ";" + remarks);
                return;
            }

            obj = cla.newInstance();
            logger.info("服务加载：" + classname + "," + type + "," + isused + ";" + remarks);

            ScheduledFuture<?> scheduledFuture = null;
            if (type.equalsIgnoreCase("second")) {
                scheduledFuture = service.scheduleWithFixedDelay((Runnable) obj, 10, count, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("minute")) {
                int delay = 60 - Calendar.getInstance().get(Calendar.SECOND);
                scheduledFuture = service.scheduleAtFixedRate((Runnable) obj, delay, count * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("hour")) {
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00";
                }
                String[] times = time.split(":");
                int schedulesecond = Integer.parseInt(times[0]) * 60 + Integer.parseInt(times[1]);
                Calendar calendar = Calendar.getInstance();
                int syssecond = calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                int delay = schedulesecond - syssecond;
                delay = delay < 0 ? (delay + 60 * 60) : delay;
                scheduledFuture = service.scheduleAtFixedRate((Runnable) obj, delay, count * 60L * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("day")) {
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00:00";
                }
                String[] times = time.split(":");
                int schedulesecond = Integer.parseInt(times[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
                Calendar calendar = Calendar.getInstance();
                int syssecond = calendar.get(Calendar.HOUR_OF_DAY) * 60 * 60 + calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                int delay = schedulesecond - syssecond;
                delay = delay < 0 ? (delay + 60 * 60 * 24) : delay;
                scheduledFuture = service.scheduleAtFixedRate((Runnable) obj, delay, count * 60L * 60L * 24L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("once")) {
                //只在启动时执行或修改重载后执行
                scheduledFuture = service.scheduleWithFixedDelay((Runnable) obj, 10, 5 * 60L, TimeUnit.SECONDS);
            }
            if (scheduledFuture != null) {
                scheduledFutureMap.put(classname, scheduledFuture);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
