/*
 * Decompiled with CFR 0.152.
 */
package utility.valve;

public class ValveUnit {
    public static double getPUnitValue(PUnit fpUnit, double value, PUnit tpUnit) {
        switch (fpUnit) {
            case mH2O: {
                switch (tpUnit) {
                    case mH2O: {
                        return value;
                    }
                    case mmH2O: {
                        return value / 0.001;
                    }
                    case kPa: {
                        return value / 0.10197;
                    }
                    case MPa: {
                        return value / 101.97;
                    }
                    case bar: {
                        return value / 10.197;
                    }
                }
                return 0.0;
            }
            case mmH2O: {
                return ValveUnit.getPUnitValue(PUnit.mH2O, value * 0.001, tpUnit);
            }
            case kPa: {
                return ValveUnit.getPUnitValue(PUnit.mH2O, value * 0.10197, tpUnit);
            }
            case MPa: {
                return ValveUnit.getPUnitValue(PUnit.mH2O, value * 101.97, tpUnit);
            }
            case bar: {
                return ValveUnit.getPUnitValue(PUnit.mH2O, value * 10.197, tpUnit);
            }
        }
        return 0.0;
    }

    public static double getQUnitValue(QUnit fqUnit, double value, QUnit tqUnit) {
        switch (fqUnit) {
            case m3s: {
                switch (tqUnit) {
                    case m3s: {
                        return value;
                    }
                    case m3h: {
                        return value * 3600.0;
                    }
                    case Ls: {
                        return value * 1000.0;
                    }
                    case Lh: {
                        return value * 3600000.0;
                    }
                }
                return 0.0;
            }
            case m3h: {
                return ValveUnit.getQUnitValue(QUnit.m3s, value * 2.777777777777778E-4, tqUnit);
            }
            case Ls: {
                return ValveUnit.getQUnitValue(QUnit.m3s, value * 0.001, tqUnit);
            }
            case Lh: {
                return ValveUnit.getQUnitValue(QUnit.m3s, value * 2.7777777777777776E-7, tqUnit);
            }
        }
        return 0.0;
    }

    public static double getVUnitValue(VUnit fvUnit, double value, VUnit tvunit) {
        switch (fvUnit) {
            case ms: {
                switch (tvunit) {
                    case ms: {
                        return value;
                    }
                    case kms: {
                        return value / 1000.0;
                    }
                }
                return 0.0;
            }
            case kms: {
                return ValveUnit.getVUnitValue(VUnit.ms, value * 1000.0, tvunit);
            }
        }
        return 0.0;
    }

    public static enum VUnit {
        ms,
        kms;

    }

    public static enum QUnit {
        m3s,
        m3h,
        Ls,
        Lh;

    }

    public static enum PUnit {
        mH2O,
        mmH2O,
        kPa,
        MPa,
        bar;

    }
}

