/*
 * Decompiled with CFR 0.152.
 */
package utility.valve;

import common.BaseClass;
import java.util.ArrayList;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import utility.valve.ValvePot;
import utility.valve.ValveUnit;

public class Valve
extends BaseClass {
    private ValvePot valvePot;
    private long itemid = 0L;
    private double D;
    private double kvmax = 0.0;
    private double[] LiArray;
    private double[] KvArray;
    private double[] DcArray;

    public Valve(long itemid, ValvePot valvePot) {
        this.itemid = itemid;
        this.D = 1200.0;
        this.kvmax = 30960.0;
        this.LiArray = new double[]{0.0, 0.05, 0.1, 0.15, 0.18, 0.2, 0.22, 0.25, 0.28, 0.3, 0.32, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0};
        this.KvArray = new double[]{0.0, 1265.0, 2668.0, 4063.0, 4894.0, 5450.0, 6000.0, 6810.0, 7630.0, 8160.0, 8960.0, 10150.0, 14650.0, 18720.0, 22310.0, 25420.0, 28090.0, 30350.0, 30960.0, 30960.0, 30960.0, 30960.0, 30960.0, 30960.0, 30960.0};
        this.DcArray = new double[]{0.0, 0.1082, 0.2151, 0.3022, 0.348, 0.3758, 0.3996, 0.4338, 0.4625, 0.4797, 0.5051, 0.7, 1.1035, 1.1553, 1.1977, 1.2289, 1.2537, 1.2714, 1.275, 1.275, 1.275, 1.275, 1.275, 1.275, 1.275};
        this.valvePot = valvePot;
    }

    public double getItemKV(double li) {
        double kv = -1.0;
        for (int i = 0; i < this.LiArray.length - 1; ++i) {
            if (this.LiArray[i] == li) {
                kv = this.KvArray[i];
                break;
            }
            if (this.LiArray[i + 1] == li) {
                kv = this.KvArray[i + 1];
                break;
            }
            if (!((li - this.LiArray[i]) * (li - this.LiArray[i + 1]) < 0.0)) continue;
            kv = this.getPointY(this.LiArray[i], this.KvArray[i], this.LiArray[i + 1], this.KvArray[i + 1], li);
            break;
        }
        return kv;
    }

    public double getItemDc(double li) {
        double dc = -1.0;
        for (int i = 0; i < this.LiArray.length - 1; ++i) {
            if (this.LiArray[i] == li) {
                dc = this.DcArray[i];
                break;
            }
            if (this.LiArray[i + 1] == li) {
                dc = this.DcArray[i + 1];
                break;
            }
            if (!((li - this.LiArray[i]) * (li - this.LiArray[i + 1]) < 0.0)) continue;
            dc = this.getPointY(this.LiArray[i], this.DcArray[i], this.LiArray[i + 1], this.DcArray[i + 1], li);
            break;
        }
        return dc;
    }

    public double calcLi(double kv) {
        double li = -1.0;
        for (int i = 0; i < this.LiArray.length - 1; ++i) {
            if (this.KvArray[i] == kv) {
                li = this.LiArray[i];
                break;
            }
            if (this.KvArray[i + 1] == kv) {
                li = this.LiArray[i + 1];
                break;
            }
            if (!((kv - this.KvArray[i]) * (kv - this.KvArray[i + 1]) < 0.0)) continue;
            li = this.getPointX(this.LiArray[i], this.KvArray[i], this.LiArray[i + 1], this.KvArray[i + 1], kv);
            break;
        }
        return li;
    }

    public double calcV(double q) {
        q = ValveUnit.getQUnitValue(this.valvePot.getQ_unit(), q, ValveUnit.QUnit.m3s);
        double v = 4000000.0 * q / (Math.PI * Math.pow(this.D, 2.0));
        return ValveUnit.getVUnitValue(ValveUnit.VUnit.ms, v, this.valvePot.getV_unit());
    }

    public double calcQ(double p, double Kv) {
        p = ValveUnit.getPUnitValue(this.valvePot.getP_unit(), p, ValveUnit.PUnit.kPa);
        double \u03c1 = this.valvePot.get\u03c1();
        double q = Kv / (Math.sqrt(\u03c1 / p) * 10.0);
        return ValveUnit.getQUnitValue(ValveUnit.QUnit.m3h, q, this.valvePot.getQ_unit());
    }

    public int calcKV(double p, double q) {
        p = ValveUnit.getPUnitValue(this.valvePot.getP_unit(), p, ValveUnit.PUnit.kPa);
        double \u03c1 = this.valvePot.get\u03c1();
        q = ValveUnit.getQUnitValue(this.valvePot.getQ_unit(), q, ValveUnit.QUnit.m3h);
        double kv = 10.0 * q * Math.sqrt(\u03c1 / p);
        return new Double(Math.ceil(kv)).intValue();
    }

    public double calcDc(double p1, double p2, double v) {
        p1 = ValveUnit.getPUnitValue(this.valvePot.getP_unit(), p1, ValveUnit.PUnit.mH2O);
        p2 = ValveUnit.getPUnitValue(this.valvePot.getP_unit(), p2, ValveUnit.PUnit.mH2O);
        double Pa = this.valvePot.getPa(ValveUnit.PUnit.mH2O);
        double Pv = this.valvePot.getPv(ValveUnit.PUnit.mH2O);
        double g = this.valvePot.getG();
        double V2 = ValveUnit.getVUnitValue(this.valvePot.getV_unit(), v, ValveUnit.VUnit.ms);
        double dc = (p2 + Pa - Pv) / (p1 - p2 + Math.pow(V2, 2.0) * 10.0 / (2.0 * g));
        System.err.println(p2 + Pa - Pv);
        return dc;
    }

    public double calcP2(double p1, double v, double dc) {
        p1 = ValveUnit.getPUnitValue(this.valvePot.getP_unit(), p1, ValveUnit.PUnit.mH2O);
        double Pa = this.valvePot.getPa(ValveUnit.PUnit.mH2O);
        double Pv = this.valvePot.getPv(ValveUnit.PUnit.mH2O);
        double g = this.valvePot.getG();
        double V2 = ValveUnit.getVUnitValue(this.valvePot.getV_unit(), v, ValveUnit.VUnit.ms);
        double pc = (p1 + Pa - Pv - Math.pow(V2, 2.0) * dc * 10.0 / (2.0 * g)) / (1.0 + dc);
        return p1 - pc;
    }

    public double calcP1(double p2, double q, double dc) {
        p2 = ValveUnit.getPUnitValue(this.valvePot.getP_unit(), p2, ValveUnit.PUnit.mH2O);
        double Pa = this.valvePot.getPa(ValveUnit.PUnit.mH2O);
        double Pv = this.valvePot.getPv(ValveUnit.PUnit.mH2O);
        double g = this.valvePot.getG();
        double V2 = ValveUnit.getVUnitValue(this.valvePot.getV_unit(), this.calcV(q), ValveUnit.VUnit.ms);
        double pc = (p2 + Pa - Pv) / dc - Math.pow(V2, 2.0) * 10.0 / (2.0 * g);
        return p2 + pc;
    }

    public static void caculate(String name, double p1, double p2, double q) {
        ValvePot valvePot = new ValvePot(ValveUnit.PUnit.mH2O, ValveUnit.QUnit.m3h, ValveUnit.VUnit.ms);
        Valve valve = new Valve(1L, valvePot);
        double kv = valve.calcKV(p1 - p2, q);
        double v = valve.calcV(q);
        double dc = valve.calcDc(p1, p2, v);
        double li = valve.calcLi(kv);
        double p = p1 - p2;
        double l_dc = valve.getItemDc(li);
        double l_p2 = valve.calcP2(p1, v, l_dc);
        double l_p = p1 - l_p2;
        double fkv = Math.sqrt(p / l_p);
        System.err.println(name + ":");
        System.err.println("    \u9600\u524d\u538b\u529b\uff1a" + p1 + " " + (Object)((Object)valvePot.getP_unit()));
        System.err.println("    \u9600\u540e\u538b\u529b\uff1a" + p2 + " " + (Object)((Object)valvePot.getP_unit()));
        System.err.println("    \u538b\u5dee\uff1a" + p + " " + (Object)((Object)valvePot.getP_unit()));
        System.err.println("    \u6d41\u91cf\uff1a" + q + " " + (Object)((Object)valvePot.getQ_unit()));
        System.err.println("    \u6d41\u901f\uff1a" + v + " " + (Object)((Object)valvePot.getV_unit()));
        System.err.println("    \u5f00\u5ea6\uff1a" + li);
        System.err.println("    KV\uff1a" + kv);
        System.err.println("    \u6c14\u8680\u7cfb\u6570\uff1a" + dc);
        System.err.println("    \u4e34\u754c\u9600\u540e\u538b\u529b\uff1a" + l_p2 + " " + (Object)((Object)valvePot.getP_unit()));
        System.err.println("    \u4e34\u754c\u538b\u5dee\uff1a" + l_p + " " + (Object)((Object)valvePot.getP_unit()));
        System.err.println("    \u4e34\u754c\u6c14\u8680\u7cfb\u6570\uff1a" + l_dc);
        System.err.println("    fkv\uff1a" + fkv);
    }

    public static void calulateByLi(String name, double p1, double p2, double li) {
        ValvePot valvePot = new ValvePot(ValveUnit.PUnit.mH2O, ValveUnit.QUnit.m3h, ValveUnit.VUnit.ms);
        Valve valve = new Valve(1L, valvePot);
        double kv = valve.getItemKV(li);
        double q = valve.calcQ(p1 - p2, kv);
        Valve.caculate(name, p1, p2, q);
    }

    public static void main(String[] args) {
        Valve.caculate("\u5c0f\u538b\u5dee\uff0c\u5c0f\u6d41\u91cf", 565.0, 535.0, 1108.0);
    }

    private double getPointY(double x1, double y1, double x2, double y2, double pointx) {
        double[] x = new double[]{x1, x2};
        double[] y = new double[]{y1, y2};
        ArrayList<WeightedObservedPoint> obs = new ArrayList<WeightedObservedPoint>();
        for (int n = 0; n < x.length; ++n) {
            obs.add(new WeightedObservedPoint(1.0, x[n], y[n]));
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)1);
        double[] coefficients = fitter.fit(obs);
        return coefficients[0] + coefficients[1] * pointx;
    }

    private double getPointX(double x1, double y1, double x2, double y2, double pointY) {
        double[] x = new double[]{x1, x2};
        double[] y = new double[]{y1, y2};
        ArrayList<WeightedObservedPoint> obs = new ArrayList<WeightedObservedPoint>();
        for (int n = 0; n < x.length; ++n) {
            obs.add(new WeightedObservedPoint(1.0, x[n], y[n]));
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)1);
        double[] coefficients = fitter.fit(obs);
        return (pointY - coefficients[0]) / coefficients[1];
    }
}

