/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.sysmsg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.management.OperatingSystemMXBean;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnectPool;
import common.parameter.License;
import common.parameter.parameter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.List;
import restcontroller.R;
import utility.tools.Math;

public class sysmsg
extends Controller {
    public sysmsg(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u7cfb\u7edf\u76d1\u63a7", apiversion=R.ID10024601.v1.class)
    public String getMsg() throws YosException {
        long mtimes;
        long hourtimes;
        JSONObject object = new JSONObject();
        License license = License.get();
        JSONObject yosObject = new JSONObject();
        yosObject.put("VerifyDays", (Object)license.getVerifyDays());
        yosObject.put("LicenseType", (Object)license.getLicenseType());
        yosObject.put("Customer", (Object)license.getCustomer());
        yosObject.put("MaxDBConCount", (Object)license.getMaxDBConCount());
        yosObject.put("ExpiresDate", (Object)sysmsg.getDate_Str(license.getExpiresDate()));
        object.put("yoslicense", (Object)yosObject);
        OperatingSystemMXBean system2 = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        JSONObject systemObject = new JSONObject();
        systemObject.put("Name", (Object)system2.getName());
        systemObject.put("Version", (Object)system2.getVersion());
        systemObject.put("Arch", (Object)system2.getArch());
        systemObject.put("TotalPhysicalMemorySize", (Object)Math.div(system2.getTotalPhysicalMemorySize(), 1.073741824E9, 0));
        systemObject.put("FreePhysicalMemorySize", (Object)Math.div(system2.getFreePhysicalMemorySize(), 1.073741824E9, 2));
        systemObject.put("ProcessCpuLoad", (Object)Math.mul(system2.getProcessCpuLoad(), 100.0, 2));
        systemObject.put("SystemCpuLoad", (Object)Math.mul(system2.getSystemCpuLoad(), 100.0, 2));
        try {
            systemObject.put("HostName", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        systemObject.put("AvailableProcessors", (Object)system2.getAvailableProcessors());
        object.put("system", (Object)systemObject);
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        JSONObject javaObject = new JSONObject();
        javaObject.put("PID", (Object)runtime.getName().split("@")[0]);
        javaObject.put("SpecVersion", (Object)runtime.getSpecVersion());
        javaObject.put("StartTime", (Object)sysmsg.getDateTime_Str(runtime.getStartTime()));
        javaObject.put("VmVersion", (Object)runtime.getVmVersion());
        javaObject.put("maxMemory", (Object)Math.div(Runtime.getRuntime().maxMemory(), 1.073741824E9, 2));
        long runtitme = runtime.getUptime();
        Object timestr = "";
        long daytimes = 86400000L;
        if (runtitme / daytimes > 0L) {
            timestr = runtitme / daytimes + "\u5929";
            runtitme %= daytimes;
        }
        if (runtitme / (hourtimes = 3600000L) > 0L) {
            timestr = (String)timestr + runtitme / hourtimes + "\u5c0f\u65f6";
            runtitme %= hourtimes;
        }
        if (runtitme / (mtimes = 60000L) > 0L) {
            timestr = (String)timestr + runtitme / mtimes + "\u5206";
        }
        javaObject.put("UpTime", timestr);
        JSONObject array = new JSONObject();
        List<GarbageCollectorMXBean> garbages = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean g : garbages) {
            JSONObject object1 = new JSONObject();
            object1.put("count", (Object)g.getCollectionCount());
            object1.put("time", (Object)g.getCollectionTime());
            array.put(g.getName().replace(" ", ""), (Object)object1);
        }
        javaObject.put("GarbageCollector", (Object)array);
        JSONObject MemoryUsageObject = new JSONObject();
        MemoryUsageObject.put("NonHeap", JSON.toJSON((Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
        MemoryUsageObject.put("Heap", JSON.toJSON((Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
        javaObject.put("MemoryUsage", (Object)MemoryUsageObject);
        List<MemoryPoolMXBean> memoryPoolMXBeansList = ManagementFactory.getMemoryPoolMXBeans();
        JSONObject memoryPoolMXBeansObject = new JSONObject();
        for (MemoryPoolMXBean m : memoryPoolMXBeansList) {
            String poolname = m.getName().replace(" ", "");
            memoryPoolMXBeansObject.put(poolname, JSON.toJSON((Object)m.getUsage()));
        }
        javaObject.put("MemoryPool", (Object)memoryPoolMXBeansObject);
        object.put("java", (Object)javaObject);
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        JSONObject threadObject = new JSONObject();
        threadObject.put("threadCount", (Object)thread.getThreadCount());
        threadObject.put("peakThreadCount", (Object)thread.getPeakThreadCount());
        long[] deadlockedIds = thread.findDeadlockedThreads();
        if (deadlockedIds != null && deadlockedIds.length > 0) {
            threadObject.put("deadlockedthreads", JSON.toJSON((Object)thread.getThreadInfo(deadlockedIds)));
        } else {
            threadObject.put("deadlockedthreads", (Object)new JSONArray());
        }
        object.put("threads", (Object)threadObject);
        JSONObject mysqlObject = new JSONObject();
        mysqlObject.put("Version", (Object)this.dbConnect.runSqlQuery("select version() as version ").get(0).getString("version"));
        Rows variableRows = this.dbConnect.runSqlQuery("show variables where Variable_name in('innodb_buffer_pool_size','innodb_log_file_size','innodb_log_buffer_size','key_buffer_size','tmp_table_size','read_buffer_size','sort_buffer_size','read_rnd_buffer_size')");
        mysqlObject.put("Variables", (Object)variableRows);
        JSONArray processArray = new JSONArray();
        Rows processRows = this.dbConnect.runSqlQuery("SHOW full PROCESSLIST");
        for (Row processRow : processRows) {
            if (processRow.getString("User").equalsIgnoreCase("event_scheduler")) continue;
            JSONObject ProcessObject = new JSONObject();
            ProcessObject.put("User", (Object)processRow.getString("User"));
            ProcessObject.put("Command", (Object)processRow.getString("Command"));
            ProcessObject.put("State", (Object)processRow.getString("State"));
            ProcessObject.put("Time", (Object)processRow.getString("Time"));
            ProcessObject.put("Id", (Object)processRow.getLong("Id"));
            ProcessObject.put("Info", (Object)processRow.getString("Info"));
            ProcessObject.put("db", (Object)processRow.getString("db"));
            if (DBConnectPool.connectionIDList.contains(processRow.getLong("Id"))) {
                ProcessObject.put("from", (Object)"yos");
            } else {
                ProcessObject.put("from", (Object)"other");
            }
            processArray.add((Object)ProcessObject);
        }
        processArray.sort((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                JSONObject object1 = (JSONObject)o1;
                JSONObject object2 = (JSONObject)o2;
                String Command_o1 = "";
                String Command_o2 = "";
                String From_o1 = "";
                String From_o2 = "";
                try {
                    Command_o1 = object1.getString("Command");
                    Command_o2 = object2.getString("Command");
                    From_o1 = object1.getString("from");
                    From_o2 = object2.getString("from");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (From_o1.equals("yos") && !From_o1.equals(From_o2)) {
                    return -2;
                }
                if (!Command_o1.equals("Sleep") && !Command_o2.equals(Command_o1)) {
                    return -1;
                }
                if (Command_o1.equals(Command_o2)) {
                    return 0;
                }
                return 1;
            }
        });
        mysqlObject.put("Processlist", (Object)processArray);
        int ConnectPoolsSize = DBConnectPool.POOLS_MAP.get("default").size();
        int ConnectTotalCount = ConnectPoolsSize + DBConnectPool.useingConnectionkeyMap.get("default").size();
        mysqlObject.put("ConnectPoolsSize", (Object)(ConnectPoolsSize == 0 ? ConnectPoolsSize : ConnectPoolsSize - 1));
        mysqlObject.put("ConnectTotalCount", (Object)ConnectTotalCount);
        object.put("mysql", (Object)mysqlObject);
        Object[] usersiteids = parameter.websocketClients.keySet().toArray(new Long[0]);
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_usersite", "usersiteid", "userid", "siteid", "usertype");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_users", "sys_users", "userid=:userid", "accountno", "name", "sysadministrator", "phonenumber");
        querySQL.setWhere("usersiteid", usersiteids);
        Rows loginuserrows = querySQL.query();
        object.put("loginusers", (Object)loginuserrows);
        QuerySQL querySQL2 = SQLFactory.createQuerySQL(this, "sys_usersite", "usersiteid", "userid", "siteid", "usertype");
        querySQL2.addJoinTable(BaseClass.JOINTYPE.inner, "sys_users", "sys_users", "userid=:userid", "accountno", "name", "sysadministrator", "phonenumber");
        querySQL2.addJoinTable(BaseClass.JOINTYPE.inner, "sys_userrequestlog", "sys_userrequestlog", "usersiteid=:usersiteid");
        querySQL2.addQueryFields("requesttimes", "sum(requesttimes)").addQueryFields("lastrequestdate", "max(lastrequestdate)");
        querySQL2.addGroupBy(new String[0]);
        querySQL2.setWhere("sys_userrequestlog.date=date_format(now(),'%Y-%m-%d')");
        Rows loginuserrows2 = querySQL2.query();
        object.put("requestusers", (Object)loginuserrows2);
        Rows rows = this.dbConnect.runSqlQuery("select postfix,count(0) filecount,sum(contentlength) as contentlength from sys_attachment group by postfix order by sum(contentlength) desc");
        for (Row row : rows) {
            double contentlength = row.getDouble("contentlength");
            if (contentlength / 1.073741824E9 > 1.0) {
                row.put("contentlength", Math.div(contentlength, 1.073741824E9, 2) + " GB");
                continue;
            }
            if (contentlength / 1048576.0 > 1.0) {
                row.put("contentlength", Math.div(contentlength, 1048576.0, 2) + " MB");
                continue;
            }
            if (contentlength / 1024.0 > 1.0) {
                row.put("contentlength", Math.div(contentlength, 1024.0, 2) + " KB");
                continue;
            }
            row.put("contentlength", new Double(contentlength).longValue() + " byte");
        }
        object.put("attachmentmsg", (Object)rows);
        return this.getSucReturnObject().setData(object).toString();
    }
}

