package utility.valve;


public class ValveUnit {
    /**
     * 压力单位
     */
    public enum PUnit {
        mH2O,//米水柱压，标准计算单位
        mmH2O,//毫米水柱压
        kPa,//千帕
        MPa,//兆帕
        bar
    }

    /**
     * 根据指定的压力单位值转换成指定的压力单位值
     *
     * @param fpUnit
     * @param value
     * @return
     */
    public static double getPUnitValue(ValveUnit.PUnit fpUnit, double value, ValveUnit.PUnit tpUnit) {
        switch (fpUnit) {
            case mH2O: {
                switch (tpUnit) {
                    case mH2O: {
                        return value;
                    }
                    case mmH2O: {
                        return value / 0.001;
                    }
                    case kPa: {
                        return value / 0.10197;
                    }
                    case MPa: {
                        return value / 101.97;
                    }
                    case bar: {
                        return value / 10.197;
                    }
                    default:
                        return 0;
                }
            }
            case mmH2O: {
                return getPUnitValue(ValveUnit.PUnit.mH2O, value * 0.001, tpUnit);
            }
            case kPa: {
                return getPUnitValue(ValveUnit.PUnit.mH2O, value * 0.10197, tpUnit);
            }
            case MPa: {
                return getPUnitValue(ValveUnit.PUnit.mH2O, value * 101.97, tpUnit);
            }
            case bar: {
                return getPUnitValue(ValveUnit.PUnit.mH2O, value * 10.197, tpUnit);
            }
            default:
                return 0;
        }
    }


    /**
     * 流量单位
     */
    public enum QUnit {
        m3s,//立方米每秒，标准计算单位
        m3h,//立方米每小时
        Ls,//升每秒
        Lh//升每小时
    }

    public static double getQUnitValue(ValveUnit.QUnit fqUnit, double value, ValveUnit.QUnit tqUnit) {
        switch (fqUnit) {
            case m3s: {
                switch (tqUnit) {
                    case m3s: {
                        return value;
                    }
                    case m3h: {
                        return value * 3600.00;
                    }
                    case Ls: {
                        return value * 1000.00;
                    }
                    case Lh: {
                        return value * 3600000.00;
                    }
                    default:
                        return 0;
                }
            }
            case m3h: {
                return getQUnitValue(ValveUnit.QUnit.m3s, value * (1.0 / 3600.00), tqUnit);
            }
            case Ls: {
                return getQUnitValue(ValveUnit.QUnit.m3s, value * 0.001, tqUnit);
            }
            case Lh: {
                return getQUnitValue(ValveUnit.QUnit.m3s, value * (1.0 / 3600000.00), tqUnit);
            }
            default:
                return 0;
        }
    }

    /**
     * 流速单位
     */
    public enum VUnit {
        ms,//米每秒，标准计算单位
        kms,//千米每秒
    }

    public static double getVUnitValue(ValveUnit.VUnit fvUnit, double value, ValveUnit.VUnit tvunit) {
        switch (fvUnit) {
            case ms: {
                switch (tvunit) {
                    case ms: {
                        return value;
                    }
                    case kms: {
                        return value / 1000.00;
                    }
                    default:
                        return 0;
                }
            }
            case kms: {
                return getVUnitValue(ValveUnit.VUnit.ms, value * 1000.00, tvunit);
            }
            default:
                return 0;
        }
    }
}
