package utility.iot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import utility.iot.pojo.*;
import utility.tools.WebRequest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class CMIOT extends BaseClass {

    String cmiot_appid = "C5010571087105571571000";
    String cmiot_password = "wswNEcFEVr.3";
    WebRequest webRequest = new WebRequest();
    public String ICCID;

    public CMIOT(String siteid, String ICCID) throws YosException {
        this.ICCID = ICCID;
        Rows rows = dbConnect.runSqlQuery("select * from w_iotcard_param t1 inner join w_iotcard t2 on t1.siteid=t2.siteid and t1.w_iotcard_paramid=t2.w_iotcard_paramid" +
                " where t1.siteid='" + siteid + "' and t2.iccid='" + ICCID + "'");
        if (rows.isNotEmpty()) {
            cmiot_appid = rows.get(0).getString("cmiot_appid");
            cmiot_password = rows.get(0).getString("cmiot_password");
        }
    }

    public CMIOT(String w_iotcard_paramid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from w_iotcard_param t1 where t1.w_iotcard_paramid='" + w_iotcard_paramid + "'");
        if (rows.isNotEmpty()) {
            cmiot_appid = rows.get(0).getString("cmiot_appid");
            cmiot_password = rows.get(0).getString("cmiot_password");
        }
    }

    public void setICCID(String ICCID) {
        this.ICCID = ICCID;
    }

//    public CMIOT(String cmiot_appid, String cmiot_password) {
//        this.cmiot_appid = cmiot_appid;
//        this.cmiot_password = cmiot_password;
//    }

//
//    public static void main(String[] args) throws YosException {
//        CMIOT cmiot = new CMIOT("C5010571087105571571000", "wswNEcFEVr.3");
////        ArrayList<String> list = new ArrayList<>();
////        list.add("89860464112380000251");
//        System.err.println(JSONObject.toJSON(cmiot.sim_basic_info("89860073111553121632")));
//    }

    /**
     * @param chargeMoney 充值金额 单位：元(1.00元—500.00元之间)
     * @param paymentType 支付方式： ALIPAY-WAP:支付宝-手机网站支付 ALIPAY-WEB:支付宝-网页即时到账支付 ALIPAY-BANK:网银支付 WEIXIN-JSAPI:微信-公众号支付 WEIXIN-NATIVE:微信-扫码支付
     * @return
     * @throws YosException
     */
    public JSONObject getPayUrl(String msisdn, double chargeMoney, String paymentType) throws YosException {
        StringBuffer urlBuffer = new StringBuffer("https://api.iot.10086.cn/v5/ec/recharge/sim-account?transid=" + getTransid() + "&token=" + getToken());
        urlBuffer.append("&entityType=1");//充值标识类型： 1：msisdn 2：账户Id
        urlBuffer.append("&entityId=").append(msisdn);
        urlBuffer.append("&chargeMoney=").append(chargeMoney);
        urlBuffer.append("&paymentType=").append(paymentType);

        String result = webRequest.doGet(urlBuffer.toString());
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            return object.getJSONArray("result").getJSONObject(0);
        } else {
            throw new YosException(false, object.getString("message"));
        }
    }


    /**
     * @param orderNo
     * @return
     * @throws YosException
     */
    public JSONObject queryPayStatus(String orderNo) throws YosException {
        StringBuffer urlBuffer = new StringBuffer("https://api.iot.10086.cn/v5/ec/query/sim-account-recharge-result?transid=" + getTransid() + "&token=" + getToken());
        urlBuffer.append("&orderNo=").append(orderNo);
        urlBuffer.append("&startNum=1");
        urlBuffer.append("&pageSize=50");

        String result = webRequest.doGet(urlBuffer.toString());
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            JSONArray array = object.getJSONArray("result").getJSONObject(0).getJSONArray("orderList");
            if (array.size() > 0) {
                return array.getJSONObject(0);
            }
        }
        return new JSONObject();
    }

    /**
     * @param startTime 订单开始时间 yyyyMMddHHmmss
     * @param endTime   订单结束时间 yyyyMMddHHmmss
     * @return
     * @throws YosException
     */
    public JSONArray queryPayStatus(String startTime, String endTime) throws YosException {
        StringBuffer urlBuffer = new StringBuffer("https://api.iot.10086.cn/v5/ec/query/sim-account-recharge-result?transid=" + getTransid() + "&token=" + getToken());
        urlBuffer.append("&startTime=").append(startTime);
        urlBuffer.append("&endTime=").append(endTime);
        urlBuffer.append("&startNum=1");
        urlBuffer.append("&pageSize=50");

        String result = webRequest.doGet(urlBuffer.toString());
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            return object.getJSONArray("result").getJSONObject(0).getJSONArray("orderList");
        }
        return null;
    }

    /**
     * 获取sim卡基本信息
     *
     * @return
     * @throws YosException
     */
    public sim_basic_info sim_basic_info() throws YosException {
        sim_basic_info sim_basic_info = new sim_basic_info();
        String result = webRequest.doGet("https://api.iot.10086.cn/v5/ec/query/sim-basic-info?transid=" + getTransid() + "&token=" + getToken() + "&iccid=" + ICCID);
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            JSONObject resultObject = object.getJSONArray("result").getJSONObject(0);
            sim_basic_info.setIccid(resultObject.getString("iccid"));
            sim_basic_info.setActiveDate(resultObject.getString("activeDate"));
            sim_basic_info.setImsi(resultObject.getString("imsi"));
            sim_basic_info.setMsisdn(resultObject.getString("msisdn"));
            sim_basic_info.setOpenDate(resultObject.getString("openDate"));
            sim_basic_info.setRemark(resultObject.getString("remark"));
        }
        return sim_basic_info;
    }

    /**
     * 获取sim卡位置信息
     *
     * @return
     * @throws YosException
     */
    public sim_position_info sim_position_info() throws YosException {
        sim_position_info sim_position_info = new sim_position_info();
        String result = webRequest.doGet("https://api.iot.10086.cn/v5/ec/query/position-location-message?transid=" + getTransid() + "&token=" + getToken() + "&iccid=" + ICCID);
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            JSONObject resultObject = object.getJSONArray("result").getJSONObject(0);
            sim_position_info.setLat(resultObject.getString("lat"));
            sim_position_info.setLon(resultObject.getString("lon"));
        }
        return sim_position_info;
    }

    /**
     * 获取sim状态
     *
     * @return
     * @throws YosException
     */
    public sim_status sim_status() throws YosException {
        sim_status sim_status = new sim_status();
        String result = webRequest.doGet("https://api.iot.10086.cn/v5/ec/query/sim-status?transid=" + getTransid() + "&token=" + getToken() + "&iccid=" + ICCID);
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            JSONObject resultObject = object.getJSONArray("result").getJSONObject(0);
            sim_status.setCardStatus(resultObject.getString("cardStatus"));
            sim_status.setLastChangeDate(resultObject.getString("lastChangeDate"));
        }
        return sim_status;
    }

    /**
     * 获取sim卡设备的开机状态
     *
     * @return
     * @throws YosException
     */
    public boolean sim_onoff() throws YosException {
        String result = webRequest.doGet("https://api.iot.10086.cn/v5/ec/query/on-off-status?transid=" + getTransid() + "&token=" + getToken() + "&iccid=" + ICCID);
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            JSONObject resultObject = object.getJSONArray("result").getJSONObject(0);
            return resultObject.getString("status").equals("1");
        }
        return false;
    }

    /**
     * 查询账户余额
     *
     * @return
     * @throws YosException
     */
    public balance_info balance_info() throws YosException {
        balance_info balance_info = new balance_info();
        String result = webRequest.doGet("https://api.iot.10086.cn/v5/ec/query/balance-info?transid=" + getTransid() + "&token=" + getToken() + "&iccid=" + ICCID);
        JSONObject object = JSONObject.parseObject(result);
        if (object.getStringValue("status").equals("0") && object.containsKey("result") && object.getJSONArray("result").size() > 0) {
            JSONObject resultObject = object.getJSONArray("result").getJSONObject(0);
            balance_info.setAccountName(resultObject.getString("accountName"));
            balance_info.setAccountId(resultObject.getString("accountId"));
            balance_info.setAmount(resultObject.getString("amount"));
            balance_info.setLateFree(resultObject.getString("lateFree"));
        }
        return balance_info;
    }

    public static void main(String[] args) throws YosException {
        CMIOT cmiot = new CMIOT("11");
        cmiot.setICCID("89860464112380000250");
        System.err.println(JSON.toJSON(cmiot.sim_data_usage()));
    }

    public sim_data_usage sim_data_usage() throws YosException {
        ArrayList<String> list = new ArrayList<>();
        list.add(ICCID);
        return sim_data_usage(list).getOrDefault(ICCID, new sim_data_usage());
    }

    /**
     * 查询本月的流量使用情况
     *
     * @param ICCIDS
     * @return
     * @throws YosException
     */
    private HashMap<String, sim_data_usage> sim_data_usage(ArrayList<String> ICCIDS) throws YosException {
        HashMap<String, sim_data_usage> map = new HashMap<>();
        for (String ICCID : ICCIDS) {
            sim_data_usage sim_data_usage_monthly = new sim_data_usage();
            sim_data_usage_monthly.setIccid(ICCID);

            ArrayList<sim_data_usage.accmMargin> accmmarginlist = new ArrayList<>();

            String marginResult = webRequest.doGet("https://api.iot.10086.cn/v5/ec/query/sim-data-margin?transid=" + getTransid() + "&token=" + getToken() + "&iccid=" + sim_data_usage_monthly.getIccid());
            JSONObject marginResultJSONObject = JSONObject.parseObject(marginResult);
            if (marginResultJSONObject.getStringValue("status").equals("0") && marginResultJSONObject.containsKey("result") && marginResultJSONObject.getJSONArray("result").size() > 0) {
                JSONArray accmMarginList = marginResultJSONObject.getJSONArray("result").getJSONObject(0).getJSONArray("accmMarginList");
                for (Object accmMarginObject : accmMarginList) {
                    JSONObject accmMarginJSONObject = (JSONObject) accmMarginObject;
                    sim_data_usage.accmMargin accmMargin = sim_data_usage_monthly.new accmMargin();
                    accmMargin.setOfferingName(accmMarginJSONObject.getString("offeringName"));
                    accmMargin.setOfferingId(accmMarginJSONObject.getString("offeringId"));
                    accmMargin.setRemainAmount(accmMarginJSONObject.getString("remainAmount"));
                    accmMargin.setTotalAmount(accmMarginJSONObject.getString("totalAmount"));
                    accmMargin.setUseAmount(accmMarginJSONObject.getString("useAmount"));
                    accmmarginlist.add(accmMargin);
                }
            }
            sim_data_usage_monthly.setAccmMarginList(accmmarginlist);
            map.put(sim_data_usage_monthly.getIccid(), sim_data_usage_monthly);
        }
        return map;
    }


    private static HashMap<String, String> apptokenmap = new HashMap<>();//appid,token
    private static HashMap<String, Long> tokenttlmap = new HashMap<>();//appid,token有效截止时间

    private String getToken() throws YosException {
        if (apptokenmap.containsKey(cmiot_appid) && tokenttlmap.containsKey(cmiot_appid) && tokenttlmap.get(cmiot_appid) - (600 * 1000) > Calendar.getInstance().getTimeInMillis()) {
            return apptokenmap.get(cmiot_appid);
        } else {
            String result = webRequest.doGet("https://api.iot.10086.cn/v5/ec/get/token?appid=" + cmiot_appid + "&password=" + cmiot_password + "&transid=" + getTransid());
            JSONObject object = JSONObject.parseObject(result);
            if (object.getIntValue("status") == 0 && object.getStringValue("message").equals("正确")) {
                JSONArray resultarray = object.getJSONArray("result");
                if (resultarray.size() == 1) {
                    String token = ((JSONObject) resultarray.get(0)).getString("token");
                    apptokenmap.put(cmiot_appid, token);
                    tokenttlmap.put(cmiot_appid, ((JSONObject) resultarray.get(0)).getLongValue("ttl"));
                    return token;
                }
            }
        }
        return "";
    }

    private String getTransid() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return cmiot_appid + format.format(calendar.getTime()) + (id++);
    }

    private static long id = 800000001L;
}
