package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_resources implements YosObject {
    @Override
    public String table_comment() {
        return "系统资源表";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("sys_resourcesid", "系统资源表ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, true, false, false, "", 1));
        arrayList.add(new VarcharCol("resourcename", "资源名称", "资源名称", 50, true, false, false, "", 3));
        arrayList.add(new VarcharCol("type", "资源类型", "网址、附件", 50, false, false, false, "网址", 2));
        arrayList.add(new VarcharCol("remarks", "资源描述", "资源描述", 500, true, false, false, "", 4));
        arrayList.add(new VarcharCol("url", "文件访问路径", "文件访问路径", 500, true, false, false, "", 5));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
