package common.uibuilder;

import common.YosException;
import common.uibuilder.control.*;

public class AppUIBuilder {

    public static AppUI create(long systemappid) {
        return new AppUI(systemappid);
    }

    public static void main(String[] args) throws YosException {
        AppUI appUI = AppUIBuilder.create(147);
        appUI.setApiID(123123123, 1);
        appUI.setMainTable("sa_order");

        Tabs tabs = new Tabs("标签组");
        {
            Tab listtab = new Tab("列表");

            Table table = new Table("查询列表").addCol(new TableCol("orderno", "订单号")).addCol(new TableCol("amount", "金额"));

            listtab.add(table);
            tabs.addTab(listtab);
        }


        tabs.addTab(new Tab("详情页").add(new Form("表单1")));

        appUI.addView(tabs);

        System.err.println(appUI.getUI());
    }
}
