package common.mq;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.YosLogger;
import common.data.*;
import common.data.db.DBConnect;
import common.data.db.InfluxDBConnect;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class MQMessage implements MqttCallback, YosLogger {
    long sys_mqid;

    public MQMessage(long sys_mqid) {
        this.sys_mqid = sys_mqid;
    }

    private static HashMap<String, Integer> topicsdaymap = new HashMap<>();

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        BaseClass baseClass = new BaseClass();
        if (Parameter.get("system_topic_log").equalsIgnoreCase("true")) {
            InsertSQL rowInsert = SQLFactory.createInsertSQL(baseClass.dbConnect, "w_device_topics_log");
            rowInsert.setValue("w_device_topics_logid", baseClass.createTableID("w_device_topics_log"));
            rowInsert.setValue("topic", topic);
            rowInsert.setValue("content", new String(mqttMessage.getPayload(), StandardCharsets.UTF_8));
            rowInsert.setDateValue("createdate");
            rowInsert.insert();

            //删除历史数据，保留指定的记录数量

            long topics_log_savecount;
            try {
                topics_log_savecount = Long.parseLong(Parameter.get("topics_log_savecount"));
            } catch (Exception e) {
                e.printStackTrace();
                topics_log_savecount = 10;
            }
            baseClass.dbConnect.runSqlUpdate("delete t1 from w_device_topics_log t1 \n" +
                    "left join (select w_device_topics_logid from w_device_topics_log where topic='" + topic + "' order by w_device_topics_logid desc limit " + topics_log_savecount + ") t2 on t1.w_device_topics_logid=t2.w_device_topics_logid\n" +
                    "where t1.topic='" + topic + "' and t2.w_device_topics_logid is null");
        }
        {
            /*
            统计消息的收发次数
             */
            int day = Calendar.getInstance().get(Calendar.DATE);
            if (!topicsdaymap.containsKey(topic) || topicsdaymap.get(topic) != day) {
                InsertSQL rowInsert = SQLFactory.createInsertSQL(baseClass.dbConnect, "w_topics_statistics");
                rowInsert.setValue("w_topics_statisticsid", baseClass.createTableID("w_topics_statistics"));
                rowInsert.setValue("times", 0);
                rowInsert.setValue("topic", topic);
                rowInsert.setDateValue("`date`");
                rowInsert.setDateValue("lasttime");
                rowInsert.setWhere("not exists(select *from w_topics_statistics where topic='" + topic + "' and `date`='" + baseClass.getDate_Str() + "')");
                rowInsert.insert();
                topicsdaymap.put(topic, day);
            }
            baseClass.dbConnect.runSqlUpdate("update w_topics_statistics set times=times+1,lasttime=now() where topic='" + topic + "' and `date`='" + baseClass.getDate_Str() + "'");
        }
        if (topic.endsWith("data")) {
            try {
                Rows w_deviceRows = baseClass.dbConnect.runSqlQuery("select t1.siteid,t1.w_deviceid,t2.w_productid,t2.isfeedback,t3.issystem,t3.jarpath from w_device_topics t1 " +
                        "inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid " +
                        "inner join sys_msgprotocol t3 on t2.sys_msgprotocolid=t3.sys_msgprotocolid and t3.protocoltype='mqtt' " +
                        "where t2.isused=1 and t1.topic='" + topic + "'");
                for (Row w_deviceRow : w_deviceRows) {
                    String siteid = w_deviceRow.getString("siteid");
                    long w_deviceid = w_deviceRow.getLong("w_deviceid");
                    long w_productid = w_deviceRow.getLong("w_productid");
                    boolean isfeedback = w_deviceRow.getBoolean("isfeedback");
                    boolean issystem = w_deviceRow.getBoolean("issystem");
                    MQDatas mqDatas;
                    if (issystem) {
                        mqDatas = new MQDatas();
                        String message = new String(mqttMessage.getPayload(), StandardCharsets.UTF_8);
                        JSONObject dataObject = JSONObject.parseObject(message);
                        MQDatas.MQData mqData = mqDatas.createMQData(dataObject.getLong("ts"));
                        JSONObject data = dataObject.getJSONObject("d");
                        for (String key : data.keySet()) {
                            mqData.put(key, data.get(key));
                        }
                        if (isfeedback && dataObject.containsKey("msgid")) {
                            baseClass.dbConnect.runSqlUpdate("update w_function_queue set isreceive=1,receivetime='" + dataObject.getStringValue("ts") + "' where msgid='" + dataObject.getString("msgid") + "' and isreceive=0");
                        }
                    } else {
                        String jarpath = w_deviceRow.getString("jarpath");
                        if (System.getProperty("os.name").contains("Windows")) {
                            jarpath = "file:/" + jarpath;
                        } else {
                            jarpath = "file://" + jarpath;
                        }
                        Class<?> MsgProtocol = Class.forName(
                                "MsgProtocol",
                                true,
                                new URLClassLoader(new URL[]{new URL(jarpath)}, this.getClass().getClassLoader())
                        );
                        Object instance = MsgProtocol.newInstance();
                        Method method = MsgProtocol.getDeclaredMethod("receive", String.class, byte[].class, MQDatas.class);
                        mqDatas = (MQDatas) method.invoke(instance, topic, mqttMessage.getPayload(), new MQDatas());
                    }
                    if (mqDatas.size() > 0) {
                        messageSave(siteid, w_productid, w_deviceid, mqDatas);
                    }
                    /*
                    如果当前设备状态不是在线状态，则将设备状态改为在线状态
                     */
                    //baseClass.dbConnect.runSqlUpdate("update w_device set status='在线',lastconnecttime=now() where w_deviceid=" + w_deviceid);
                }
            } catch (Exception e) {
                e.printStackTrace();

            }
        } else if (topic.endsWith("rec")) {
            String recmsg = new String(mqttMessage.getPayload(), StandardCharsets.UTF_8);
            try {
                JSONObject object = JSONObject.parseObject(recmsg);
                if (object.containsKey("msgid")) {
                    baseClass.dbConnect.runSqlUpdate("update w_function_queue set isreceive=1,receivetime='" + object.getStringValue("ts") + "' where msgid='" + object.getString("msgid") + "' and isreceive=0");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 消息处理，存储、转发
     *
     * @param siteid
     * @param w_productid
     * @param w_deviceid
     * @param mqDatas
     * @throws YosException
     */
    public void messageSave(String siteid, long w_productid, long w_deviceid, MQDatas mqDatas) throws YosException {
        BaseClass baseClass = new BaseClass();
        RowsMap w_dataparamList_save = baseClass.dbConnect.runSqlQuery("select param,datatype from w_dataparam where siteid='" + siteid + "' and ownertable='w_device' and ownerid=" + w_deviceid + " and rwtype=2").toRowsMap("param");
        RowsMap w_dataparamList_read = baseClass.dbConnect.runSqlQuery("select param,datatype from w_dataparam where siteid='" + siteid + "' and ownertable='w_device' and ownerid=" + w_deviceid).toRowsMap("param");
        for (MQDatas.MQData mqData : mqDatas) {
            ArrayList<String> sqlist = new ArrayList<>();
            Row dataRow = new Row();
            HashMap<String, String> column_type = new HashMap<>();
            for (String key : mqData.keySet()) {
                Object value = mqData.get(key);

                if (w_dataparamList_save.containsKey(key)) {
                    String datatype = w_dataparamList_save.get(key).get(0).getString("datatype");
                    dataRow.put(key, value);
                    column_type.put(key, datatype);
                }

                if (w_dataparamList_read.containsKey(key)) {
                    String datatype = w_dataparamList_read.get(key).get(0).getString("datatype");
                    if (datatype.equals("boolean") && value != null) {
                        if (value instanceof Number) {
                            value = ((Number) value).intValue();
                        } else if (value instanceof Boolean) {
                            value = ((Boolean) value) ? 1 : 0;
                        } else if (value instanceof String) {
                            value = ("true".equalsIgnoreCase(value.toString())) ? 1 : 0;
                        }
                    } else if (datatype.equals("int") && value != null) {
                        if (value instanceof Number) {
                            value = ((Number) value).intValue();
                        } else if (value instanceof String) {
                            value = ((Number) Float.parseFloat((String) value)).intValue();
                        }
                    } else if (datatype.equals("long") && value != null) {
                        if (value instanceof Number) {
                            value = ((Number) value).longValue();
                        } else if (value instanceof String) {
                            value = ((Number) Float.parseFloat((String) value)).longValue();
                        }
                    }
                    sqlist.add("update w_dataparam set lastvalue='" + value + "',lastvaluetime='" + mqData.getTs() + "' where ownertable='w_device' and ownerid=" + w_deviceid + " and param='" + key + "'");
                }
            }
            EventValidate.put(w_productid, w_deviceid, mqData);
            baseClass.dbConnect.runSqlUpdate(sqlist);
            InfluxDBConnect.runSqlUpdate(siteid, w_productid, w_deviceid, dataRow, column_type, mqData.getTs());
            deviceMsgStatusInit(w_deviceid);
        }
    }

    //<w_deviceid,<token>>
    private static LinkedHashMap<Long, ArrayList<String>> devicemsgstatus = new LinkedHashMap<>();

    public static void deviceMsgStatusInit(long w_deviceid) {
        devicemsgstatus.put(w_deviceid, new ArrayList<>());
    }

    public static void deviceMsgStatusInit(String serialnumber) throws YosException {
        Rows row = new DBConnect().runSqlQuery("select w_deviceid from w_device where serialnumber='" + serialnumber + "'");
        if (row.isNotEmpty()) {
            devicemsgstatus.put(row.get(0).getLong("w_deviceid"), new ArrayList<>());
        }
    }

    /**
     * 前端检查设备是否有新消息,如存在新消息则返回true同时将记录请求状态
     *
     * @param w_deviceid
     * @param token
     * @return
     */
    public static boolean deviceMSGStatusCheck(long w_deviceid, String token) {
        if (devicemsgstatus.containsKey(w_deviceid)) {
            if (devicemsgstatus.get(w_deviceid).contains(token)) {
                return false;
            } else {
                devicemsgstatus.get(w_deviceid).add(token);
                return true;
            }
        } else {
            return false;
        }
    }

    public void connectionLost(Throwable throwable) {
        //连接断掉会执行到这里
        try {
            logger.error(sys_mqid + "连接已断，尝试重连！！！" + throwable.getMessage());
            //ClientMQTT.connectionMap.get(sys_mqid).reconnect();
            ClientMQTT.MQinit();
        } catch (Exception e) {
            logger.error(sys_mqid + "重连失败，" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        //publish可以执行到这里
        System.out.println("This is deliveryComplete method----->" + iMqttDeliveryToken.isComplete());
//        try {
//            System.out.println("content:" + new String(iMqttDeliveryToken.getMessage().getPayload(), StandardCharsets.UTF_8));
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        try {
//            System.out.println("messageid:" + iMqttDeliveryToken.getMessageId());
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        try {
//            System.out.println("client:" + iMqttDeliveryToken.getClient());
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        try {
//            for (String a : iMqttDeliveryToken.getTopics()) {
//                System.out.println("Topics:" + a);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
    }
}
