package restcontroller.sysmanage.develop.script;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

public class script extends Controller {
    public script(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "脚本查询", apiversion = R.ID10025601.v1.class)
    public String query() throws YosException {
        String ownertable = content.getString("ownertable");
        long ownerid = content.getLong("ownerid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_script");
        querySQL.setWhere("ownertable", ownertable).setWhere("ownerid", ownerid);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "脚本编辑修改", apiversion = R.ID10025701.v1.class)
    public String insertormodify() throws YosException {
        long scriptid = content.getLongValue("scriptid");
        String event = content.getString("event");
        String script = content.getStringValue("script", true);
        if (dbConnect.runSqlQuery("select *from sys_script where scriptid=" + scriptid).isEmpty()) {
            String ownertable = content.getString("ownertable");
            long ownerid = content.getLong("ownerid");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_script");
            insertSQL.setValue("scriptid", createTableID("sys_script"));
            insertSQL.setValue("ownertable", ownertable);
            insertSQL.setValue("ownerid", ownerid);
            insertSQL.setValue("event", event);
            insertSQL.setValue("script", script);
            insertSQL.insert();
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_script");
            updateSQL.setUniqueid(scriptid);
            updateSQL.setValue("event", event);
            updateSQL.setValue("script", script);
            updateSQL.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "脚本删除", apiversion = R.ID10025801.v1.class)
    public String delete() throws YosException {
        long scriptid = content.getLongValue("scriptid");
        dbConnect.runSqlUpdate("delete from sys_script where scriptid=" + scriptid);
        return getSucReturnObject().toString();
    }
}
