package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_datafunction_params implements YosObject {
    @Override
    public String table_comment() {
        return "系统函数注册参数表";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new YosObject.UniqueCol("sys_datafunction_paramsid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new YosObject.BigIntCol("sys_datafunctionid", "sys_datafunctionid"));
        arrayList.add(new YosObject.VarcharCol("param", "param", 50));
        arrayList.add(new YosObject.VarcharCol("paramname", "paramname", 100));
        arrayList.add(new YosObject.VarcharCol("remarks", "remarks", 500));
        arrayList.add(new YosObject.VarcharCol("value", "value", 100));
        arrayList.add(new YosObject.SmallIntCol("issystem", "issystem", 0));
        arrayList.add(new YosObject.IntCol("sequence", "排序"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
