package common.websocket;

import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.api.YOSAPI;
import common.parameter.parameter;
import utility.tools.Encryption;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

//ws://61.164.207.46:8000/yos/webSocket/843f3867a9896b363498932fdee9db7f
@ServerEndpoint("/webSocket/{accesstoken}")
public class WebSocket extends BaseClass {

    private Session session;
    //当前连接对象的账号ID
    private long usersiteid;
    private String accesstoken;
    private Date createdate;
    private String systemclient;

    /**
     * 连接开启
     *
     * @param accesstoken
     * @param session
     * @throws IOException
     */
    @OnOpen
    public void onOpen(@PathParam("accesstoken") String accesstoken, Session session) {
        this.session = session;
        this.accesstoken = accesstoken;
        this.createdate = getDateTime();
        if (parameter.tokenlist.containsKey(accesstoken)) {
            usersiteid = parameter.tokenlist.get(accesstoken);
            if (parameter.usersiteIdList.containsKey(usersiteid)) {
                systemclient = parameter.tokensystemclientlist.get(accesstoken);
            }
        } else {
            JSONObject methodobject = new JSONObject();
            methodobject.put("type", "err");
            methodobject.put("msg", "请登陆");
            sendSystemMessage(methodobject);
            return;
        }
        if (parameter.websocketClients.containsKey(usersiteid)) {
            parameter.websocketClients.get(usersiteid).put(accesstoken, this);
        } else {
            ConcurrentHashMap<String, WebSocket> map = new ConcurrentHashMap<String, WebSocket>();
            map.put(accesstoken, this);
            parameter.websocketClients.put(usersiteid, map);
        }
        parameter.loginDate.put(usersiteid, createdate);
    }

    /**
     * 连接关闭
     *
     * @throws IOException
     */
    @OnClose
    public void onClose() {
        if (session != null && session.isOpen()) {
            try {
                session.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (parameter.websocketClients.containsKey(usersiteid)) {
            parameter.websocketClients.get(usersiteid).remove(accesstoken);
            if (parameter.websocketClients.get(usersiteid).isEmpty()) {
                parameter.websocketClients.remove(usersiteid);
            }
        }
        session = null;
    }

    /**
     * {
     * "dialogid":1,//对话框id
     * "messagetype":"text",//消息类型
     * "description":"",//消息摘要
     * "data":{
     * "websocketcontroller.message":""//文字正文,
     * }
     * },
     * {
     * "dialogid":1,
     * "messagetype":"file",//text,file,data,image,
     * "description":"",
     * "data":{
     * "ownertable":"",
     * "ownerid":"",
     * "serialnumber":"",
     * "postfix":"",
     * "url":"",
     * "url_minimage":"",
     * "url_hls":"",
     * "fdocument":""
     * }
     * },
     * {
     * "dialogid":1,
     * "messagetype":"data",//text,file,data,image
     * "description":"",
     * "data":{
     * "type":"",
     * "ownertable":"",
     * "ownerid":""
     * }
     * }
     *
     * @param messageObject
     * @throws IOException
     */
    /**
     * Socket API接口方法请求入口
     *
     * @param RequestContent
     * @return
     */
    @OnMessage
    public void onMessage(String RequestContent) throws YosException {
        if (RequestContent == null || RequestContent.equals("")) {
            return;
        }
        if ("isalive".equalsIgnoreCase(RequestContent)) {
            session.getAsyncRemote().sendText("alive");
            return;
        }
        /*
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return;
        }
        try {
            long apiid = requestcontent.getLongValue("id");
            int apiversion = requestcontent.getIntValue("version");
            YOSAPI yosapi;
            if (apiid <= 0) {
                yosapi = YOSAPI.getApi("restcontroller." + requestcontent.getStringValue("classname"), requestcontent.getStringValue("method"));
            } else {
                yosapi = YOSAPI.getApi(apiid, apiversion);
            }

            YOSAPI.YosRequest yosRequest = new YOSAPI.YosRequest();
            yosRequest.setRequestKey(Encryption.Encode_MD5(RequestContent));
            yosRequest.setAccesstoken(accesstoken);
            yosRequest.setContent(requestcontent.getJSONObject("content"));
            yosapi.action(yosRequest);
        } catch (YosException e) {
            e.printStackTrace();
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        error.printStackTrace();
    }

    /**
     * 对当前连接发送对话框消息
     *
     * @param message
     */
    public void sendDialogMessage(JSONObject message) {
        synchronized (WebSocket.class) {
            JSONObject object = new JSONObject();
            object.put("msgtype", "imdialog");
            object.put("message", message);
            session.getAsyncRemote().sendText(object.toJSONString());
        }
    }

    /**
     * 对当前连接发送系统消息
     *
     * @param message
     */
    public void sendSystemMessage(JSONObject message) {
        synchronized (WebSocket.class) {
            JSONObject object = new JSONObject();
            object.put("msgtype", "system");
            object.put("message", message);
            session.getAsyncRemote().sendText(object.toJSONString());
        }
    }

    public long getUsersiteid() {
        return usersiteid;
    }

    public String getAccesstoken() {
        return accesstoken;
    }

    public String getSystemclient() {
        return systemclient;
    }
}
