package utility.zentao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import utility.tools.Encryption;
import utility.tools.WebRequest;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.HashMap;

public class zentao extends BaseClass {
    String token = "";
    boolean createcookie = false;

    public zentao() throws YosException {
        login();
    }

    public void login() throws YosException {
        JSONObject object = new JSONObject();
        object.put("accountno", "admin");
        object.put("password", Encryption.Encode_MD5("123456"));
        object.put("systemclient", "yos");

        if (!createcookie) {
            CookieHandler.setDefault(new CookieManager());
            createcookie = true;
        }
        WebRequest webRequest = new WebRequest();
        String result_str = webRequest.doPost(object.toString(), "http://124.70.211.186:7098/zentaoreport/rest/index/loginbyaccount");
        JSONObject result_object = JSONObject.parseObject(result_str);
        if (result_object.getIntValue("code") == 1) {
            token = result_object.getString("token");
        }
    }

    public HashMap<Long, Task> getTask(ArrayList<Long> taskids) throws YosException {
        JSONObject object = new JSONObject();
        object.put("accesstoken", token);
        object.put("id", 20221021132901L);

        JSONObject contentObject = new JSONObject();
        contentObject.put("taskid", taskids);
        contentObject.put("bugid", new JSONArray());
        object.put("content", contentObject);

        WebRequest webRequest = new WebRequest();
        String result_str = webRequest.doPost(object.toString(), "http://124.70.211.186:7098/zentaoreport/rest/index");

        JSONObject result_object = JSONObject.parseObject(result_str);
        HashMap<Long, Task> hashMap = new HashMap<>();
        if (result_object.getIntValue("code") == 1) {
            JSONArray taskArray = result_object.getJSONObject("data").getJSONArray("task");
            for (Object taskObject : taskArray) {
                JSONObject taskJSONObject = (JSONObject) taskObject;
                Task task = new Task();
                task.setId(taskJSONObject.getLong("id"));
                task.setStatus(taskJSONObject.getString("status"));
                task.setTitle(taskJSONObject.getString("title"));
                task.setUrl("http://124.70.211.186:7099/zentao/task-view-" + task.getId() + ".html");
                hashMap.put(taskJSONObject.getLong("id"), task);
            }
        }
        return hashMap;
    }

    public HashMap<Long, Bug> getBug(ArrayList<Long> bugids) throws YosException {
        JSONObject object = new JSONObject();
        object.put("accesstoken", token);
        object.put("id", 20221021132901L);

        JSONObject contentObject = new JSONObject();
        contentObject.put("bugid", bugids);
        contentObject.put("taskid", new JSONArray());
        object.put("content", contentObject);

        WebRequest webRequest = new WebRequest();
        String result_str = webRequest.doPost(object.toString(), "http://124.70.211.186:7098/zentaoreport/rest/index");

        JSONObject result_object = JSONObject.parseObject(result_str);
        HashMap<Long, Bug> hashMap = new HashMap<>();
        if (result_object.getIntValue("code") == 1) {
            JSONArray taskArray = result_object.getJSONObject("data").getJSONArray("bug");
            for (Object taskObject : taskArray) {
                JSONObject bugJSONObject = (JSONObject) taskObject;
                Bug bug = new Bug();
                bug.setId(bugJSONObject.getLong("id"));
                bug.setStatus(bugJSONObject.getString("status"));
                bug.setTitle(bugJSONObject.getString("title"));
                bug.setUrl("http://124.70.211.186:7099/zentao/bug-view-" + bug.getId() + ".html");
                hashMap.put(bugJSONObject.getLong("id"), bug);
            }
        }
        return hashMap;
    }


    public class Task {
        Long id;
        String title;
        String status;
        String url;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public class Bug {
        Long id;
        String title;
        String status;
        String url;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}
