package utility.wechat.miniprogram;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import utility.tools.WebRequest;
import utility.wechat.wechatpay.POJO.CreateOrderResponse;
import utility.wechat.wechatpay.WechatPay;

import java.util.Calendar;

public class WechatMiniProgram extends BaseClass {
    private String appid;
    private String secret;
    private String mch_id;
    private String mch_key;
    private String systemclient;


    /**
     * 构造函数
     *
     * @param appid  前端指定appid
     * @param secret 前端指定secret
     */
    public WechatMiniProgram(String appid, String secret, String mch_id, String mch_key) {
        this.appid = appid;
        this.secret = secret;
        this.mch_id = mch_id;
        this.mch_key = mch_key;
    }

    /**
     * 构造函数
     *
     * @param systemclient 系统注册的微信应用操作端
     */
    public WechatMiniProgram(String systemclient) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select appid,secret,mch_id,mch_key,isvisitor,siteid,visitor_roleid from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.secret = rows.get(0).getString("secret");
            this.mch_id = rows.get(0).getString("mch_id");
            this.mch_key = rows.get(0).getString("mch_key");
        }
        this.systemclient = systemclient;
    }

    public String getMch_key() {
        return mch_key;
    }

    /**
     * 根据code获取微信的openid和unionid
     *
     * @param wechat_code
     * @return
     */
    public WechatUserID getWechatUserID(String wechat_code) throws YosException {
        WechatUserID wechatUserID = new WechatUserID();
        WebRequest request = new WebRequest();
        String result = request.doGet("https://api.weixin.qq.com/sns/jscode2session?appid=" + appid + "&secret=" + secret + "&js_code=" + wechat_code + "&grant_type=authorization_code");
        JSONObject openidobject = JSONObject.parseObject(result);
        wechatUserID.setSucc(openidobject.containsKey("openid"));
        if (openidobject.containsKey("openid")) {
            wechatUserID.setOpenid(openidobject.getString("openid"));
        }
        if (openidobject.containsKey("unionid")) {
            wechatUserID.setUnionid(openidobject.getString("unionid"));
        }
        if (openidobject.containsKey("session_key")) {
            wechatUserID.setSession_key(openidobject.getString("session_key"));
        }
        wechatUserID.setResult(result);
        return wechatUserID;
    }

    /**
     * 获取微信用户手机号信息
     *
     * @param code
     * @return
     * @throws YosException
     */
    public JSONObject getWechatUserPhonenumber(String code) throws YosException {
        WebRequest webRequest = new WebRequest();
        JSONObject object = new JSONObject();
        object.put("code", code);
        String result = webRequest.doPost(object.toString(), "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + getAccessToken());
        JSONObject resultObject = JSON.parseObject(result);
        if (resultObject.containsKey("errcode") && resultObject.getInteger("errcode") == 0 && resultObject.containsKey("phone_info")) {
            JSONObject phone_infoObject = resultObject.getJSONObject("phone_info");
            phone_infoObject.remove("watermark");
            return phone_infoObject;
        }
        return null;
    }

    /**
     * 创建一个微信小程序支付订单
     *
     * @param wechat_code 用户code
     * @param custip      客户端IP地址
     * @param ordertype   支付订单类型
     * @return
     */
    public CreateOrderResponse createPayOrder(String out_trade_no, String trade_type, String wechat_code, String custip, String ordertype, String title) throws YosException {
        WechatPay wechatPay = new WechatPay(systemclient);
        return wechatPay.createPayOrder(out_trade_no, trade_type, getWechatUserID(wechat_code).getOpenid(), custip, ordertype, title);
    }


    //有效期2小时，需定时刷新，重复获取将导致上次获取的失效
    private static String access_token = "";
    private static long access_token_timelimit = 0L;

    private String getAccessToken() throws YosException {
        long nowtime = Calendar.getInstance().getTimeInMillis();
        if (access_token_timelimit < nowtime) {
            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appid + "&secret=" + this.secret;
            String res = new WebRequest().doGet(url);
            JSONObject resobject = JSONObject.parseObject(res);
            if (resobject.containsKey("access_token")) {
                access_token = resobject.getString("access_token");
                access_token_timelimit = nowtime + 1000 * resobject.getIntValue("expires_in");
            }
        }
        return access_token;
    }

    /**
     * 小程序数据分析
     */
    public class Analysis {
        /**
         * 新增或活跃用户的画像分布数据
         */
        public void getUserPortrait() throws YosException {
            WebRequest webRequest = new WebRequest();
            JSONObject object = new JSONObject();
            object.put("begin_date", "20220728");
            object.put("end_date", "20220728");
            String result = webRequest.doPost(object.toString(), "https://api.weixin.qq.com/datacube/getweanalysisappiduserportrait?access_token=" + getAccessToken());
            JSONObject resultObject = JSON.parseObject(result);
            System.out.println(resultObject);
        }

        /**
         * 访问页面。目前只提供按 page_visit_pv 排序的 top200。
         *
         * @throws YosException
         */
        public void getVisitPage() throws YosException {
            WebRequest webRequest = new WebRequest();
            JSONObject object = new JSONObject();
            object.put("begin_date", "20220727");
            object.put("end_date", "20220727");
            String result = webRequest.doPost(object.toString(), "https://api.weixin.qq.com/datacube/getweanalysisappidvisitpage?access_token=" + getAccessToken());
            JSONObject resultObject = JSON.parseObject(result);
            System.out.println(resultObject);
        }
    }
}
