/**
 *
 */
package utility.tools;

import org.apache.commons.lang.StringUtils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

/**
 * 外部接口请求工具类
 */
public class WebRequest {
    private int connectTimeout = 8000;

    public WebRequest() {
    }

    public WebRequest(boolean trustAllCerts) {
        if (trustAllCerts) {
            try {
                trustAllHttpsCertificates();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * post提交
     * @param content 请求内容
     * @param url 请求地址
     * @return
     */
    public String doPost(String content, String url) {
        return doPost(content, url, new HashMap<>());
    }

    /**
     * post提交
     * @param content 请求内容
     * @param url 请求地址
     * @param headers head参数
     * @return
     */
    public String doPost(String content, String url, HashMap<String, String> headers) {
        PrintWriter writer = null;
        BufferedReader reader = null;
        StringBuilder result = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            if (url.startsWith("https")) {
                conn = (HttpsURLConnection) realUrl.openConnection();
            } else {
                conn = (HttpURLConnection) realUrl.openConnection();
            }

            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            for (String key : headers.keySet()) {
                conn.setRequestProperty(key, headers.get(key));
            }
            conn.setConnectTimeout(connectTimeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            writer = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8));
            writer.print(content);
            writer.flush();

            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.err.println("[POST请求]向地址：" + url + " 发送数据：发生错误!");
        } finally {// 使用finally块来关闭输出流、输入流
            if (writer != null) {
                writer.close();
                writer = null;
            }
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                reader = null;
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return result.toString();
    }

    public String doGet(String url) {
        return doGet(url, new HashMap<>());
    }

    public String doGet(String url, HashMap<String, String> headers) {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            if (url.startsWith("https")) {
                trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        System.out.println("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
                        return true;
                    }
                });
                conn = (HttpsURLConnection) realUrl.openConnection();
            } else {
                conn = (HttpURLConnection) realUrl.openConnection();
            }
            // 打开和URL之间的连接
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setConnectTimeout(connectTimeout);
            for (String key : headers.keySet()) {
                conn.setRequestProperty(key, headers.get(key));
            }
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.err.println("[POST请求]向地址：" + url + " 发送数据：发生错误!");
        } finally {// 使用finally块来关闭输出流、输入流
            if (out != null) {
                out.close();
                out = null;
            }
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                in = null;
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return result.toString();
    }

    public void doGet_simple(String url) {
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            if (url.startsWith("https")) {
                trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        System.out.println("Warning: URL Host: " + hostname + " vs. "
                                + session.getPeerHost());
                        return true;
                    }
                });
                conn = (HttpsURLConnection) realUrl.openConnection();
            } else {
                conn = (HttpURLConnection) realUrl.openConnection();
            }
            conn.setConnectTimeout(connectTimeout);
            conn.getResponseCode();
        } catch (Exception e) {
            e.printStackTrace();
            System.err.println("[POST请求]向地址：" + url + " 发送数据：发生错误!");
        } finally {// 使用finally块来关闭输出流、输入流
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void trustAllHttpsCertificates() throws Exception {
        javax.net.ssl.TrustManager[] trustAllCerts = new javax.net.ssl.TrustManager[1];
        javax.net.ssl.TrustManager tm = new miTM();
        trustAllCerts[0] = tm;
        javax.net.ssl.SSLContext sc = javax.net.ssl.SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    static class miTM implements javax.net.ssl.TrustManager, javax.net.ssl.X509TrustManager {
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(java.security.cert.X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(java.security.cert.X509Certificate[] certs) {
            return true;
        }

        public void checkServerTrusted(java.security.cert.X509Certificate[] certs, String authType) {
        }

        public void checkClientTrusted(java.security.cert.X509Certificate[] certs, String authType) {
        }
    }

    public static String getRequestIP(HttpServletRequest request) {
        try {
            String XFor = request.getHeader("X-Forwarded-For");
            if (StringUtils.isNotEmpty(XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
                //多次反向代理后会有多个ip值，第一个ip才是真实ip
                int index = XFor.indexOf(",");
                if (index != -1) {
                    return XFor.substring(0, index);
                } else {
                    return XFor;
                }
            }
            XFor = request.getHeader("X-Real-IP");
            if (StringUtils.isNotEmpty(XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
                return XFor;
            }
            if (StringUtils.isBlank(XFor) || "unknown".equalsIgnoreCase(XFor)) {
                XFor = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isBlank(XFor) || "unknown".equalsIgnoreCase(XFor)) {
                XFor = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isBlank(XFor) || "unknown".equalsIgnoreCase(XFor)) {
                XFor = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isBlank(XFor) || "unknown".equalsIgnoreCase(XFor)) {
                XFor = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isBlank(XFor) || "unknown".equalsIgnoreCase(XFor)) {
                XFor = request.getRemoteAddr();
            }
            return XFor;
        } catch (Exception e) {
            return "127.0.0.1";
        }
    }

    public static String getUserAgent(HttpServletRequest request) {
        try {
            return request.getHeader("User-Agent");
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 设置超时时间
     * @param connectTimeout 超时时间 毫秒
     */
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}



