package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_role implements YosObject {

    @Override
    public String table_comment() {
        return "用户角色表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("roleid", "角色id");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new SmallIntCol("ispublic", "是否公共角色", "公共角色可被其他站点选择使用", 0));
        arrayList.add(new JsonCol("fielddatatypelimit", "字段分类限制"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
