package common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YosString {
    public static String process(Object text) {
        if (text == null) {
            return "";
        }
        return process(text.toString());
    }

    public static String process(String text) {
        text = dateprocess(text);
        return text;
    }

    private static String dateprocess(String text) {
        {
            StringBuffer result = new StringBuffer();
            Pattern pattern = Pattern.compile("\\$\\{\\((.*?)\\)([+-])(\\d+)([yMd])\\}");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                int offset = Integer.parseInt(matcher.group(3));
                if (matcher.group(2).equals("-")) {
                    offset = -offset;
                }
                Calendar calendar = Calendar.getInstance();
                if (matcher.group(4).equals("y")) {
                    calendar.add(Calendar.YEAR, offset);
                } else if (matcher.group(4).equals("M")) {
                    calendar.add(Calendar.MONTH, offset);
                } else if (matcher.group(4).equals("d")) {
                    calendar.add(Calendar.DAY_OF_YEAR, offset);
                }
                matcher.appendReplacement(result, new SimpleDateFormat(matcher.group(1)).format(calendar.getTime()));
            }
            matcher.appendTail(result);
            text = result.toString();
        }
        {
            StringBuffer result = new StringBuffer();
            Pattern pattern = Pattern.compile("\\$\\{\\((.*?)\\)\\}");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                matcher.appendReplacement(result, new SimpleDateFormat(matcher.group(1)).format(Calendar.getInstance().getTime()));
            }
            matcher.appendTail(result);
            text = result.toString();
        }
        {
            StringBuffer result = new StringBuffer();
            Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                matcher.appendReplacement(result, new SimpleDateFormat(matcher.group(1)).format(Calendar.getInstance().getTime()));
            }
            matcher.appendTail(result);
            text = result.toString();
        }
        return text;
    }

    public static void main(String[] args) {
        System.err.println(YosString.process("${MM}"));
        System.err.println(YosString.process("${(yyyy-MM)-0M}"));
        System.err.println(YosString.process("${(yyyy-MM)-1M}"));
        System.err.println(YosString.process("${(yyyy-MM)-2M}"));
        System.err.println(YosString.process("${(yyyy-MM)-3M}"));
    }
}
