package beans.translate;

import common.BaseClass;
import common.YosException;
import common.data.*;
import common.data.db.DBConnect;

import java.util.Calendar;
import java.util.HashMap;

public class Translate {
    public static HashMap<String, String> simpleTranslateMap = new HashMap<>();

    /**
     * 简单的内容匹配翻译
     *
     * @param languagecode   语言
     * @param value_original 翻译前内容
     * @return 翻译后内容
     * @throws YosException
     */
    public static String getSimpleTranslate(String languagecode, String value_original) throws YosException {
        value_original = value_original.trim();
        if (simpleTranslateMap.isEmpty()) {
            //初始化，第一次调用的时候执行
            Rows rows = new DBConnect().runSqlQuery("select distinct concat(languagecode,'_',value_original) as k,value_translate from sys_translate where value_original is not null");
            for (Row row : rows) {
                simpleTranslateMap.put(row.getString("k"), row.getString("value_translate"));
            }
        }

        String key = languagecode + "_" + value_original;

        if (simpleTranslateMap.containsKey(key)) {
            return simpleTranslateMap.get(key);
        } else if (!value_original.equals("") && !languagecode.equalsIgnoreCase("ZH") && !languagecode.equals("")) {
            //如果在缓存里找不到，则单独再进行一次查询
            QuerySQL translateSimpleQuerySQL = SQLFactory.createQuerySQL(new DBConnect(), "sys_translate", "value_translate");
            translateSimpleQuerySQL.setWhere("value_original", value_original);
            translateSimpleQuerySQL.setWhere("languagecode", languagecode);
            Rows translateSimpleRows = translateSimpleQuerySQL.query();
            if (!translateSimpleRows.isEmpty()) {
                String value_translate = translateSimpleRows.get(0).getString("value_translate");
                simpleTranslateMap.put(key, value_translate);
                return value_translate;
            } else {
                simpleTranslateMap.put(key, value_original);
            }
        }//如果找不到翻译值，则直接返回原值
        return value_original;
    }

    public static HashMap<String, String> TranslateMap = new HashMap<>();
    public static int day = 0;


    /**
     * 数据精确匹配翻译
     *
     * @param languagecode 语言
     * @param tablename    表名称
     * @param dataid       数据ID
     * @param columnname   字段名称
     * @return
     * @throws YosException
     */
    public static String getTranslate(String languagecode, String tablename, long dataid, String columnname) throws YosException {
        Rows rows = new DBConnect().runSqlQuery("select " + columnname + " from " + tablename + " where " + new BaseClass().getuniquecolumnname(tablename) + "=" + dataid);
        if (!rows.isEmpty()) {
            return getTranslate(languagecode, tablename, dataid, columnname, rows.get(0).getString(columnname));
        }
        //如果数据不存在，则返回空值
        return "";
    }

    /**
     * @param languagecode   语言
     * @param tablename      表名称
     * @param dataid         数据ID
     * @param columnname     字段名称
     * @param value_original 翻译前内容
     * @return
     * @throws YosException
     */
    public static String getTranslate(String languagecode, String tablename, long dataid, String columnname, String value_original) throws YosException {
        if (day != (day = Calendar.getInstance().get(Calendar.DAY_OF_MONTH))) {
            TranslateMap.clear();
            //初始化
            Rows rows = new DBConnect().runSqlQuery("select distinct concat(languagecode,'_',ownertable,'_',ownerid,'_',columnname) as k,value_translate from sys_translate where languagecode='" + languagecode + "' and ownertable='" + tablename + "' and ownerid>0");
            for (Row row : rows) {
                TranslateMap.put(row.getString("k"), row.getString("value_translate"));
            }
        }

        String key = languagecode + "_" + tablename + "_" + dataid + "_" + columnname;
        if (TranslateMap.containsKey(key)) {
            return TranslateMap.get(key);
        }
        if (!value_original.equals("") && !languagecode.equalsIgnoreCase("ZH") && !languagecode.equals("")) {
            Row translateRow = getTranslateRow(languagecode, tablename, dataid, columnname);
            if (translateRow.isEmpty()) {
                String value_translate = translateRow.getString("value_translate");
                TranslateMap.put(key, value_translate);
                return value_translate;
            } else {
                return getSimpleTranslate(languagecode, value_original);
            }
        } else {
            return value_original;
        }
    }

    public static Row getTranslateRow(String languagecode, String tablename, long dataid, String columnname) throws YosException {
        QuerySQL translateQuerySQL = SQLFactory.createQuerySQL(new DBConnect(), "sys_translate");
        translateQuerySQL.setWhere("languagecode", languagecode);
        translateQuerySQL.setWhere("ownertable", tablename);
        translateQuerySQL.setWhere("ownerid", dataid);
        translateQuerySQL.setWhere("columnname", columnname);
        Rows translateRows = translateQuerySQL.query();
        return translateRows.isEmpty() ? new Row() : translateRows.get(0);
    }

    public static void addTranslate(String languagecode, String tablename, long dataid, String columnname, String value_translate) throws YosException {
        if (new DBConnect().runSqlQuery("select * from sys_translate where ownertable='" + tablename + "' and ownerid='" + dataid + "' and columnname='" + columnname + "' and languagecode='" + languagecode + "'").isEmpty()) {
            InsertSQL translateinsertSQL = SQLFactory.createInsertSQL(new DBConnect(), "sys_translate");
            translateinsertSQL.setValue("ownertable", tablename);
            translateinsertSQL.setValue("ownerid", dataid);
            translateinsertSQL.setValue("columnname", columnname);
            translateinsertSQL.setValue("languagecode", languagecode);
            translateinsertSQL.setValue("value_translate", value_translate);
            translateinsertSQL.insert();
        } else {
            UpdateSQL translateinsertSQL = SQLFactory.createUpdateSQL(new DBConnect(), "sys_translate");
            translateinsertSQL.setValue("value_translate", value_translate);
            translateinsertSQL.setWhere("ownertable", tablename);
            translateinsertSQL.setWhere("ownerid", dataid);
            translateinsertSQL.setWhere("columnname", columnname);
            translateinsertSQL.setWhere("languagecode", languagecode);
            translateinsertSQL.update();
        }
    }


    public static void deleteTranslate(String tablename, long dataid) throws YosException {
        new DBConnect().runSqlUpdate("delete from sys_translate where ownertable='" + tablename + "' and ownerid=" + dataid);
    }
}
