/*
 * Decompiled with CFR 0.152.
 */
package common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.DataPool;

public class Sorting
extends BaseClass {
    JSONArray sortArray;
    long sortedid = 0L;
    boolean sorted_reversed = false;
    boolean isinit = false;
    String classname = "";
    String method = "";
    String siteid = "";
    String datakey = "";
    Rows sortrows;
    Controller controller;

    public Sorting(Controller controller, YOSAPI yosapi) throws YosException {
        this.controller = controller;
        this.sortArray = this.controller.content.containsKey("sort") ? this.controller.content.getJSONArray("sort") : new JSONArray();
        this.classname = yosapi.getClazz().getName();
        this.method = yosapi.getMethod().getName();
        this.siteid = controller.siteid;
        this.datakey = "sort:" + this.classname + "." + this.method;
    }

    private void init() throws YosException {
        if (!this.isinit) {
            Object object = DataPool.get(this.datakey);
            if (object == null) {
                this.sortrows = this.dbConnect.runSqlQuery("select t2.sortid,t2.sortname,t2.sortsql,t2.sorted,t2.siteid from sys_listsortscheme t1 inner join sys_listsortschememx t2 on t1.sys_listsortschemeid=t2.sys_listsortschemeid where t1.methodpath='" + this.classname + "." + this.method + "'");
                DataPool.put(this.datakey, (Object)this.sortrows, 1440);
            } else {
                this.sortrows = (Rows)object;
            }
            this.isinit = true;
        }
    }

    public String getOrderBy() throws YosException {
        this.init();
        RowsMap sortrowsmap = this.sortrows.toRowsMap("sortid");
        for (Object o : this.sortArray) {
            JSONObject sortObject = (JSONObject)o;
            long sortid = sortObject.getLong("sortid");
            boolean sorted = sortObject.getBooleanValue("sorted");
            boolean reversed = sortObject.getBoolean("reversed");
            if (!sorted || sortid <= 0L || !sortrowsmap.containsKey(String.valueOf(sortid))) continue;
            this.sortedid = sortid;
            String sortsql = sortrowsmap.get(String.valueOf(sortid)).get(0).getString("sortsql");
            if (reversed) {
                this.sorted_reversed = true;
                sortsql = this.reversed(sortsql);
            }
            return sortsql;
        }
        RowsMap defaultsortrowsmap = this.sortrows.toRowsMap("sorted");
        if (defaultsortrowsmap.containsKey("1")) {
            this.sortedid = defaultsortrowsmap.get("1").get(0).getLong("sortid");
            return defaultsortrowsmap.get("1").get(0).getString("sortsql");
        }
        return "''";
    }

    public JSONArray getSorts() {
        JSONArray array = new JSONArray();
        for (Row sortrow : this.sortrows) {
            if (!sortrow.getString("siteid").equals("") && !sortrow.getString("siteid").equalsIgnoreCase(this.siteid)) continue;
            JSONObject sortObject = new JSONObject();
            sortObject.put("sortname", (Object)sortrow.getString("sortname"));
            sortObject.put("sortid", (Object)sortrow.getLong("sortid"));
            sortObject.put("sorted", (Object)(sortrow.getLong("sortid") == this.sortedid ? 1 : 0));
            sortObject.put("reversed", (Object)(sortrow.getLong("sortid") == this.sortedid ? (this.sorted_reversed ? 1 : 0) : 0));
            array.add((Object)sortObject);
        }
        if (array.isEmpty()) {
            JSONObject sortObject = new JSONObject();
            sortObject.put("sortname", (Object)"\u9ed8\u8ba4");
            sortObject.put("sortid", (Object)0);
            sortObject.put("sorted", (Object)1);
            sortObject.put("reversed", (Object)0);
            array.add((Object)sortObject);
        }
        return array;
    }

    private String reversed(String orderbysql) {
        orderbysql = orderbysql.replace("asc", "$a$");
        orderbysql = orderbysql.replace("desc", "$d$");
        orderbysql = orderbysql.replace("$a$", "desc");
        orderbysql = orderbysql.replace("$d$", "asc");
        return orderbysql;
    }
}

