/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.InfluxDBConnect;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class InfluxDBQuery {
    private final String siteid;
    private final long w_productid;
    private final long w_deviceid;
    private final String param;
    private String range_str = "";
    private String query_str = "";
    private TimeType fun_timetype;

    public InfluxDBQuery(String siteid, long w_productid, Long w_deviceid, String param) {
        this.siteid = siteid;
        this.w_productid = w_productid;
        this.w_deviceid = w_deviceid;
        this.param = param;
    }

    public InfluxDBQuery setRange(TimeType timetype, int start) {
        this.range_str = "  |> range(start: " + start + timetype.toString() + ")\n";
        return this;
    }

    public InfluxDBQuery setRange(Date start) {
        Calendar calendar_start = Calendar.getInstance();
        calendar_start.setTime(start);
        calendar_start.add(10, -8);
        this.range_str = "  |> range(start: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(calendar_start.getTime()) + ")\n";
        return this;
    }

    public InfluxDBQuery setRange(TimeType timetype, int start, int stop) {
        this.range_str = "  |> range(start: " + start + timetype.name() + ",stop:" + stop + timetype.name() + " )\n";
        return this;
    }

    public InfluxDBQuery setRange(Date start, Date stop) {
        if (stop == null) {
            return this.setRange(start);
        }
        Calendar calendar_start = Calendar.getInstance();
        calendar_start.setTime(start);
        calendar_start.add(10, -8);
        Calendar calendar_end = Calendar.getInstance();
        calendar_end.setTime(stop);
        calendar_end.add(10, -8);
        this.range_str = "  |> range(start: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(calendar_start.getTime()) + ",stop:" + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(calendar_end.getTime()) + " )\n";
        return this;
    }

    public Rows query() throws YosException {
        this.query_str = "from(bucket: \"" + this.siteid + "\")\n" + this.range_str + "  |> filter(fn: (r) => r[\"_measurement\"] == \"" + this.w_productid + "\")\n  |> filter(fn: (r) => r[\"deviceid\"] == \"" + this.w_deviceid + "\")\n  |> filter(fn: (r) => r[\"_field\"] == \"" + this.param + "\")\n";
        return this.getRows();
    }

    public Rows query(FN fn) throws YosException {
        this.query_str = "from(bucket: \"" + this.siteid + "\")\n" + this.range_str + "  |> filter(fn: (r) => r[\"_measurement\"] == \"" + this.w_productid + "\")\n  |> filter(fn: (r) => r[\"deviceid\"] == \"" + this.w_deviceid + "\")\n  |> filter(fn: (r) => r[\"_field\"] == \"" + this.param + "\")\n  |> " + fn.name() + "()";
        return this.getRows();
    }

    public Rows query(FN fn, TimeType timetype, int timespan) throws YosException {
        this.fun_timetype = timetype;
        this.query_str = "from(bucket: \"" + this.siteid + "\")\n" + this.range_str + "  |> filter(fn: (r) => r[\"_measurement\"] == \"" + this.w_productid + "\")\n  |> filter(fn: (r) => r[\"deviceid\"] == \"" + this.w_deviceid + "\")\n  |> filter(fn: (r) => r[\"_field\"] == \"" + this.param + "\")\n  |> window(every: " + timespan + timetype.name() + ")  |> " + fn.name() + "()";
        return this.getRows();
    }

    public Rows query(String flux) throws YosException {
        this.query_str = flux;
        return this.getRows();
    }

    private Rows getRows() throws YosException {
        System.out.println(this.query_str);
        List<FluxTable> list = InfluxDBConnect.runSqlQuery(this.siteid, this.query_str);
        Rows rows = new Rows();
        for (FluxTable fluxTable : list) {
            for (FluxRecord fluxRecord : fluxTable.getRecords()) {
                Instant stop;
                Instant start;
                Row row = new Row();
                row.put("field", fluxRecord.getField());
                row.put("value", fluxRecord.getValue());
                Instant time = fluxRecord.getTime();
                if (time != null) {
                    switch (this.fun_timetype) {
                        case y: {
                            row.put("time", this.getDateTime_Str(time.toEpochMilli(), "yyyy"));
                            break;
                        }
                        case mo: {
                            row.put("time", this.getDateTime_Str(time.toEpochMilli(), "yyyy-MM"));
                            break;
                        }
                        case d: {
                            row.put("time", this.getDateTime_Str(time.toEpochMilli(), "yyyy-MM-dd"));
                            break;
                        }
                        case h: {
                            row.put("time", this.getDateTime_Str(time.toEpochMilli(), "yyyy-MM-dd HH"));
                            break;
                        }
                        case m: {
                            row.put("time", this.getDateTime_Str(time.toEpochMilli(), "yyyy-MM-dd HH:mm"));
                            break;
                        }
                        default: {
                            row.put("time", this.getDateTime_Str(time.toEpochMilli(), "yyyy-MM-dd HH:mm:ss"));
                        }
                    }
                }
                if ((start = fluxRecord.getStart()) != null) {
                    switch (this.fun_timetype) {
                        case y: {
                            row.put("start", this.getDateTime_Str(start.toEpochMilli(), "yyyy"));
                            break;
                        }
                        case mo: {
                            row.put("start", this.getDateTime_Str(start.toEpochMilli(), "yyyy-MM"));
                            break;
                        }
                        case d: {
                            row.put("start", this.getDateTime_Str(start.toEpochMilli(), "yyyy-MM-dd"));
                            break;
                        }
                        case h: {
                            row.put("start", this.getDateTime_Str(start.toEpochMilli(), "yyyy-MM-dd HH"));
                            break;
                        }
                        case m: {
                            row.put("start", this.getDateTime_Str(start.toEpochMilli(), "yyyy-MM-dd HH:mm"));
                            break;
                        }
                        default: {
                            row.put("start", this.getDateTime_Str(start.toEpochMilli(), "yyyy-MM-dd HH:mm:ss"));
                        }
                    }
                }
                if ((stop = fluxRecord.getStop()) != null) {
                    switch (this.fun_timetype) {
                        case y: {
                            row.put("stop", this.getDateTime_Str(stop.toEpochMilli(), "yyyy"));
                            break;
                        }
                        case mo: {
                            row.put("stop", this.getDateTime_Str(stop.toEpochMilli(), "yyyy-MM"));
                            break;
                        }
                        case d: {
                            row.put("stop", this.getDateTime_Str(stop.toEpochMilli(), "yyyy-MM-dd"));
                            break;
                        }
                        case h: {
                            row.put("stop", this.getDateTime_Str(stop.toEpochMilli(), "yyyy-MM-dd HH"));
                            break;
                        }
                        case m: {
                            row.put("stop", this.getDateTime_Str(stop.toEpochMilli(), "yyyy-MM-dd HH:mm"));
                            break;
                        }
                        default: {
                            row.put("stop", this.getDateTime_Str(stop.toEpochMilli(), "yyyy-MM-dd HH:mm:ss"));
                        }
                    }
                }
                rows.add(row);
            }
        }
        return rows;
    }

    public static void main(String[] args) throws YosException {
        Rows rows = new InfluxDBQuery("CS", 22371L, 7L, "DownP").query();
        System.err.println(rows.toJsonArray());
    }

    private String getDateTime_Str(Long imeinmillis, String format_str) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(imeinmillis);
        SimpleDateFormat format = new SimpleDateFormat(format_str);
        return format.format(calendar.getTime());
    }

    public static enum FN {
        sum,
        mean,
        first,
        last,
        max,
        min;

    }

    public static enum TimeType {
        y,
        mo,
        d,
        h,
        m,
        s;

    }
}

