package objectregister;

import common.YosException;
import common.data.InsertSQL;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class t_country implements YosObject {

    @Override
    public String table_comment() {
        return "国家注册表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("countryid", "国家ID");
    }

    @Override
    public void DataInit() throws YosException {
        if (new DBConnect().runSqlQuery("select * from t_country").isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(new DBConnect(), "t_country");
            insertSQL.setValue("country", "中华人民共和国");
            insertSQL.setValue("countrynum", "86");
            insertSQL.setValue("countryid", 1);
            insertSQL.insert();

            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(new DBConnect(), "t_province");
            updateSQL.setValue("countryid", 1);
            updateSQL.update();
        }
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("country", "国家", 50));
        list.add(new VarcharCol("countrynum", "国家编号", 50));
        return list;
    }

}
