/*
 * Decompiled with CFR 0.152.
 */
package common.servlet;

import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.ReturnObject;
import common.YosException;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.parameter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import utility.tools.Encryption;
import utility.tools.WebRequest;

public class Servlet
extends HttpServlet {
    private static final int MEMORY_THRESHOLD = 0x300000;
    private static final int MAX_FILE_SIZE = 0x2800000;
    private static final int MAX_REQUEST_SIZE = 0x3200000;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0x300000);
        factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax(0x2800000L);
        upload.setSizeMax(0x3200000L);
        upload.setHeaderEncoding("ISO8859_1");
        String RequestContent = "";
        List formItems = null;
        try {
            formItems = upload.parseRequest(request);
            if (formItems == null) {
                this.writeErrResponse(response, "\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
                return;
            }
            for (FileItem item : formItems) {
                if (!item.isFormField() || !item.getFieldName().equalsIgnoreCase("requestContent")) continue;
                RequestContent = new String(item.getString().getBytes("ISO8859_1"), "utf-8");
                formItems.remove(item);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject((String)RequestContent);
        }
        catch (Exception e) {
            this.writeErrResponse(response, "\u8bf7\u6c42\u6b63\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4e3aJSONObject\u683c\u5f0f");
            return;
        }
        String result = "";
        try {
            long apiid = requestcontent.getLongValue("id");
            int apiversion = requestcontent.getIntValue("version");
            YOSAPI yosapi = apiid <= 0L ? YOSAPI.getApi("restcontroller." + requestcontent.getString("classname"), requestcontent.getString("method")) : YOSAPI.getApi(apiid, apiversion);
            YOSAPI.YosRequest yosRequest = new YOSAPI.YosRequest();
            yosRequest.setRequestKey(Encryption.Encode_MD5(RequestContent));
            yosRequest.setAccesstoken(requestcontent.getOrDefault("accesstoken", "").toString());
            yosRequest.setContent(requestcontent.getJSONObject("content"));
            yosRequest.setFileItems(formItems);
            result = yosapi.action(yosRequest).toString();
        }
        catch (YosException e) {
            e.printStackTrace();
            this.writeErrResponse(response, e.toString());
        }
        PrintWriter writer = response.getWriter();
        writer.println(result);
        writer.flush();
    }

    private boolean istokeninuserlist(String accesstoken, HttpServletRequest request) throws YosException {
        DBConnect dbConnect = new DBConnect();
        SQLFactory factory = new SQLFactory((Object)this, "\u6301\u4e45\u5316\u8d26\u53f7\u5217\u8868\u67e5\u8be2");
        factory.addParameter("accesstoken", accesstoken);
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());
        if (rows.isEmpty()) {
            return false;
        }
        for (Row row : rows) {
            long usersiteid = row.getLong("usersiteid");
            row.put("logintime", BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime()));
            row.put("ip", WebRequest.getRequestIP(request));
            row.put("useragent", WebRequest.getUserAgent(request));
            parameter.usersiteIdList.put(usersiteid, row);
            parameter.tokenlist.put(accesstoken, usersiteid);
        }
        return true;
    }

    private void saveCallMethodMsg(String key, boolean fromdb, long time) {
        long callmethod_fromcacheTimes;
        long callmethodTimes = parameter.callmethodTimes.containsKey(key) ? parameter.callmethodTimes.get(key) : 0L;
        parameter.callmethodTimes.put(key, callmethodTimes + 1L);
        parameter.lastcallmethodtime.put(key, Calendar.getInstance().getTime());
        long l = callmethod_fromcacheTimes = parameter.callmethod_fromcacheTimes.containsKey(key) ? parameter.callmethod_fromcacheTimes.get(key) : 0L;
        if (!fromdb) {
            parameter.callmethod_fromcacheTimes.put(key, callmethod_fromcacheTimes + 1L);
        } else {
            parameter.callmethodLastTimeLong.put(key, time);
            long totaltimes = callmethodTimes - callmethod_fromcacheTimes;
            long callmethodTimeLong = parameter.callmethodTimeLong.containsKey(key) ? parameter.callmethodTimeLong.get(key) : 0L;
            parameter.callmethodTimeLong.put(key, (callmethodTimeLong * totaltimes + time) / (totaltimes + 1L));
        }
    }

    private void writeErrResponse(HttpServletResponse response, String errmsg) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(new ReturnObject().getErrObject().setErrMsg(errmsg));
        writer.flush();
    }
}

