/*
 * Decompiled with CFR 0.152.
 */
package swing.controls;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.QuerySQL;
import common.data.Rows;
import java.util.ArrayList;
import java.util.HashMap;

public class YTableData {
    private JSONArray dataArray;
    private ArrayList<HashMap<String, String>> fieldnamelist = new ArrayList();
    private ArrayList<Integer> fieldwidth = new ArrayList();
    private QuerySQL querySQL;
    private int pageSize = 10;
    private int pageNumber = 1;
    private Rows rows;
    private long totalRows = 0L;
    private long totalPage = 0L;

    public YTableData(JSONArray dataArray) {
        this.dataArray = dataArray;
    }

    public YTableData(Rows rows) {
        this.rows = rows;
    }

    public YTableData(QuerySQL querySQL) throws YosException {
        this.querySQL = querySQL;
    }

    public void loadData() throws YosException {
        if (this.querySQL != null) {
            this.querySQL.setPage(this.pageSize, this.pageNumber);
            this.rows = this.querySQL.query();
            this.totalRows = this.rows.getTotalRows();
            this.totalPage = this.rows.getTotalPage();
            this.dataArray = this.rows.toJsonArray();
        } else if (this.rows != null) {
            this.dataArray = this.rows.toJsonArray();
            this.totalRows = this.rows.getTotalRows();
            this.totalPage = this.rows.getTotalPage();
        }
    }

    public void setColumn(String fieldname, String title, int width) {
        if (this.fieldnamelist.isEmpty() && !fieldname.equals("selectflag")) {
            this.setColumn("selectflag", "", 1);
        }
        HashMap<String, String> fieldnamemap = new HashMap<String, String>();
        fieldnamemap.put(fieldname, title);
        this.fieldnamelist.add(fieldnamemap);
        this.fieldwidth.add(width);
    }

    public void nextPage() {
        ++this.pageNumber;
    }

    public void lastPage() {
        --this.pageNumber;
        this.pageNumber = this.pageNumber <= 0 ? 1 : this.pageNumber;
    }

    public void setPage(int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber <= 0 ? 1 : pageNumber;
    }

    public void setTotal(long totalPage, long totalRows) {
        this.totalPage = totalPage;
        this.totalRows = totalRows;
    }

    public JSONArray getDataArray() {
        return this.dataArray;
    }

    public Object[][] getData() {
        Object[][] array = new Object[this.dataArray.size()][];
        int i = 0;
        for (Object object : this.dataArray) {
            JSONObject jsonObject = (JSONObject)object;
            jsonObject.put("selectflag", (Object)false);
            Object[] value = new Object[this.fieldnamelist.size()];
            int n = 0;
            for (HashMap<String, String> map : this.fieldnamelist) {
                for (String key : map.keySet()) {
                    value[n++] = jsonObject.get(key);
                }
            }
            array[i++] = value;
        }
        return array;
    }

    public Object[] getColname() {
        Object[] object = new Object[this.fieldnamelist.size()];
        int n = 0;
        for (HashMap<String, String> map : this.fieldnamelist) {
            for (String key : map.values()) {
                object[n++] = key;
            }
        }
        return object;
    }

    public ArrayList<Integer> getFieldwidth() {
        return this.fieldwidth;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getTotalPage() {
        return this.totalPage;
    }
}

