/*
 * Decompiled with CFR 0.152.
 */
package common.data.db.initialization.base;

import common.YosException;
import common.YosLogger;
import common.data.db.initialization.base.YosObjectCol;
import java.util.ArrayList;

public interface YosObject
extends YosLogger {
    public String table_comment();

    public UniqueCol uniquecolumn();

    public void DataInit() throws YosException;

    public ArrayList<YosObjectCol> table_cols();

    public static class DateCol
    extends YosObjectCol {
        public DateCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.date;
            this.numeric_precision = 10;
        }

        public DateCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean savedatalog, String column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.date;
            this.numeric_precision = 10;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.column_default = column_default;
            this.sequence = sequence;
        }
    }

    public static class DateTimeCol
    extends YosObjectCol {
        public DateTimeCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.datetime;
            this.numeric_precision = 19;
        }

        public DateTimeCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean savedatalog, String column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.datetime;
            this.numeric_precision = 19;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.column_default = column_default;
            this.sequence = sequence;
        }
    }

    public static class JsonCol
    extends YosObjectCol {
        public JsonCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.json;
        }

        public JsonCol(String column_name, String column_title, String column_comment) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.json;
        }

        public JsonCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean savedatalog, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.json;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.sequence = sequence;
        }
    }

    public static class LongTextCol
    extends YosObjectCol {
        public LongTextCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.longtext;
        }

        public LongTextCol(String column_name, String column_title, String column_comment) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.longtext;
        }

        public LongTextCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean savedatalog, String column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.longtext;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.column_default = column_default;
            this.sequence = sequence;
        }
    }

    public static class TextCol
    extends YosObjectCol {
        public TextCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.text;
        }

        public TextCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean savedatalog, String column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.text;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.column_default = column_default;
            this.sequence = sequence;
        }
    }

    public static class VarcharCol
    extends YosObjectCol {
        public VarcharCol(String column_name, String column_title, int numeric_precision) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.varchar;
            this.numeric_precision = numeric_precision;
        }

        public VarcharCol(String column_name, String column_title, int numeric_precision, String column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.varchar;
            this.numeric_precision = numeric_precision;
            this.column_default = column_default;
        }

        public VarcharCol(String column_name, String column_title, String column_comment, int numeric_precision) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.varchar;
            this.numeric_precision = numeric_precision;
        }

        public VarcharCol(String column_name, String column_title, String column_comment, int numeric_precision, String column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.varchar;
            this.numeric_precision = numeric_precision;
            this.column_default = column_default;
        }

        public VarcharCol(String column_name, String column_title, String column_comment, int numeric_precision, boolean is_nullable, boolean uniqued, boolean savedatalog, String column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.varchar;
            this.numeric_precision = numeric_precision;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.column_default = column_default;
            this.sequence = sequence;
        }
    }

    public static class DecimalCol
    extends YosObjectCol {
        public DecimalCol(String column_name, String column_title, int numeric_precision, int numeric_scale) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.decimal;
            this.numeric_precision = numeric_precision;
            this.numeric_scale = numeric_scale;
        }

        public DecimalCol(String column_name, String column_title, int numeric_precision, int numeric_scale, long column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.decimal;
            this.numeric_precision = numeric_precision;
            this.numeric_scale = numeric_scale;
            this.column_default = String.valueOf(column_default);
        }

        public DecimalCol(String column_name, String column_title, String column_comment, int numeric_precision, int numeric_scale, boolean is_nullable, boolean savedatalog, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.decimal;
            this.numeric_precision = numeric_precision;
            this.numeric_scale = numeric_scale;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.sequence = sequence;
        }

        public DecimalCol(String column_name, String column_title, String column_comment, int numeric_precision, int numeric_scale, boolean is_nullable, boolean savedatalog, long column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.decimal;
            this.numeric_precision = numeric_precision;
            this.numeric_scale = numeric_scale;
            this.is_nullable = is_nullable;
            this.savedatalog = savedatalog;
            this.column_default = String.valueOf(column_default);
            this.sequence = sequence;
        }
    }

    public static class BigIntCol
    extends YosObjectCol {
        public BigIntCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.bigint;
            this.numeric_precision = 19;
        }

        public BigIntCol(String column_name, String column_title, long column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.bigint;
            this.numeric_precision = 19;
            this.column_default = String.valueOf(column_default);
        }

        public BigIntCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean uniqued, boolean savedatalog, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.bigint;
            this.numeric_precision = 19;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.sequence = sequence;
        }

        public BigIntCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean uniqued, boolean savedatalog, long column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.bigint;
            this.numeric_precision = 19;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.column_default = String.valueOf(column_default);
            this.sequence = sequence;
        }
    }

    public static class IntCol
    extends YosObjectCol {
        public IntCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.integer;
            this.numeric_precision = 10;
        }

        public IntCol(String column_name, String column_title, long column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.integer;
            this.numeric_precision = 10;
            this.column_default = String.valueOf(column_default);
        }

        public IntCol(String column_name, String column_title, String column_comment, long column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.integer;
            this.numeric_precision = 10;
            this.column_default = String.valueOf(column_default);
        }

        public IntCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean uniqued, boolean savedatalog, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.integer;
            this.numeric_precision = 10;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.sequence = sequence;
        }

        public IntCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean uniqued, boolean savedatalog, long column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.integer;
            this.numeric_precision = 10;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.column_default = String.valueOf(column_default);
            this.sequence = sequence;
        }
    }

    public static class SmallIntCol
    extends YosObjectCol {
        public SmallIntCol(String column_name, String column_title) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.smallint;
            this.numeric_precision = 5;
        }

        public SmallIntCol(String column_name, String column_title, int column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_title;
            this.column_type = ColumnType.smallint;
            this.numeric_precision = 5;
            this.column_default = String.valueOf(column_default);
        }

        public SmallIntCol(String column_name, String column_title, String column_comment, int column_default) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.smallint;
            this.numeric_precision = 5;
            this.column_default = String.valueOf(column_default);
        }

        public SmallIntCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean uniqued, boolean savedatalog, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.smallint;
            this.numeric_precision = 5;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.sequence = sequence;
        }

        public SmallIntCol(String column_name, String column_title, String column_comment, boolean is_nullable, boolean uniqued, boolean savedatalog, int column_default, int sequence) {
            this.column_name = column_name;
            this.column_title = column_title;
            this.column_comment = column_comment;
            this.column_type = ColumnType.smallint;
            this.numeric_precision = 5;
            this.is_nullable = is_nullable;
            this.uniqued = uniqued;
            this.savedatalog = savedatalog;
            this.column_default = String.valueOf(column_default);
            this.sequence = sequence;
        }
    }

    public static class UniqueCol
    extends YosObjectCol {
        public UniqueCol(String column_name) {
            this.column_name = column_name;
            this.column_title = "\u6570\u636eID";
            this.column_comment = "\u6570\u636eID";
            this.column_type = ColumnType.bigint;
            this.numeric_precision = 19;
            this.uniqued = true;
            this.is_nullable = false;
            this.column_default = "1";
        }

        public UniqueCol(String column_name, String column_comment) {
            this.column_name = column_name;
            this.column_title = "\u6570\u636eID";
            this.column_comment = column_comment;
            this.column_type = ColumnType.bigint;
            this.numeric_precision = 19;
            this.uniqued = true;
            this.is_nullable = false;
            this.column_default = "1";
        }
    }

    public static enum ChangeStatus {
        A,
        C;

    }

    public static enum ColumnType {
        varchar,
        decimal,
        integer,
        bigint,
        smallint,
        date,
        datetime,
        text,
        longtext,
        json;

    }
}

