/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class CSVFactory
extends BaseClass {
    private String filename;
    public static String filetype = "csv";
    String filepath = "";

    public CSVFactory(String filename) throws YosException {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : p + "/";
        this.filepath = p + this.filename + "." + filetype;
    }

    public void write(Rows datarows) throws YosException {
        this.write(datarows, new HashMap<String, String>());
    }

    public void write(Rows datarows, HashMap<String, String> titlemap) throws YosException {
        try (PrintWriter out = new PrintWriter(new FileWriter(this.filepath));){
            ArrayList<String> fieldlist = datarows.getFieldList();
            ArrayList<String> titlelist = new ArrayList<String>();
            for (String fieldname : fieldlist) {
                String title = titlemap.getOrDefault(fieldname, fieldname);
                title = title.contains(",") ? "\"" + title + "\"" : title;
                titlelist.add(title);
            }
            String headersLine = String.join((CharSequence)",", titlelist);
            out.println(headersLine);
            for (Row row : datarows) {
                ArrayList<String> datarow = new ArrayList<String>();
                for (String fieldname : fieldlist) {
                    String data = row.getString(fieldname);
                    data = data.contains(",") ? "\"" + data + "\"" : data;
                    datarow.add(data);
                }
                out.println(String.join((CharSequence)",", datarow));
            }
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(JSONArray exportFieldsArray, JSONArray dataArrays) throws YosException {
        try (PrintWriter out = new PrintWriter(new FileWriter(this.filepath));){
            ArrayList<String> titlelist = new ArrayList<String>();
            ArrayList<String> fieldlist = new ArrayList<String>();
            for (int i = 0; i < exportFieldsArray.size(); ++i) {
                JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);
                String title = exportFieldObjet.getStringValue("fieldlabel");
                title = title.contains(",") ? "\"" + title + "\"" : title;
                titlelist.add(title);
                fieldlist.add(exportFieldObjet.getStringValue("fieldname"));
            }
            String headersLine = String.join((CharSequence)",", titlelist);
            out.println(headersLine);
            for (Object o : dataArrays) {
                JSONObject dataObject = (JSONObject)o;
                ArrayList<String> datarow = new ArrayList<String>();
                for (String fieldname : fieldlist) {
                    String data = dataObject.getOrDefault(fieldname, "").toString();
                    data = data.contains(",") ? "\"" + data + "\"" : data;
                    datarow.add(data);
                }
                out.println(String.join((CharSequence)",", datarow));
            }
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilename() {
        return this.filename + "." + filetype;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public File getFile() throws YosException {
        return new File(this.filepath);
    }

    public void deletefile() {
        File file = new File(this.filepath);
        file.delete();
    }
}

