/*
 * Decompiled with CFR 0.152.
 */
package swing.controls;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import swing.YUIParameter;

public class YTextField
extends JComponent {
    private JLabel titleLable;
    private JTextField valueTextField;

    public YTextField(String title) {
        this.titleLable = new JLabel(title.equals("") ? "" : title + ":", 4);
        this.titleLable.setPreferredSize(new Dimension(50, 25));
        this.titleLable.setOpaque(false);
        this.valueTextField = new JTextField();
        this.valueTextField.setPreferredSize(new Dimension(150, 25));
        this.setLayout(new FlowLayout());
        this.add(this.titleLable);
        this.add(this.valueTextField);
        if (YUIParameter.isdebug.booleanValue()) {
            this.setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    public YTextField setTitle(String title) {
        this.titleLable.setText(title.equals("") ? "" : title + ":");
        return this;
    }

    public String getTitle() {
        return this.titleLable.getText();
    }

    public YTextField setTitleFontColor(Color color) {
        this.titleLable.setForeground(color);
        return this;
    }

    public YTextField setTitleFont(Font font) {
        this.titleLable.setFont(font);
        return this;
    }

    public YTextField setValue(String value) {
        this.valueTextField.setText(value);
        return this;
    }

    public String getValue() {
        return this.valueTextField.getText();
    }

    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            this.valueTextField.getDocument().addDocumentListener((DocumentListener)obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

