/*
 * Decompiled with CFR 0.152.
 */
package common.mq;

import beans.remind.Remind;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import common.mq.MQDatas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EventValidate
extends BaseClass {
    private static ExecutorService executorService = Executors.newFixedThreadPool(10);
    private static HashMap<Long, Rows> eventRowsMap = new HashMap();
    private static HashMap<Long, Rows> eventRuleRowsMap = new HashMap();
    private static HashMap<Long, ArrayList<Long>> deviceid_eventidmap = new HashMap();

    public static void put(long w_productid, long w_deviceid, MQDatas.MQData mqData) {
        logger.info((Object)("\u9884\u8b66\u6570\u636e\u63a5\u6536\uff1a" + JSON.toJSON((Object)mqData)));
        DBConnect dbConnect = new DBConnect();
        Runnable task = () -> EventValidate.validate(dbConnect, w_productid, w_deviceid, mqData);
        executorService.execute(task);
    }

    private static void validate(DBConnect dbConnect, long w_productid, long w_deviceid, MQDatas.MQData mqData) {
        logger.info((Object)"\u9884\u8b66\u6570\u636e\u6821\u9a8c");
        try {
            if (!eventRowsMap.containsKey(w_deviceid)) {
                logger.info((Object)"\u6570\u636e\u9884\u8b66\u89c4\u5219\u67e5\u8be2");
                QuerySQL eventQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event", "siteid", "w_eventid", "eventname");
                eventQuerySQL.setWhere("deleted=0 and ((ownertable='w_device' and ownerid='" + w_deviceid + "') or (ownertable='w_product' and ownerid='" + w_productid + "'))");
                Rows rows = eventQuerySQL.query();
                eventRowsMap.put(w_deviceid, rows);
                deviceid_eventidmap.put(w_deviceid, rows.toArrayList("w_eventid", new ArrayList()));
            }
            Rows eventRows = eventRowsMap.get(w_deviceid);
            block6: for (Row eventRow : eventRows) {
                logger.info((Object)"\u6570\u636e\u9884\u8b66\u89c4\u5219\u904d\u5386");
                String siteid = eventRow.getString("siteid");
                long w_eventid = eventRow.getLong("w_eventid");
                String eventname = eventRow.getString("eventname");
                if (!eventRuleRowsMap.containsKey(w_eventid)) {
                    logger.info((Object)"\u6570\u636e\u9884\u8b66\u89c4\u5219\u660e\u7ec6\u67e5\u8be2");
                    QuerySQL eventRuleQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event_rule", "w_event_ruleid", "level");
                    ((QuerySQL)eventRuleQuerySQL.setWhere("siteid", siteid)).setWhere("w_eventid", w_eventid);
                    eventRuleQuerySQL.setOrderBy("level");
                    eventRuleRowsMap.put(w_eventid, eventRuleQuerySQL.query());
                }
                Rows eventRuleRows = eventRuleRowsMap.get(w_eventid);
                for (Row eventRuleRow : eventRuleRows) {
                    long w_event_logid;
                    logger.info((Object)"\u6570\u636e\u9884\u8b66\u89c4\u5219\u660e\u7ec6\u904d\u5386");
                    long w_event_ruleid = eventRuleRow.getLong("w_event_ruleid");
                    int level = eventRuleRow.getInteger("level");
                    QuerySQL eventRuleMXQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event_rulemx", "symbol", "value");
                    eventRuleMXQuerySQL.addJoinTable(BaseClass.JOINTYPE.inner, "w_dataparam", "w_dataparam", "siteid=:siteid and w_dataparamid=:w_dataparamid", "param", "paramname", "w_dataparamid", "datatype");
                    ((QuerySQL)eventRuleMXQuerySQL.setWhere("siteid", siteid)).setWhere("w_event_ruleid", w_event_ruleid);
                    Rows eventRuleMXRows = eventRuleMXQuerySQL.query();
                    boolean isevent = true;
                    JSONArray paramvaluesArray = new JSONArray();
                    for (Row eventRuleMXRow : eventRuleMXRows) {
                        Rows row;
                        logger.info((Object)"\u6570\u636e\u9884\u8b66\u89c4\u5219\u660e\u7ec6\u68c0\u67e5");
                        long w_dataparamid = eventRuleMXRow.getLong("w_dataparamid");
                        String param = eventRuleMXRow.getString("param");
                        String paramname = eventRuleMXRow.getString("paramname");
                        String symbol = eventRuleMXRow.getString("symbol");
                        String value = eventRuleMXRow.getString("value");
                        String datatype = eventRuleMXRow.getString("datatype");
                        if (!mqData.containsKey(param)) continue;
                        String validateSQL = datatype.equalsIgnoreCase("double") || datatype.equalsIgnoreCase("int") ? "select " + w_event_ruleid + " as w_event_ruleid where " + mqData.get(param) + " " + symbol + " " + value : "select " + w_event_ruleid + " as w_event_ruleid where '" + mqData.get(param) + "' " + symbol + " '" + value + "'";
                        logger.info((Object)("\u6570\u636e\u9884\u8b66\u89c4\u5219\u660e\u7ec6\u68c0\u67e5\uff1a" + validateSQL));
                        try {
                            row = dbConnect.runSqlQuery(validateSQL);
                        }
                        catch (Exception e) {
                            row = dbConnect.runSqlQuery("select " + w_event_ruleid + " as w_event_ruleid where '" + mqData.get(param) + "' " + symbol + " '" + value + "'");
                        }
                        if (row.isEmpty()) {
                            isevent = false;
                            break;
                        }
                        JSONObject dataObject = new JSONObject();
                        dataObject.put("param", (Object)param);
                        dataObject.put("paramname", (Object)paramname);
                        dataObject.put("paramvalue", mqData.get(param));
                        dataObject.put("eventvalue", (Object)value);
                        dataObject.put("symbol", (Object)symbol);
                        dataObject.put("w_dataparamid", (Object)w_dataparamid);
                        paramvaluesArray.add((Object)dataObject);
                    }
                    if (!isevent || paramvaluesArray.isEmpty()) continue;
                    ArrayList<String> sqlist = new ArrayList<String>();
                    boolean islevelchange = false;
                    Rows w_event_logRows = ((QuerySQL)((QuerySQL)((QuerySQL)((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "w_event_log", new String[0]).setSiteid(siteid)).setWhere("w_deviceid", w_deviceid)).setWhere("w_eventid", w_eventid)).setWhere("status in('\u5f85\u5904\u7406','\u5904\u7406\u4e2d')")).query();
                    if (w_event_logRows.isEmpty()) {
                        InsertSQL w_event_logInsertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_log");
                        w_event_logInsertSQL.setValue("siteid", siteid);
                        w_event_logInsertSQL.setValue("w_deviceid", w_deviceid);
                        w_event_logInsertSQL.setValue("w_eventid", w_eventid);
                        w_event_logInsertSQL.setValue("buildtype", 0);
                        w_event_logInsertSQL.setDateValue("lasteventtime");
                        w_event_logInsertSQL.setValue("lasteventparamvalues", paramvaluesArray);
                        w_event_logInsertSQL.setValue("buildtype", 0);
                        w_event_logInsertSQL.setValue("lasteventlevel", level);
                        w_event_logInsertSQL.setValue("status", "\u5f85\u5904\u7406");
                        sqlist.add(w_event_logInsertSQL.getSQL());
                        w_event_logid = w_event_logInsertSQL.getUniqueid();
                        islevelchange = true;
                    } else {
                        w_event_logid = w_event_logRows.get(0).getLong("w_event_logid");
                        int lasteventlevel = w_event_logRows.get(0).getInteger("lasteventlevel");
                        UpdateSQL w_event_logUpdateSQL = SQLFactory.createUpdateSQL(dbConnect, "w_event_log");
                        ((UpdateSQL)w_event_logUpdateSQL.setSiteid(siteid)).setUniqueid(w_event_logid);
                        w_event_logUpdateSQL.setDateValue("lasteventtime");
                        w_event_logUpdateSQL.setValue("lasteventparamvalues", paramvaluesArray);
                        w_event_logUpdateSQL.setValue("lasteventlevel", level);
                        sqlist.add(w_event_logUpdateSQL.getSQL());
                        if (lasteventlevel != level) {
                            islevelchange = true;
                        }
                    }
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_logmx");
                    insertSQL.setValue("siteid", siteid);
                    insertSQL.setValue("w_event_logid", w_event_logid);
                    insertSQL.setValue("w_event_ruleid", w_event_ruleid);
                    insertSQL.setValue("level", level);
                    insertSQL.setValue("paramvalues", paramvaluesArray);
                    insertSQL.setDateValue("eventtime");
                    sqlist.add(insertSQL.getSQL());
                    dbConnect.runSqlUpdate(sqlist);
                    try {
                        Rows rows = dbConnect.runSqlQuery("select * from w_device where w_deviceid=" + w_deviceid);
                        String serialnumber = rows.get(0).getString("serialnumber");
                        String content = "\u3010Banninger\u3011\u8bbe\u5907\u544a\u8b66\u63d0\u9192\uff1a\u8bbe\u5907\u3010" + serialnumber + "\u3011\u89e6\u53d1\u3010" + level + "\u3011\u7ea7\u544a\u8b66\uff01\u544a\u8b66\u4e3b\u9898\uff1a" + eventname;
                        if (islevelchange) {
                            Remind.autoDataRemind(siteid, "event", "w_event", w_eventid, content);
                            continue block6;
                        }
                        QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "sys_remind_configs", new String[0]).setTableAlias("t1");
                        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_remind_config", "t2", "t1.sys_remind_configid=t2.sys_remind_configid");
                        ((QuerySQL)((QuerySQL)querySQL.setWhere("t2.remindname", "event")).setWhere("t2.ownertable", "w_event")).setWhere("t1.ownerid", w_eventid);
                        ((QuerySQL)querySQL.setWhere("t1.isrepeat", true)).setWhere("t1.siteid", siteid);
                        if (!querySQL.query().isNotEmpty()) continue block6;
                        Remind.autoDataRemind(siteid, "event", "w_event", w_eventid, content);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block6;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void eventRuleInit(long w_deviceid) {
        if (deviceid_eventidmap.containsKey(w_deviceid)) {
            ArrayList<Long> w_eventids = deviceid_eventidmap.get(w_deviceid);
            for (Long w_eventid : w_eventids) {
                eventRuleRowsMap.remove(w_eventid);
            }
            eventRowsMap.remove(w_deviceid);
            deviceid_eventidmap.remove(w_deviceid);
        }
    }
}

