package utility.bankdocking.abc;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class ABC extends BaseClass {

    /**
     * 获取农行流水，
     *
     * @param starttime 开始时间戳，取自最新的一条农行流水的时间戳，如没有流水，则传"0"
     * @return
     */
    public JSONArray query(String siteid, String starttime) throws YosException {
        String bank_abc_used = Parameter.get(siteid, "bank_abc_used");
        if (bank_abc_used.equals("1")) {
            try {
                String filename = getDataFileName(siteid, starttime);
                if (!filename.equals("")) {
                    return getFileData(filename);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JSONArray();
    }

    /**
     * 查询农行流水，获取流水文件名称
     *
     * @param starttime 开始时间戳，取自最新的一条农行流水的时间戳，如没有流水，则传"0"
     * @return
     * @throws Exception
     */
    private String getDataFileName(String siteid, String starttime) throws Exception {
        String StartDate = getDate_Str();
        String EndDate = getDate_Str();
        if (!"0".equals(starttime)) {
            StartDate = starttime.substring(0, 8);
            EndDate = StartDate;
        }
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(Parameter.get(siteid, "bank_abc_host"), Integer.parseInt(Parameter.get(siteid, "bank_abc_port"))), 100000);
        socket.setSoTimeout(100000);
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());

        String result = "<ap>"
                + "  <Version></Version>\r\n"
                + "  <Sign></Sign>\r\n"
                + "  <FileFlag>0</FileFlag>\r\n"//文件标志，0：无文件；1：有文件 默认为0
                + "  <ProductID>ICC</ProductID>\r\n"//固定值
                + "  <ReqSeqNo>201705310001</ReqSeqNo>\r\n"//请求方流水号，可固定
                + "  <AuthNo></AuthNo>\r\n"
                + "  <OpNo>" + Parameter.get(siteid, "bank_abc_opno") + "</OpNo>\r\n"//企业操作员编号
                + "  <CorpNo>" + Parameter.get(siteid, "bank_abc_corpno") + "</CorpNo>\r\n"//客户号
                + "  <ChannelType>" + Parameter.get(siteid, "bank_abc_channeltype") + "</ChannelType>\r\n"//渠道类型
                + "  <TransCode></TransCode>\r\n"
                + "  <CCTransCode>CQRA10</CCTransCode>\r\n"//固定值，表示查询结算账户明细
                + "  <Cmp>\r\n"
                + "    <DbProv>" + Parameter.get(siteid, "bank_abc_dbprov") + "</DbProv>\r\n"// 借方省市代码
                + "    <DbAccNo>" + Parameter.get(siteid, "bank_abc_dbaccno") + "</DbAccNo>\r\n"//借方账号
                + "    <DbCur>" + Parameter.get(siteid, "bank_abc_dbcur") + "</DbCur>\r\n"// 借方货币号
                + "    <StartTime>" + starttime + "</StartTime>\r\n"//末笔时间戳
                + "  </Cmp>\r\n"
                + "  <Corp>\r\n"
                + "    <StartDate>" + StartDate + "</StartDate>\r\n"//起始日期
                + "    <EndDate>" + EndDate + "</EndDate>\r\n"//终止日期
                + "  </Corp>\r\n"
                + "  <Channel>\r\n"
                + "    <LastJrnNo>0</LastJrnNo>\r\n"//固定值
                + "  </Channel>\r\n"
                + "</ap>";
        result = "0" + result.length() + "   " + result;
        byte[] chrCharArray; // 创建一个字符数组chrCharArray
        chrCharArray = result.getBytes();// 将字符串变量转换为字符数组
        out.write(chrCharArray);// 把报文结构发送到服务器端
        InputStream in1 = socket.getInputStream();
        Charset cs = Charset.forName("gbk");
        InputStreamReader isr = new InputStreamReader(in1, cs);
        // 获取文件名
        String[] str = new String[128];
        StringBuffer sb = new StringBuffer();

        try {
            int tempchar;
            int i = 0;
            int flag = 0;
            while ((tempchar = isr.read()) != -1) {
                // 对于windows下，\r\n这两个字符在一起时，表示一个换行。
                // 但如果这两个字符分开显示时，会换两次行。
                // 因此，屏蔽掉\r，或者屏蔽\n。否则，将会多出很多空行。
                if (((char) tempchar) != '\r' && ((char) tempchar) != '\n') {
                    if ((char) tempchar == '|') {
                        flag++;
                        if (flag == 33) {
                            flag = 0;
                            str[i] = sb.toString();
                            sb = new StringBuffer();
                            i++;
                        } else {
                            sb.append((char) tempchar);
                        }
                    } else {
                        sb.append((char) tempchar);
                    }
                }
            }
            isr.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        String ruturn = sb.toString().substring(7, sb.length());
        String filename = ruturn.substring(ruturn.indexOf("<BatchFileName>") + 15, ruturn.indexOf("</BatchFileName>"));
        socket.close();
        return filename;
    }

    /**
     * 读取农行流水文件中的流水信息，并返回json
     *
     * @param filename 流水文件名称
     * @return
     */
    private JSONArray getFileData(String filename) {
        String pathfile = "C:\\Program Files (x86)\\中国农业银行\\中国农业银行银企通平台\\detail\\" + filename;
        File file = new File(pathfile);
        ArrayList<String> list = new ArrayList<>();
        try {
            FileReader reader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String str;
            while ((str = bufferedReader.readLine()) != null) {
                list.add(str);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONArray array = new JSONArray();
        for (String data : list) {
            String value[] = data.split("\\|");
            JSONObject object = new JSONObject();
            object.put("Prov", value[0]);//省市代码
            object.put("AccNo", value[1]);//账号
            object.put("Cur", value[2]);//货币码
            object.put("TrDate", value[3]);//交易日期
            object.put("TimeStab", value[4]);//交易时间
            object.put("TrJrn", value[5]);//日志号
            object.put("TrType", value[6]);//交易类型
            object.put("TrBankNo", value[7]);//交易行号
            object.put("AccName", value[8]);//户名
            object.put("AmtIndex", value[9]);//发生额标志
            object.put("OppProv", value[10]);//对方账号省市代码
            object.put("OppAccNo", value[11]);//对方账号
            object.put("OppCur", value[12]);//对方账号货币码
            object.put("OppName", value[13]);//对方账号户名
            object.put("OppBkName", value[14]);//对方账号开户行
            object.put("CshIndex", value[15]);//现转标志
            object.put("ErrDate", value[16]);//错账日期
            object.put("ErrVchNo", value[17]);//错账传票号
            object.put("Amt", value[18]);//交易金额
            object.put("Bal", value[19]);//账户余额
            object.put("PreAmt", value[20]);//上笔余额
            object.put("TotChg", value[21]);//手续费总额
            object.put("VoucherType", value[22]);//凭证种类
            object.put("VoucherProv", value[23]);//凭证省市代号
            object.put("VoucherBat", value[24]);//凭证批次号
            object.put("VoucherNo", value[25]);//凭证号
            object.put("CustRef", value[26]);//客户参考号
            object.put("TransCode", value[27]);//交易码
            object.put("Teller", value[28]);//柜员号
            object.put("VchNo", value[29]);//传票号
            object.put("Abs", value[30]);//摘要
            object.put("PostScript", value[31]);//附言
            object.put("TrFrom", value[32]);//交易来源
            array.add(object);
        }
        return array;
    }
}
