package restcontroller.sysmanage.develop.optiontype.system;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.QuerySQL;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

import common.YosException;
import restcontroller.R;

@API(title = "管理端-开发-选项分类-系统选项")
public class systemoptiontype extends Controller {
    public systemoptiontype(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 系统选项分类查询
     *
     * @return
     */
    @API(title = "系统选项分类查询", apiversion = R.ID10014101.v1.class)
    @CACHEING
    public String query_optiontypeList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("typename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or remarks like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_optiontype");
        querySQL.setWhere(where.toString());
        querySQL.setPage(pageSize, pageNumber);
        Rows rows = querySQL.query();
//        SQLFactory typelistSQL = new SQLFactory(this, "系统选项分类查询", pageSize, pageNumber, pageSorting);
//        typelistSQL.addParameter_SQL("where", where);
//        Rows rows = dbConnect.runSqlQuery(typelistSQL.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 系统选项分类新增、修改
     *
     * @return
     */
    @API(title = "系统选项分类新增、修改", apiversion = R.ID10014201.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = systemoptiontype.class, method = {"query_optiontypeList"})})
    public String insertormodify_optiontype() throws YosException {
        String typename = content.getString("typename");
        typename = typename.toLowerCase();
        if (typename.equals("") || !String.valueOf(typename.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("分类名称必须以英文字母开头").toString();
        }
        if (!typename.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("分类名称必须为英文字母或英文数字组合").toString();
        }
        String remarks = content.getString("remarks");
        boolean issql = content.getBooleanValue("issql");

        SQLFactory sqlFactory = null;
        if (content.getBooleanValue("isasync")) {
            long optiontypeid = 0;
            Rows sys_optiontypeRows = dbConnect.runSqlQuery("select *from sys_optiontype where typename='" + typename + "'");
            if (sys_optiontypeRows.isEmpty()) {
                optiontypeid = createTableID("sys_optiontype");
                sqlFactory = new SQLFactory(this, "系统选项分类新增");
                sqlFactory.addParameter("optiontypeid", optiontypeid);
                sqlFactory.addParameter("typename", typename);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issql", issql);
            } else {
                optiontypeid = sys_optiontypeRows.get(0).getLong("optiontypeid");
                sqlFactory = new SQLFactory(this, "系统选项分类修改");
                sqlFactory.addParameter("optiontypeid", optiontypeid);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issql", issql);
            }
        } else {
            long optiontypeid = content.getLong("optiontypeid");//分类ID，必填
            if (optiontypeid <= 0 && !dbConnect.runSqlQuery("select optiontypeid from sys_optiontype where typename='" + typename + "'").isEmpty()) {
                return getErrReturnObject().setErrMsg("分类名称" + typename + "已存在").toString();
            }
            if (optiontypeid <= 0 || dbConnect.runSqlQuery("select optiontypeid from sys_optiontype where optiontypeid=" + optiontypeid).isEmpty()) {
                optiontypeid = createTableID("sys_optiontype");
                sqlFactory = new SQLFactory(this, "系统选项分类新增");
                sqlFactory.addParameter("optiontypeid", optiontypeid);
                sqlFactory.addParameter("typename", typename);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issql", issql);
            } else {
                sqlFactory = new SQLFactory(this, "系统选项分类修改");
                sqlFactory.addParameter("optiontypeid", optiontypeid);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issql", issql);
            }
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    /**
     * 分类删除
     *
     * @return
     */
    @API(title = "系统选项分类删除", apiversion = R.ID10014301.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = systemoptiontype.class, method = {"query_optiontypeList"})})
    public String delete_optiontype() throws YosException {
        long optiontypeid = content.getLong("optiontypeid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_optiontype where optiontypeid=" + optiontypeid);
        list.add("delete from sys_optiontypemx where optiontypeid=" + optiontypeid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    /**
     * 分类明细查询
     *
     * @return
     */
    @API(title = "系统选项分类明细查询", apiversion = R.ID10014401.v1.class)
    @CACHEING
    public String query_optiontypemxList() throws YosException {
        long optiontypeid = content.getLong("optiontypeid");
        SQLFactory sqlFactory = new SQLFactory(this, "系统选项分类明细查询");
        sqlFactory.addParameter("optiontypeid", optiontypeid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }


    /**
     * 系统选项分类明细新增、修改
     *
     * @return
     */
    @API(title = "系统选项分类明细新增、修改", apiversion = R.ID10014501.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = systemoptiontype.class, method = {"query_optiontypemxList"})})
    public String insertormodify_optiontypemx() throws YosException {
        long optiontypeid = content.getLong("optiontypeid");//分类ID，必填
        long optiontypemxid = content.getLong("optiontypemxid");//分类明细ID。新增传0
        boolean isused = content.getBooleanValue("isused");
        String remarks = content.getString("remarks");
        String value;
        if (dbConnect.runSqlQuery("select *from sys_optiontype where issql=1 and optiontypeid=" + optiontypeid).isNotEmpty()) {
            value = content.getString("value", true);
        } else {
            value = content.getString("value");
        }
        // int sequence = content.getInteger("sequence");
        SQLFactory sqlFactory = null;
        if (optiontypemxid <= 0 || dbConnect.runSqlQuery("select optiontypemxid from sys_optiontypemx where siteid='" + siteid + "' and optiontypemxid=" + optiontypemxid).isEmpty()) {
            optiontypemxid = createTableID("sys_optiontypemx");
            sqlFactory = new SQLFactory(this, "系统选项分类明细新增");
            sqlFactory.addParameter("optiontypeid", optiontypeid);
            sqlFactory.addParameter("optiontypemxid", optiontypemxid);
            sqlFactory.addParameter("isused", isused);
            sqlFactory.addParameter("value", value);
            // sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("remarks", remarks);
        } else {
            sqlFactory = new SQLFactory(this, "系统选项分类明细修改");
            sqlFactory.addParameter("optiontypeid", optiontypeid);
            sqlFactory.addParameter("optiontypemxid", optiontypemxid);
            sqlFactory.addParameter("isused", isused);
            sqlFactory.addParameter("value", value);
            //  sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("remarks", remarks);
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    /**
     * 分类明细删除
     *
     * @return
     */
    @API(title = "系统选项分类明细删除", apiversion = R.ID10014601.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = systemoptiontype.class, method = {"query_optiontypemxList"})})
    public String delete_optiontypemx() throws YosException {
        long optiontypemxid = content.getLong("optiontypemxid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_optiontypemx where issystem=1 and optiontypemxid=" + optiontypemxid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }
}
