package common.restful;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.ReturnObject_Err;
import common.ReturnObject_Warn;
import common.YosException;
import common.api.YOSAPI;
import common.api.YOSOPENAPI;
import common.data.*;
import common.data.db.DBConnect;
import common.parameter.parameter;
import common.parameter.properties;
import org.dom4j.dom.DOMElement;
import restcontroller.ClientUserInfo;
import restcontroller.sysmanage.develop.hotupdate.database_contrast;
import utility.sms.Sms;
import utility.syslog;
import utility.sysmsg;
import utility.tools.Encryption;
import utility.tools.WebRequest;
import utility.wechat.miniprogram.WechatMiniProgram;
import utility.wechat.miniprogram.WechatUserID;
import utility.wechat.wechatpay.POJO.QueryOrderRequest;
import utility.wechat.wechatpay.POJO.WechatOrder;
import utility.wechat.wechatpay.WechatPay;
import utility.wechat.wechatpay.nativepay.NativePay;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;

@Path("index")
public class Index extends Basic {

    /**
     * rest API接口方法请求入口
     *
     * @param request
     * @param RequestContent
     * @return
     */
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public Object method(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        /*
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        String requestkey = Encryption.Encode_MD5(RequestContent);
        if (!isrequestallreadypost(requestkey)) {
            try {
                long apiid = requestcontent.getLongValue("id");
                int apiversion = requestcontent.getIntValue("version");
                YOSAPI yosapi;
                if (apiid <= 0) {
                    yosapi = YOSAPI.getApi("restcontroller." + requestcontent.getString("classname"), requestcontent.getString("method"));
                } else {
                    yosapi = YOSAPI.getApi(apiid, apiversion);
                }
                String accesstoken = requestcontent.getOrDefault("accesstoken", "").toString();
                YOSAPI.YosRequest yosRequest = new YOSAPI.YosRequest();
                yosRequest.setRequestKey(requestkey);
                yosRequest.setAccesstoken(accesstoken);
                yosRequest.setRequestsessionid(request.getRequestedSessionId());
                yosRequest.setHttpServletRequest(request);
                yosRequest.setIsdebug(requestcontent.getBooleanValue("debug"));
                yosRequest.setContent(requestcontent.getJSONObject("content"));
                yosRequest.setSystemappId(requestcontent.getLongValue("systemappid"));
                return yosapi.action(yosRequest);
            } catch (YosException e) {
                e.printStackTrace();
                return new ReturnObject_Err().setErrMsg(e.toString());
            } finally {
                requestkeyList.remove(requestkey);
            }
        } else {
            return new ReturnObject_Warn().setWarnMsg("请求正在处理...");
        }
    }

    /**
     * rest API接口方法请求入口
     *
     * @param request
     * @param RequestContent
     * @return
     */
    @Path("open")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public Object method_open(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        /*
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        String requestkey = Encryption.Encode_MD5(RequestContent);
        if (!isrequestallreadypost(requestkey)) {
            try {
                long apiid = requestcontent.getLongValue("id");
                int apiversion = requestcontent.getIntValue("version");
                YOSAPI yosapi;
                if (apiid <= 0) {
                    yosapi = YOSAPI.getApi("restcontroller." + requestcontent.getString("classname"), requestcontent.getString("method"));
                } else {
                    yosapi = YOSAPI.getApi(apiid, apiversion);
                }
                String accesstoken = requestcontent.getOrDefault("accesstoken", "").toString();
                YOSOPENAPI.YosRequest yosRequest = new YOSOPENAPI.YosRequest();
                yosRequest.setRequestKey(requestkey);
                yosRequest.setAccesstoken(accesstoken);
                yosRequest.setRequestsessionid(request.getRequestedSessionId());
                yosRequest.setHttpServletRequest(request);
                yosRequest.setIsdebug(requestcontent.getBooleanValue("debug"));
                yosRequest.setContent(requestcontent.getJSONObject("content"));
                yosRequest.setSystemappId(requestcontent.getLongValue("systemappid"));
                return yosapi.action(yosRequest);
            } catch (YosException e) {
                e.printStackTrace();
                return new ReturnObject_Err().setErrMsg(e.toString());
            } finally {
                requestkeyList.remove(requestkey);
            }
        } else {
            return new ReturnObject_Warn().setWarnMsg("请求正在处理...");
        }
    }

    @Path("getforward")
    @GET
    @Produces(MediaType.WILDCARD)
    public void getforward(@Context HttpServletResponse response, @QueryParam("url") String url) {
        try {
            response.sendRedirect(url);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取短信登陆验证码
     *
     * @param RequestContent
     * @return
     */
    @Path("getpassword")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSON getPassWord(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        if (!properties.getYosProperties().getProperty("system.loginmode.phonenumber").equalsIgnoreCase("true")) {
            return new ReturnObject_Err().setErrMsg("当前系统未开启短信验证码登陆方式");
        }
        DBConnect dbConnect = new DBConnect();
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        /**
         * 验证请求正文中是否包含必填的键值
         */
        String[] mustkeys = {"phonenumber"};
        for (String mustkey : mustkeys) {
            if (!requestcontent.containsKey(mustkey)) {
                return new ReturnObject_Err().setErrMsg("json缺少KEY" + mustkey);
            }
        }
        String phonenumber = requestcontent.getString("phonenumber");
        if (dbConnect.runSqlQuery("select * from sys_users where phonenumber='" + phonenumber + "'").isEmpty()) {
            JSONObject object = new JSONObject();
            object.put("code", 0);
            object.put("msg", "当前手机号未注册！");
            return object;
        }
        if (dbConnect.runSqlQuery("select * from sys_users inner join sys_usersite on sys_users.userid=sys_usersite.userid where phonenumber='" + phonenumber + "'").isEmpty()) {
            JSONObject object = new JSONObject();
            object.put("code", 0);
            object.put("msg", "当前账号未授权站点！");
            return object;
        }
        String systemclient = requestcontent.getString("systemclient");//登陆操作端
        if ("web_manage".equalsIgnoreCase(systemclient)) {
            if (dbConnect.runSqlQuery("select * from sys_users where phonenumber='" + phonenumber + "'").isEmpty()) {
                JSONObject object = new JSONObject();
                object.put("code", 0);
                object.put("msg", "当前手机号不是管理员账号");
                return object;
            }
        }

        String password = createPassWord();
        parameter.phonenumber_password.put(phonenumber, password);
        parameter.password_systemclient.put(password, systemclient);
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MINUTE, 5);
        parameter.phonenumber_date.put(phonenumber, calendar.getTime());

        if (!Parameter.get("system_sms_switch").equalsIgnoreCase("true") || Arrays.asList(Parameter.get("system_invalidate_phonenumber").split(",")).contains(phonenumber)) {
            JSONObject object = new JSONObject();
            object.put("code", 1);
            object.put("msg", "手机验证码为：" + password);
            return object;
        }
        JSONObject object = new JSONObject();
        Sms sms = new Sms();
        sms.sendout(phonenumber, Parameter.get("chuanglan_sms_model_password"), new String[]{password});
        object.put("code", 1);
        object.put("msg", "手机验证码已发送，请注意查收！");
        return object;
    }


    /**
     * 账号密码登陆
     *
     * @param RequestContent
     * @return
     */
    @Path("loginbyaccount")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSON loginbyaccount(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        if (!properties.getYosProperties().getProperty("system.loginmode.account").equalsIgnoreCase("true")) {
            return new ReturnObject_Err().setErrMsg("当前系统未开启账号密码登陆方式");
        }
        DBConnect connect = new DBConnect();
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        /**
         * 验证请求正文中是否包含必填的键值
         */
        String[] mustkeys = {"accountno", "password", "systemclient"};
        for (String mustkey : mustkeys) {
            if (!requestcontent.containsKey(mustkey)) {
                return new ReturnObject_Err().setErrMsg("json缺少KEY" + mustkey);
            }
        }
        String accountno = requestcontent.getString("accountno");
        String userpassword = requestcontent.getString("password");//md5加密

        String systemclient = requestcontent.getString("systemclient");//登陆操作端
        if (connect.runSqlQuery("select * from  sys_systemclient where systemclient='" + systemclient + "'").isEmpty()) {
            return new ReturnObject_Err().setErrMsg("不存在的操作端" + systemclient);
        }

        Rows usersrows = connect.runSqlQuery("select password,failedlogins from sys_users t1 where t1.accountno='" + accountno + "'");
        if (!usersrows.isEmpty() && usersrows.get(0).getInteger("failedlogins") >= 10) {
            connect.runSqlUpdate("update sys_users set status='INACTIVE' where accountno='" + accountno + "'");
            JSONObject object = new JSONObject();
            object.put("code", 0);
            object.put("msg", "密码错误次数过多，账号已被锁定");
            return object;
        }
        /**
         * 登陆密码校验
         */
        boolean issucess = !usersrows.isEmpty() && userpassword.equals(usersrows.get(0).getString("password"));
        if (issucess) {
            SQLFactory usersql = new SQLFactory(this, systemclient.equalsIgnoreCase("sysmanage") ? "开发端账号列表查询" : "账号列表查询");
            usersql.addParameter("accountno", accountno);
            usersql.addParameter("systemclient", systemclient);
            Rows userrows = connect.runSqlQuery(usersql.getSQL());
            if (userrows.isEmpty()) {
                JSONObject object = new JSONObject();
                object.put("code", 0);
                object.put("msg", "没有为当前账号配分配有效的角色");
                return object;
            }
            ArrayList<String> tokensaveList = new ArrayList<>();
            long userid = 0;
            for (Row userrow : userrows) {
                userid = userrow.getLong("userid");//用户id
                long usersiteid = userrow.getLong("usersiteid");//用户角色id
                String usertoken = Encryption.Encode_MD5(accountno + userpassword + userid + usersiteid + Calendar.getInstance().getTimeInMillis());

                userrow.put("token", usertoken);
                userrow.put("logintime", BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime()));
                userrow.put("systemclient", systemclient);
                userrow.put("ip", WebRequest.getRequestIP(request));
                userrow.put("useragent", WebRequest.getUserAgent(request));
                userrow.putAll(ClientUserInfo.setLoginReturn(usersiteid, userrow));
                parameter.usersiteIdList.put(usersiteid, userrow);
                parameter.tokenlist.put(usertoken, usersiteid);
                HttpSession session = request.getSession(true);
                parameter.tokenSessionidlist.put(usertoken, session.getId());
                parameter.tokensystemclientlist.put(usertoken, systemclient);
                tokensaveList.add("update sys_usersite set sessionid='" + session.getId() + "', accesstoken='" + usertoken + "',systemclient='" + systemclient + "' where userid=" + userid + " and usersiteid=" + usersiteid);
            }
            connect.runSqlUpdate(tokensaveList);
            connect.runSqlUpdate("update sys_users set failedlogins=0 where accountno='" + accountno + "'");
            JSONObject object = new JSONObject();
            object.put("code", 1);
            object.put("msg", "成功");
            object.put("account_list", userrows.toJsonArray());
            String remind = remindchangepassword(userid, userpassword, userrows.toArray("siteid"));
            object.put("remindchangepassword", remind.equalsIgnoreCase("") ? 0 : 1);
            object.put("remindchangepassword_str", remind);
            return object;
        } else {
            connect.runSqlUpdate("update sys_users set failedlogins=failedlogins+1 where accountno='" + accountno + "'");
            JSONObject object = new JSONObject();
            object.put("code", 0);
            object.put("msg", "用户名或密码错误");
            return object;
        }
    }

    /**
     * 微信授权登陆
     *
     * @param RequestContent
     * @return
     */
    @Path("loginbywechat")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSON loginbywechat(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        if (!properties.getYosProperties().getProperty("system.loginmode.wechat").equalsIgnoreCase("true")) {
            return new ReturnObject_Err().setErrMsg("当前系统未开启微信登陆方式");
        }
        DBConnect connect = new DBConnect();
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        /**
         * 验证请求正文中是否包含必填的键值
         */
        String[] mustkeys = {"wechat_code", "systemclient"};
        for (String mustkey : mustkeys) {
            if (!requestcontent.containsKey(mustkey)) {
                return new ReturnObject_Err().setErrMsg("json缺少KEY" + mustkey);
            }
        }
        String wechat_code = requestcontent.getString("wechat_code");

        String systemclient = requestcontent.getString("systemclient");//登陆操作端
        if (connect.runSqlQuery("select * from  sys_systemclient where systemclient='" + systemclient + "'").isEmpty()) {
            return new ReturnObject_Err().setErrMsg("不存在的操作端" + systemclient);
        }
        if (connect.runSqlQuery("select * from  sys_wechatapp where systemclient='" + systemclient + "'").isEmpty()) {
            return new ReturnObject_Err().setErrMsg("没有为该操作端进行微信应用注册" + systemclient);
        }
        WechatMiniProgram wechatMiniProgram = new WechatMiniProgram(systemclient);
        WechatUserID wechatUserID = wechatMiniProgram.getWechatUserID(wechat_code);
        String openid = wechatUserID.getOpenid();
        String unionid = wechatUserID.getUnionid();
        boolean issucess = false;
        if (unionid != null && !unionid.equals("")) {
            Rows rows = connect.runSqlQuery("select *from sys_wechatapp_unionids where unionid='" + unionid + "'");
            if (rows.isNotEmpty()) {
                issucess = true;
            }
        }
        if (!issucess && openid != null && !openid.equals("")) {
            Rows rows = connect.runSqlQuery("select *from sys_wechatapp_openids where systemclient='" + systemclient + "'and openid='" + openid + "'");
            if (rows.isNotEmpty()) {
                issucess = true;
            }
        }
        if (issucess) {
            SQLFactory usersql = new SQLFactory(this, "微信账号列表查询");
            usersql.addParameter("openid", openid);
            usersql.addParameter("unionid", unionid);
            usersql.addParameter("systemclient", systemclient);
            Rows userrows = connect.runSqlQuery(usersql.getSQL());
            if (userrows.isEmpty()) {
                JSONObject object = new JSONObject();
                object.put("code", 0);
                object.put("msg", "没有为当前微信账号配分配有效的角色");
                return object;
            }
            ArrayList<String> tokensaveList = new ArrayList<String>();
            for (Row userrow : userrows) {
                long userid = userrow.getLong("userid");//用户id
                long usersiteid = userrow.getLong("usersiteid");//用户角色id
                String usertoken = Encryption.Encode_MD5(openid + systemclient + userid + usersiteid + Calendar.getInstance().getTimeInMillis());

                userrow.put("token", usertoken);
                userrow.put("logintime",BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime()));
                userrow.put("systemclient", systemclient);
                userrow.put("ip", WebRequest.getRequestIP(request));
                userrow.put("useragent", WebRequest.getUserAgent(request));
                userrow.putAll(ClientUserInfo.setLoginReturn(usersiteid, userrow));
                parameter.usersiteIdList.put(usersiteid, userrow);
                parameter.tokenlist.put(usertoken, usersiteid);
                HttpSession session = request.getSession(true);
                parameter.tokenSessionidlist.put(usertoken, session.getId());
                parameter.tokensystemclientlist.put(usertoken, systemclient);
                tokensaveList.add("update sys_usersite set  sessionid='" + session.getId() + "', accesstoken='" + usertoken + "',systemclient='" + systemclient + "' where userid=" + userid + " and usersiteid=" + usersiteid);
            }
            /**
             * 账号登录态持久化
             */
            connect.runSqlUpdate(tokensaveList);
            JSONObject object = new JSONObject();
            object.put("code", 1);
            object.put("msg", "成功");
            object.put("account_list", userrows.toJsonArray());
            return object;
        } else {
            JSONObject object = new JSONObject();
            object.put("code", 0);
            object.put("msg", "未查询到绑定当前微信的账号信息");
            return object;
        }
    }

    /**
     * 短信验证码登陆
     *
     * @param RequestContent
     * @return
     */
    @Path("login")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSON login(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        if (!properties.getYosProperties().getProperty("system.loginmode.phonenumber").equalsIgnoreCase("true")) {
            return new ReturnObject_Err().setErrMsg("当前系统未开启短信验证码登陆方式");
        }
        DBConnect connect = new DBConnect();
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        /**
         * 验证请求正文中是否包含必填的键值
         */
        String[] mustkeys = {"phonenumber", "password", "systemclient"};
        for (String mustkey : mustkeys) {
            if (!requestcontent.containsKey(mustkey)) {
                return new ReturnObject_Err().setErrMsg("json缺少KEY" + mustkey);
            }
        }
        String phonenumber = requestcontent.getString("phonenumber");
        String userpassword = requestcontent.getString("password");

        String systemclient = requestcontent.getString("systemclient");//登陆操作端
        if (connect.runSqlQuery("select * from  sys_systemclient where systemclient='" + systemclient + "'").isEmpty()) {
            return new ReturnObject_Err().setErrMsg("不存在的操作端" + systemclient);
        }

        String password_systemclient = "";
        int resultcode;

        if (!parameter.phonenumber_password.containsKey(phonenumber)) {
            resultcode = 1;//没有获取验证码
        } else if (parameter.phonenumber_date.get(phonenumber).before(Calendar.getInstance().getTime())) {
            resultcode = 2;//验证码已失效
        } else {
            //系统验证码
            String syspassword = parameter.phonenumber_password.get(phonenumber);
            if (userpassword.equals(Encryption.Encode_MD5(syspassword))) {
                resultcode = 0;//验证码正确
                password_systemclient = parameter.password_systemclient.get(syspassword);
                if (!systemclient.equals(password_systemclient)) {
                    resultcode = 4;
                }
            } else {
                resultcode = 3;//验证码错误
            }
        }
        if (resultcode == 0) {
            //web管理端登陆
            SQLFactory usersql = new SQLFactory(this, systemclient.equalsIgnoreCase("sysmanage") ? "开发端手机账号列表查询" :"手机账号列表查询");
            usersql.addParameter("phonenumber", phonenumber);
            usersql.addParameter("systemclient", systemclient);
            Rows userrows = connect.runSqlQuery(usersql.getSQL());
            ArrayList<String> tokensaveList = new ArrayList<String>();
            Long tokenendtimemillis = Calendar.getInstance().getTimeInMillis() + 1000 * 3600 * 2;
            for (Row userrow : userrows) {
                long userid = userrow.getLong("userid");
                long usersiteid = userrow.getLong("usersiteid");//用户角色id
                String usertoken = Encryption.Encode_MD5(phonenumber + userpassword + userid + usersiteid + Calendar.getInstance().getTimeInMillis());
                userrow.put("token", usertoken);
                userrow.put("logintime",BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime()));
                userrow.put("systemclient", systemclient);
                userrow.put("ip", WebRequest.getRequestIP(request));
                userrow.put("useragent", WebRequest.getUserAgent(request));
                userrow.putAll(ClientUserInfo.setLoginReturn(usersiteid, userrow));
                parameter.usersiteIdList.put(usersiteid, userrow);
                parameter.tokenlist.put(usertoken, usersiteid);
                parameter.tokenendtimemillis.put(usertoken, tokenendtimemillis);
                HttpSession session = request.getSession(true);
                parameter.tokenSessionidlist.put(usertoken, session.getId());
                parameter.tokensystemclientlist.put(usertoken, systemclient);
                tokensaveList.add("update sys_usersite set sessionid='" + session.getId() + "', accesstoken='" + usertoken + "',systemclient='" + systemclient + "' where userid=" + userid + " and usersiteid=" + usersiteid);
            }
            if (!tokensaveList.isEmpty()) {
                /*
                 * 账号登录态持久化
                 */
                connect.runSqlUpdate(tokensaveList);
            }
            JSONObject object = new JSONObject();
            object.put("code", 1);
            object.put("msg", "成功");
            object.put("account_list", userrows.toJsonArray());

            //登录成功，将验证码失效掉；
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.MINUTE, -5);
            parameter.phonenumber_date.put(phonenumber, calendar.getTime());
            return object;
        } else {
            String msg = "";
            if (resultcode == 1) {
                msg = "请先获取所填手机号验证码！";
            } else if (resultcode == 2) {
                msg = "验证码已失效，请重新获取！";
            } else if (resultcode == 3 || resultcode == 4) {
                msg = "无效的验证码！";
            }
            JSONObject object = new JSONObject();
            object.put("code", 0);
            object.put("msg", msg);
            return object;
        }
    }


    /**
     * 账号注销
     *
     * @param RequestContent
     * @return
     */
    @Path("logout")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSON logout(String RequestContent) throws YosException {
        DBConnect dbConnect = new DBConnect();
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new ReturnObject_Err().setErrMsg("请求正文格式错误，必须为JSONObject格式");
        }
        /**
         * 验证请求正文中是否包含必填的键值
         */
        String[] mustkeys = {"accesstoken"};
        for (String mustkey : mustkeys) {
            if (!requestcontent.containsKey(mustkey)) {
                return new ReturnObject_Err().setErrMsg("json缺少KEY" + mustkey);
            }
        }
        /**
         * 验证正文中的token是否有效
         */
        String accesstoken = requestcontent.getString("accesstoken");
        long usersiteid = parameter.tokenlist.get(accesstoken);
        parameter.tokenlist.remove(accesstoken);
        parameter.tokenSessionidlist.remove(accesstoken);
        parameter.tokenendtimemillis.remove(accesstoken);
        SQLProcess.cleanPool(accesstoken);
        QuerySQL.cleanDataLimitRowsMapPool(accesstoken);

        if (parameter.websocketClients.containsKey(usersiteid)) {
            parameter.websocketClients.get(usersiteid).get(accesstoken).onClose();
        }

        dbConnect.runSqlUpdate("update sys_usersite set  sessionid=null, accesstoken=null,systemclient=null where accesstoken='" + accesstoken + "'");
        JSONObject object = new JSONObject();
        object.put("status", "ok");
        return object;
    }


    /**
     * 微信扫码支付回调接口
     *
     * @param RequestContent
     * @return
     */
    @POST
    @Path("wechatpay/wechatpaycallback_native")
    @Produces(MediaType.APPLICATION_JSON)
    public JSON wechatpaycallback_native(String RequestContent) {
        boolean success = false;
        try {
            JSONObject returnobject = JSONObject.parseObject(RequestContent);
            success = NativePay.updatePayOrder_CallBack(returnobject);
        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject request = new JSONObject();
        request.put("code", success ? "SUCCESS" : "FAIL");
        request.put("websocketcontroller/message", success ? "成功" : "校验失败");
        return request;
    }

    /**
     * 微信支付回调接口
     *
     * @param RequestContent
     * @return
     */
    @POST
    @Path("wechatpay/wechatpaycallback")
    @Produces(MediaType.TEXT_PLAIN)
    public String wechatpaycallback(String RequestContent) {
        boolean success = false;
        try {
            QueryOrderRequest queryOrderRequest = new QueryOrderRequest();
            WechatOrder order = queryOrderRequest.getWechatOrder(RequestContent);
            success = WechatPay.updatePayOrder(order);
        } catch (Exception e) {
            e.printStackTrace();
        }
        DOMElement request = new DOMElement("xml");
        request.addElement("return_code").addText(success ? "SUCCESS" : "FAIL");
        request.addElement("return_msg").addText(success ? "OK" : "校验失败");
        return request.asXML();
    }

    /**
     * 系统运行监控信息查询
     *
     * @return
     * @throws JSONException
     */
    @Path("sysmsg")
    @GET
    @Produces({MediaType.TEXT_HTML})
    public String sysmsg() throws JSONException {
        return new sysmsg().getSystemMsg();
    }

    /**
     * 系统运行日志查询
     *
     * @return
     * @throws Exception
     */
    @Path("syslog")
    @GET
    @Produces({"text/plain;charset=UTF-8"})
    public String syslog() throws Exception {
        return new syslog().getSystemLog();
    }


    /**
     * 系统数据库差异对比
     *
     * @return
     * @throws Exception
     */
    @Path("dbcontrast")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSON dbcontrast(@Context HttpServletRequest request, @Context HttpServletResponse response, String RequestContent) throws YosException {
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            return new JSONArray();
        }
        String contrast_token = requestcontent.getStringValue("contrast_token");
        if (contrast_token != null && !contrast_token.equals("") && contrast_token.equals(Parameter.get("system_db_contrast_token"))) {
            return new database_contrast(new JSONObject()).queryDBContrast();
        } else {
            return new JSONArray();
        }
    }
}
