package common.data;

import beans.parameter.Parameter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

public class EasyExcelFactory extends BaseClass {
    private String filename;
    public static String filetype = "xlsx";
    String filepath = "";
    private InputStream inputStream;

    public EasyExcelFactory(String filename) throws YosException {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : (p + "/");
        filepath = p + this.filename + "." + filetype;
    }

    /**
     * 根据InputStream生成一个excel文件
     */
    public EasyExcelFactory(InputStream inputStream) throws YosException {
        this.filename = String.valueOf(Calendar.getInstance().getTimeInMillis());
        this.inputStream = inputStream;
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : (p + "/");
        filepath = p + this.filename + "." + filetype;
    }

    /**
     * 根据InputStream生成一个excel文件
     */
    public EasyExcelFactory(String filename, InputStream inputStream) throws YosException {
        this.filename = filename;
        this.inputStream = inputStream;
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : (p + "/");
        filepath = p + this.filename + "." + filetype;
    }

    public EasyExcelFactory(String filename, File file) throws IOException {
        this.filename = filename;
        this.inputStream = new FileInputStream(file);
        filepath = file.getPath();
    }

    public void write(String sheetname, Rows datarows) throws YosException {
        write(sheetname, datarows, new HashMap<>());
    }

    public void write(String sheetname, Rows datarows, HashMap<String, String> titlemap) throws YosException {
        File parentfile = new File(filepath).getParentFile();
        if (!parentfile.exists()) {
            parentfile.mkdirs();
        }

        List<List<String>> titlelist = new ArrayList<>();
        for (String fieldname : datarows.getFieldList()) {
            List<String> list = new ArrayList<>();
            list.add(titlemap.getOrDefault(fieldname, fieldname));
            titlelist.add(list);
        }
        ArrayList<ArrayList<Object>> datalist = datarows.toListList();
        try (ExcelWriter excelWriter = EasyExcel.write(filepath).build()) {
            // 这里注意 如果同一个sheet只要创建一次
            WriteSheet writeSheet = EasyExcel.writerSheet(sheetname).registerWriteHandler(getStyle()).head(titlelist).build();

            ArrayList<ArrayList<Object>> datalist_cache = new ArrayList<>();
            int count = 1;
            for (ArrayList<Object> objects : datalist) {
                if (count <= 5000) {
                    datalist_cache.add(objects);
                }
                if (count == 5000) {
                    count = 0;
                    excelWriter.write(datalist_cache, writeSheet);
                    datalist_cache.clear();
                }
                count++;
            }
            if (!datalist_cache.isEmpty()) {
                excelWriter.write(datalist_cache, writeSheet);
                datalist_cache.clear();
            }
        }
        // EasyExcel.write(filepath).registerWriteHandler(a()).head(titlelists).sheet(sheetname).doWrite(datarows.toListList());
    }

    public void write(String sheetname, JSONArray exportFieldsArray, JSONArray dataArrays) throws YosException {
        File parentfile = new File(filepath).getParentFile();
        if (!parentfile.exists()) {
            parentfile.mkdirs();
        }

        List<List<String>> titlelist = new ArrayList<>();
        ArrayList<String> fieldlist = new ArrayList<>();
        for (int i = 0; i < exportFieldsArray.size(); i++) {
            JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);
            List<String> list = new ArrayList<>();
            list.add(exportFieldObjet.getStringValue("fieldlabel"));
            titlelist.add(list);
            fieldlist.add(exportFieldObjet.getStringValue("fieldname"));
        }

        try (ExcelWriter excelWriter = EasyExcel.write(filepath).build()) {
            // 这里注意 如果同一个sheet只要创建一次
            WriteSheet writeSheet = EasyExcel.writerSheet(sheetname).registerWriteHandler(getStyle()).head(titlelist).build();

            List<List<Object>> datalist_cache = new ArrayList<>();
            int count = 1;
            for (Object o : dataArrays) {
                JSONObject dataObject = (JSONObject) o;

                List<Object> datarow = new ArrayList<>();
                for (String fieldname : fieldlist) {
                    if (dataObject.get(fieldname) instanceof JSON) {
                        dataObject.put(fieldname, dataObject.getString(fieldname));
                    }
                    datarow.add((dataObject).getOrDefault(fieldname, ""));
                }
                datalist_cache.add(datarow);
                if (count == 5000) {
                    count = 0;
                    excelWriter.write(datalist_cache, writeSheet);
                    datalist_cache.clear();
                }
                count++;
            }
            if (!datalist_cache.isEmpty()) {
                excelWriter.write(datalist_cache, writeSheet);
                datalist_cache.clear();
            }
        } finally {
            dataArrays.clear();
        }
        // EasyExcel.write(Parameter.get("system_excelexport_path") + this.filename + "." + filetype).registerWriteHandler(a()).head(titlelists).sheet(sheetname).doWrite(datalists);
    }

    public Rows read(ArrayList<String> fieldlist, int rowindex) {
        return read(0, fieldlist, new HashMap<>(), rowindex);
    }

    public Rows read(int sheetindex, ArrayList<String> fieldlist, int rowindex) {
        return read(sheetindex, fieldlist, new HashMap<>(), rowindex);
    }

    public Rows read(ArrayList<String> fieldlist, HashMap<String, FieldType> celltypemap, int rowindex) {
        return read(0, fieldlist, celltypemap, rowindex);
    }

    public Rows read(int sheetindex, ArrayList<String> fieldlist, HashMap<String, FieldType> celltypemap, int rowindex) {
        Rows rows = new Rows();
        EasyExcel.read(inputStream, new AnalysisEventListener<Map<Integer, String>>() {
            @Override
            public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
                Row row = new Row();
                for (int index : data.keySet()) {
                    String fieldname = fieldlist.get(index);
                    Object value = data.get(index);
                    if (celltypemap.containsKey(fieldname) && value != null) {
                        switch (celltypemap.get(fieldname)) {
                            case Smallint:
                            case Int:
                            case BigInt: {
                                value = Long.parseLong((String) value);
                                break;
                            }
                            case Decimal: {
                                value = Double.parseDouble((String) value);
                                break;
                            }
                            case JSON: {
                                value = JSON.parse((String) value);
                                break;
                            }
                        }
                    }
                    row.put(fieldname, value);
                }
                rows.add(row);
            }

            @Override
            public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                try {
                    inputStream.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).sheet(sheetindex).headRowNumber(rowindex).doRead();
        return rows;
    }


    private HorizontalCellStyleStrategy getStyle() {
        // 方法1 使用已有的策略 推荐
        // HorizontalCellStyleStrategy 每一行的样式都一样 或者隔行一样
        // AbstractVerticalCellStyleStrategy 每一列的样式都一样 需要自己回调每一页
        // 头的策略
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        // 背景设置为红色
        headWriteCellStyle.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints((short) 14);
        headWriteFont.setBold(true);
        headWriteCellStyle.setWriteFont(headWriteFont);
        // 内容的策略
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        // 这里需要指定 FillPatternType 为FillPatternType.SOLID_FOREGROUND 不然无法显示背景颜色.头默认了 FillPatternType所以可以不指定
        //contentWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        // 背景绿色
        // contentWriteCellStyle.setFillForegroundColor(IndexedColors.GREEN.getIndex());
        WriteFont contentWriteFont = new WriteFont();
        // 字体大小
        contentWriteFont.setFontHeightInPoints((short) 12);
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        // 这个策略是 头是头的样式 内容是内容的样式 其他的策略可以自己实现
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public String getFilename() {
        return this.filename + "." + filetype;
    }

    public String getFilepath() throws YosException {
        return Parameter.get("system_excelexport_path") + this.filename + "." + filetype;
    }

    public File getFile() throws YosException {
        return new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
    }

    public void deletefile() throws YosException {
        File file = new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
        file.delete();
    }


//    public static void main(String[] args) throws YosException {
//        Rows rows = new DBConnect().runSqlQuery("select * from sys_users");
//
//        JSONArray titleArray = new JSONArray();
//        {
//            JSONObject object = new JSONObject();
//            object.put("fieldlabel", "手机号");
//            object.put("fieldname", "phonenumber");
//            titleArray.add(object);
//        }
//
//        {
//            JSONObject object = new JSONObject();
//            object.put("fieldlabel", "用户id");
//            object.put("fieldname", "userid");
//            titleArray.add(object);
//        }
//        {
//            JSONObject object = new JSONObject();
//            object.put("fieldlabel", "用户状态");
//            object.put("fieldname", "status");
//            titleArray.add(object);
//        }
//        {
//            JSONObject object = new JSONObject();
//            object.put("fieldlabel", "用户名称");
//            object.put("fieldname", "name");
//            titleArray.add(object);
//        }
//
//        EasyExcelFactory easyExcelFactory = new EasyExcelFactory("asdsad");
//        easyExcelFactory.write("aa", titleArray, rows.toJsonArray());
//
//    }
}
